/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.properties;

import com.google.common.collect.ImmutableSortedSet;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.gradle.api.NonNullApi;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.api.internal.tasks.TaskDependencyContainer;
import org.gradle.api.internal.tasks.TaskPropertyUtils;
import org.gradle.api.internal.tasks.properties.CompositePropertyVisitor;
import org.gradle.api.internal.tasks.properties.DefaultFinalizingValidatingProperty;
import org.gradle.api.internal.tasks.properties.DefaultValidatingProperty;
import org.gradle.api.internal.tasks.properties.GetInputFilesVisitor;
import org.gradle.api.internal.tasks.properties.GetInputPropertiesVisitor;
import org.gradle.api.internal.tasks.properties.InputFilePropertySpec;
import org.gradle.api.internal.tasks.properties.InputPropertySpec;
import org.gradle.api.internal.tasks.properties.LifecycleAwareValue;
import org.gradle.api.internal.tasks.properties.OutputFilePropertySpec;
import org.gradle.api.internal.tasks.properties.OutputFilesCollector;
import org.gradle.api.internal.tasks.properties.OutputUnpacker;
import org.gradle.api.internal.tasks.properties.PropertyValidationContext;
import org.gradle.api.internal.tasks.properties.TaskProperties;
import org.gradle.api.internal.tasks.properties.ValidatingProperty;
import org.gradle.api.internal.tasks.properties.ValidationActions;
import org.gradle.api.tasks.TaskExecutionException;
import org.gradle.internal.fingerprint.DirectorySensitivity;
import org.gradle.internal.fingerprint.FileNormalizer;
import org.gradle.internal.fingerprint.LineEndingSensitivity;
import org.gradle.internal.properties.InputBehavior;
import org.gradle.internal.properties.InputFilePropertyType;
import org.gradle.internal.properties.PropertyValue;
import org.gradle.internal.properties.PropertyVisitor;
import org.gradle.internal.properties.bean.PropertyWalker;
import org.gradle.internal.reflect.validation.ReplayingTypeValidationContext;
import org.gradle.internal.reflect.validation.TypeValidationContext;

@NonNullApi
public class DefaultTaskProperties
implements TaskProperties {
    private final ImmutableSortedSet<InputPropertySpec> inputProperties;
    private final ImmutableSortedSet<InputFilePropertySpec> inputFileProperties;
    private final ImmutableSortedSet<OutputFilePropertySpec> outputFileProperties;
    private final boolean hasDeclaredOutputs;
    private final ReplayingTypeValidationContext validationProblems;
    private final FileCollection localStateFiles;
    private final FileCollection destroyableFiles;
    private final List<ValidatingProperty> validatingProperties;

    public static TaskProperties resolve(PropertyWalker propertyWalker, FileCollectionFactory fileCollectionFactory, TaskInternal task) {
        String beanName = task.toString();
        GetInputPropertiesVisitor inputPropertiesVisitor = new GetInputPropertiesVisitor();
        GetInputFilesVisitor inputFilesVisitor = new GetInputFilesVisitor(beanName, fileCollectionFactory);
        ValidationVisitor validationVisitor = new ValidationVisitor();
        OutputFilesCollector outputFilesCollector = new OutputFilesCollector();
        OutputUnpacker outputUnpacker = new OutputUnpacker(beanName, fileCollectionFactory, true, true, OutputUnpacker.UnpackedOutputConsumer.composite(outputFilesCollector, validationVisitor));
        GetLocalStateVisitor localStateVisitor = new GetLocalStateVisitor(beanName, fileCollectionFactory);
        GetDestroyablesVisitor destroyablesVisitor = new GetDestroyablesVisitor(beanName, fileCollectionFactory);
        ReplayingTypeValidationContext validationContext = new ReplayingTypeValidationContext();
        try {
            TaskPropertyUtils.visitProperties(propertyWalker, task, (TypeValidationContext)validationContext, new CompositePropertyVisitor(inputPropertiesVisitor, inputFilesVisitor, outputUnpacker, validationVisitor, destroyablesVisitor, localStateVisitor));
        }
        catch (Exception e) {
            throw new TaskExecutionException(task, e);
        }
        return new DefaultTaskProperties(inputPropertiesVisitor.getProperties(), inputFilesVisitor.getFileProperties(), outputFilesCollector.getFileProperties(), outputUnpacker.hasDeclaredOutputs(), localStateVisitor.getFiles(), destroyablesVisitor.getFiles(), validationVisitor.getTaskPropertySpecs(), validationContext);
    }

    private DefaultTaskProperties(ImmutableSortedSet<InputPropertySpec> inputProperties, ImmutableSortedSet<InputFilePropertySpec> inputFileProperties, ImmutableSortedSet<OutputFilePropertySpec> outputFileProperties, boolean hasDeclaredOutputs, FileCollection localStateFiles, FileCollection destroyableFiles, List<ValidatingProperty> validatingProperties, ReplayingTypeValidationContext validationProblems) {
        this.validatingProperties = validatingProperties;
        this.validationProblems = validationProblems;
        this.inputProperties = inputProperties;
        this.inputFileProperties = inputFileProperties;
        this.outputFileProperties = outputFileProperties;
        this.hasDeclaredOutputs = hasDeclaredOutputs;
        this.localStateFiles = localStateFiles;
        this.destroyableFiles = destroyableFiles;
    }

    @Override
    public Iterable<? extends LifecycleAwareValue> getLifecycleAwareValues() {
        return this.validatingProperties;
    }

    @Override
    public ImmutableSortedSet<OutputFilePropertySpec> getOutputFileProperties() {
        return this.outputFileProperties;
    }

    @Override
    public ImmutableSortedSet<InputFilePropertySpec> getInputFileProperties() {
        return this.inputFileProperties;
    }

    @Override
    public void validateType(TypeValidationContext validationContext) {
        this.validationProblems.replay(null, validationContext);
    }

    @Override
    public void validate(PropertyValidationContext validationContext) {
        for (ValidatingProperty validatingProperty : this.validatingProperties) {
            validatingProperty.validate(validationContext);
        }
    }

    @Override
    public boolean hasDeclaredOutputs() {
        return this.hasDeclaredOutputs;
    }

    @Override
    public ImmutableSortedSet<InputPropertySpec> getInputProperties() {
        return this.inputProperties;
    }

    @Override
    public FileCollection getLocalStateFiles() {
        return this.localStateFiles;
    }

    @Override
    public FileCollection getDestroyableFiles() {
        return this.destroyableFiles;
    }

    private static class ResolvingValue
    implements PropertyValue {
        private final PropertyValue delegate;
        private final Function<Object, Object> resolver;

        public ResolvingValue(PropertyValue delegate, Function<Object, Object> resolver) {
            this.delegate = delegate;
            this.resolver = resolver;
        }

        public TaskDependencyContainer getTaskDependencies() {
            return this.delegate.getTaskDependencies();
        }

        public void maybeFinalizeValue() {
            this.delegate.maybeFinalizeValue();
        }

        @Nullable
        public Object call() {
            return this.resolver.apply(this.delegate.call());
        }
    }

    private static class ValidationVisitor
    implements OutputUnpacker.UnpackedOutputConsumer,
    PropertyVisitor {
        private final List<ValidatingProperty> taskPropertySpecs = new ArrayList<ValidatingProperty>();

        private ValidationVisitor() {
        }

        public void visitInputFileProperty(String propertyName, boolean optional, InputBehavior behavior, DirectorySensitivity directorySensitivity, LineEndingSensitivity lineEndingSensitivity, @Nullable FileNormalizer fileNormalizer, PropertyValue value, InputFilePropertyType filePropertyType) {
            this.taskPropertySpecs.add(new DefaultFinalizingValidatingProperty(propertyName, value, optional, ValidationActions.inputValidationActionFor(filePropertyType)));
        }

        public void visitInputProperty(String propertyName, PropertyValue value, boolean optional) {
            this.taskPropertySpecs.add(new DefaultValidatingProperty(propertyName, value, optional, ValidationActions.NO_OP));
        }

        @Override
        public void visitUnpackedOutputFileProperty(String propertyName, boolean optional, PropertyValue value, OutputFilePropertySpec spec) {
            this.taskPropertySpecs.add(new DefaultValidatingProperty(propertyName, new ResolvingValue(value, delegate -> spec.getOutputFile()), optional, ValidationActions.outputValidationActionFor(spec)));
        }

        @Override
        public void visitEmptyOutputFileProperty(String propertyName, boolean optional, PropertyValue value) {
            this.taskPropertySpecs.add(new DefaultValidatingProperty(propertyName, value, optional, ValidationActions.NO_OP));
        }

        public void visitServiceReference(String propertyName, boolean optional, PropertyValue value, @Nullable String serviceName) {
            this.taskPropertySpecs.add(new DefaultValidatingProperty(propertyName, value, optional, ValidationActions.NO_OP));
        }

        public List<ValidatingProperty> getTaskPropertySpecs() {
            return this.taskPropertySpecs;
        }
    }

    private static class GetDestroyablesVisitor
    implements PropertyVisitor {
        private final String beanName;
        private final FileCollectionFactory fileCollectionFactory;
        private final List<Object> destroyables = new ArrayList<Object>();

        public GetDestroyablesVisitor(String beanName, FileCollectionFactory fileCollectionFactory) {
            this.beanName = beanName;
            this.fileCollectionFactory = fileCollectionFactory;
        }

        public void visitDestroyableProperty(Object value) {
            this.destroyables.add(value);
        }

        public FileCollection getFiles() {
            return this.fileCollectionFactory.resolvingLeniently(this.beanName + " destroy files", this.destroyables);
        }
    }

    private static class GetLocalStateVisitor
    implements PropertyVisitor {
        private final String beanName;
        private final FileCollectionFactory fileCollectionFactory;
        private final List<Object> localState = new ArrayList<Object>();

        public GetLocalStateVisitor(String beanName, FileCollectionFactory fileCollectionFactory) {
            this.beanName = beanName;
            this.fileCollectionFactory = fileCollectionFactory;
        }

        public void visitLocalStateProperty(Object value) {
            this.localState.add(value);
        }

        public FileCollection getFiles() {
            return this.fileCollectionFactory.resolvingLeniently(this.beanName + " local state", this.localState);
        }
    }
}

