/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.daemon;

import java.io.InputStream;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.daemon.common.DummyProfiler;
import org.jetbrains.kotlin.daemon.common.Profiler;
import org.jetbrains.kotlin.daemon.common.RemoteInputStream;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\fH\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/daemon/RemoteInputStreamClient;", "Ljava/io/InputStream;", "remote", "Lorg/jetbrains/kotlin/daemon/common/RemoteInputStream;", "profiler", "Lorg/jetbrains/kotlin/daemon/common/Profiler;", "(Lorg/jetbrains/kotlin/daemon/common/RemoteInputStream;Lorg/jetbrains/kotlin/daemon/common/Profiler;)V", "getProfiler", "()Lorg/jetbrains/kotlin/daemon/common/Profiler;", "getRemote", "()Lorg/jetbrains/kotlin/daemon/common/RemoteInputStream;", "read", "", "data", "", "offset", "length", "kotlin-daemon"})
public final class RemoteInputStreamClient
extends InputStream {
    @NotNull
    private final RemoteInputStream remote;
    @NotNull
    private final Profiler profiler;

    public RemoteInputStreamClient(@NotNull RemoteInputStream remote, @NotNull Profiler profiler) {
        Intrinsics.checkNotNullParameter((Object)remote, (String)"remote");
        Intrinsics.checkNotNullParameter((Object)profiler, (String)"profiler");
        this.remote = remote;
        this.profiler = profiler;
    }

    public /* synthetic */ RemoteInputStreamClient(RemoteInputStream remoteInputStream, Profiler profiler, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            profiler = new DummyProfiler();
        }
        this(remoteInputStream, profiler);
    }

    @NotNull
    public final RemoteInputStream getRemote() {
        return this.remote;
    }

    @NotNull
    public final Profiler getProfiler() {
        return this.profiler;
    }

    @Override
    public int read(@NotNull byte[] data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return this.read(data, 0, data.length);
    }

    @Override
    public int read(@NotNull byte[] data, int offset, int length) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Profiler $this$withMeasure$iv = this.profiler;
        boolean $i$f$withMeasure = false;
        List<Long> startState$iv = $this$withMeasure$iv.beginMeasure(this);
        boolean bl2 = false;
        byte[] bytes = this.remote.read(length);
        boolean bl3 = bl = bytes.length <= length;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        System.arraycopy(bytes, 0, data, offset, length);
        int res$iv = bytes.length;
        $this$withMeasure$iv.endMeasure(this, startState$iv);
        return res$iv;
    }

    @Override
    public int read() {
        Profiler $this$withMeasure$iv = this.profiler;
        boolean $i$f$withMeasure = false;
        List<Long> startState$iv = $this$withMeasure$iv.beginMeasure(this);
        boolean bl = false;
        int res$iv = this.remote.read();
        $this$withMeasure$iv.endMeasure(this, startState$iv);
        return res$iv;
    }
}

