/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.backend.common.IrElementTransformerVoidWithContext;
import org.jetbrains.kotlin.backend.common.lower.DeclarationIrBuilder;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.JvmLoweredDeclarationOrigin;
import org.jetbrains.kotlin.backend.jvm.lower.EnumClassLoweringKt;
import org.jetbrains.kotlin.backend.jvm.lower.MappedEnumWhenLoweringKt;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.builders.declarations.DeclarationBuildersKt;
import org.jetbrains.kotlin.ir.builders.declarations.IrClassBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.IrFieldBuilder;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrFactory;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetFieldImpl;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.SpecialNames;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002:\u0001\u0016B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\f\u0010\u0014\u001a\u00020\u0015*\u00020\u0013H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0018\u00010\u0007R\u00020\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/EnumExternalEntriesLowering;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "Lorg/jetbrains/kotlin/backend/common/IrElementTransformerVoidWithContext;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "state", "Lorg/jetbrains/kotlin/backend/jvm/lower/EnumExternalEntriesLowering$EntriesMappingState;", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "visitCall", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "visitClassNew", "Lorg/jetbrains/kotlin/ir/IrStatement;", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "hasEnumEntriesFunction", "", "EntriesMappingState", "backend.jvm.lower"})
public final class EnumExternalEntriesLowering
extends IrElementTransformerVoidWithContext
implements FileLoweringPass {
    @NotNull
    private final JvmBackendContext context;
    @Nullable
    private EntriesMappingState state;

    public EnumExternalEntriesLowering(@NotNull JvmBackendContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
        if (!this.context.getState().getLanguageVersionSettings().supportsFeature(LanguageFeature.EnumEntries)) {
            return;
        }
        IrElementTransformerVoidKt.transformChildrenVoid(irFile, this);
    }

    @Override
    @NotNull
    public IrExpression visitCall(@NotNull IrCall expression2) {
        boolean shouldBeLowered;
        IrSimpleFunction owner;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Object b = expression2.getSymbol().getOwner();
        IrSimpleFunction irSimpleFunction = owner = b instanceof IrSimpleFunction ? (IrSimpleFunction)b : null;
        IrDeclarationParent irDeclarationParent = irSimpleFunction != null ? irSimpleFunction.getParent() : null;
        IrClass irClass2 = irDeclarationParent instanceof IrClass ? (IrClass)irDeclarationParent : null;
        if (irClass2 == null) {
            return super.visitCall(expression2);
        }
        IrClass parentClass = irClass2;
        boolean bl = shouldBeLowered = IrUtilsKt.isEnumClass(parentClass) && Intrinsics.areEqual((Object)owner.getName(), (Object)SpecialNames.ENUM_GET_ENTRIES) && (IrUtilsKt.isFromJava(parentClass) || !this.hasEnumEntriesFunction(parentClass));
        if (!shouldBeLowered) {
            return super.visitCall(expression2);
        }
        EntriesMappingState entriesMappingState = this.state;
        Intrinsics.checkNotNull((Object)entriesMappingState);
        IrField field2 = entriesMappingState.getEntriesFieldForEnum(parentClass);
        return new IrGetFieldImpl(expression2.getStartOffset(), expression2.getEndOffset(), field2.getSymbol(), field2.getType(), null, null, 48, null);
    }

    private final boolean hasEnumEntriesFunction(IrClass $this$hasEnumEntriesFunction) {
        boolean bl;
        block1: {
            Sequence<IrSimpleFunction> $this$any$iv = IrUtilsKt.getFunctions($this$hasEnumEntriesFunction);
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                IrSimpleFunction it = (IrSimpleFunction)element$iv;
                boolean bl2 = false;
                boolean bl3 = Intrinsics.areEqual((Object)it.getName().toString(), (Object)"<get-entries>") && it.getDispatchReceiverParameter() == null && it.getExtensionReceiverParameter() == null && it.getValueParameters().isEmpty();
                if (!bl3) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    @Override
    @NotNull
    public IrStatement visitClassNew(@NotNull IrClass declaration) {
        EntriesMappingState mappingState;
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        EntriesMappingState oldState = this.state;
        this.state = mappingState = new EntriesMappingState();
        super.visitClassNew(declaration);
        for (Map.Entry<IrClass, IrField> object : mappingState.getMappings().entrySet()) {
            IrClass irClass2 = object.getKey();
            IrField field2 = object.getValue();
            IrSimpleFunction enumValues = MappedEnumWhenLoweringKt.findEnumValuesFunction(irClass2, this.context);
            IrType enumArrayType = field2.getType();
            DeclarationIrBuilder builder2 = LowerUtilsKt.createIrBuilder$default(this.context, (IrSymbol)field2.getSymbol(), 0, 0, 6, null);
            field2.setInitializer(EnumClassLoweringKt.irCreateEnumEntriesIndy(builder2, enumValues, enumArrayType, this.context));
        }
        if (!mappingState.getMappings().isEmpty()) {
            IrClass irClass2;
            Collection collection = declaration.getDeclarations();
            IrClass $this$visitClassNew_u24lambda_u241 = irClass2 = mappingState.getMappingsClass();
            boolean bl = false;
            $this$visitClassNew_u24lambda_u241.setParent(declaration);
            IrClass irClass3 = irClass2;
            collection.add(irClass3);
        }
        this.state = oldState;
        return declaration;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0005R\u001d\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001b\u0010\t\u001a\u00020\u00058FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/EnumExternalEntriesLowering$EntriesMappingState;", "", "(Lorg/jetbrains/kotlin/backend/jvm/lower/EnumExternalEntriesLowering;)V", "mappings", "", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "getMappings", "()Ljava/util/Map;", "mappingsClass", "getMappingsClass", "()Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "mappingsClass$delegate", "Lkotlin/Lazy;", "getEntriesFieldForEnum", "enumClass", "backend.jvm.lower"})
    private final class EntriesMappingState {
        @NotNull
        private final Map<IrClass, IrField> mappings = new LinkedHashMap();
        @NotNull
        private final Lazy mappingsClass$delegate = LazyKt.lazy((Function0)((Function0)new Function0<IrClass>(EnumExternalEntriesLowering.this){
            final /* synthetic */ EnumExternalEntriesLowering this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final IrClass invoke() {
                IrClass irClass2;
                IrFactory $this$buildClass$iv = EnumExternalEntriesLowering.access$getContext$p(this.this$0).getIrFactory();
                boolean $i$f$buildClass = false;
                IrClassBuilder $this$buildClass_u24lambda_u241$iv = new IrClassBuilder();
                boolean bl = false;
                IrClassBuilder $this$invoke_u24lambda_u240 = $this$buildClass_u24lambda_u241$iv;
                boolean bl2 = false;
                Name name = Name.identifier("EntriesMappings");
                Intrinsics.checkNotNullExpressionValue((Object)name, (String)"identifier(\"EntriesMappings\")");
                $this$invoke_u24lambda_u240.setName(name);
                $this$invoke_u24lambda_u240.setOrigin(JvmLoweredDeclarationOrigin.ENUM_MAPPINGS_FOR_ENTRIES.INSTANCE);
                IrClass $this$invoke_u24lambda_u241 = irClass2 = DeclarationBuildersKt.buildClass($this$buildClass$iv, $this$buildClass_u24lambda_u241$iv);
                boolean bl3 = false;
                IrUtilsKt.createImplicitParameterDeclarationWithWrappedDescriptor($this$invoke_u24lambda_u241);
                return irClass2;
            }
        }));

        @NotNull
        public final Map<IrClass, IrField> getMappings() {
            return this.mappings;
        }

        @NotNull
        public final IrClass getMappingsClass() {
            Lazy lazy = this.mappingsClass$delegate;
            return (IrClass)lazy.getValue();
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final IrField getEntriesFieldForEnum(@NotNull IrClass enumClass2) {
            Object object;
            void $this$getOrPut$iv;
            Intrinsics.checkNotNullParameter((Object)enumClass2, (String)"enumClass");
            Map<IrClass, IrField> map = this.mappings;
            EnumExternalEntriesLowering enumExternalEntriesLowering = EnumExternalEntriesLowering.this;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(enumClass2);
            if (value$iv == null) {
                IrField irField;
                boolean bl = false;
                IrClass $this$addField$iv = this.getMappingsClass();
                boolean $i$f$addField = false;
                IrFactory $this$buildField$iv$iv = $this$addField$iv.getFactory();
                boolean $i$f$buildField = false;
                IrFieldBuilder $this$buildField_u24lambda_u244$iv$iv = new IrFieldBuilder();
                boolean bl2 = false;
                IrFieldBuilder $this$getEntriesFieldForEnum_u24lambda_u241_u24lambda_u240 = $this$buildField_u24lambda_u244$iv$iv;
                boolean bl3 = false;
                Name name = Name.identifier("entries$" + this.mappings.size());
                Intrinsics.checkNotNullExpressionValue((Object)name, (String)"identifier(\"entries\\$${mappings.size}\")");
                $this$getEntriesFieldForEnum_u24lambda_u241_u24lambda_u240.setName(name);
                IrType[] irTypeArray = new IrType[]{IrUtilsKt.getDefaultType(enumClass2)};
                $this$getEntriesFieldForEnum_u24lambda_u241_u24lambda_u240.setType(IrTypesKt.typeWith((IrClassifierSymbol)enumExternalEntriesLowering.context.getIr().getSymbols().getEnumEntries(), irTypeArray));
                $this$getEntriesFieldForEnum_u24lambda_u241_u24lambda_u240.setOrigin(JvmLoweredDeclarationOrigin.ENUM_MAPPINGS_FOR_ENTRIES.INSTANCE);
                $this$getEntriesFieldForEnum_u24lambda_u241_u24lambda_u240.setFinal(true);
                $this$getEntriesFieldForEnum_u24lambda_u241_u24lambda_u240.setStatic(true);
                IrField field$iv = irField = DeclarationBuildersKt.buildField($this$buildField$iv$iv, $this$buildField_u24lambda_u244$iv$iv);
                boolean bl4 = false;
                field$iv.setParent($this$addField$iv);
                $this$addField$iv.getDeclarations().add(field$iv);
                IrField answer$iv = irField;
                $this$getOrPut$iv.put(enumClass2, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            return (IrField)object;
        }
    }
}

