/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental.classpathDiff;

import java.io.DataInput;
import java.io.DataOutput;
import java.util.Collection;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.util.io.DataExternalizer;
import org.jetbrains.kotlin.incremental.ConstantValueExternalizer;
import org.jetbrains.kotlin.incremental.KotlinClassInfo;
import org.jetbrains.kotlin.incremental.classpathDiff.ClassIdExternalizerWithInterning;
import org.jetbrains.kotlin.incremental.storage.ClassIdExternalizer;
import org.jetbrains.kotlin.incremental.storage.InlineFunctionOrAccessorExternalizer;
import org.jetbrains.kotlin.incremental.storage.IntExternalizer;
import org.jetbrains.kotlin.incremental.storage.ListExternalizer;
import org.jetbrains.kotlin.incremental.storage.LongExternalizer;
import org.jetbrains.kotlin.incremental.storage.MapExternalizer;
import org.jetbrains.kotlin.incremental.storage.NullableValueExternalizer;
import org.jetbrains.kotlin.incremental.storage.StringExternalizer;
import org.jetbrains.kotlin.inline.InlineFunctionOrAccessor;
import org.jetbrains.kotlin.load.kotlin.header.KotlinClassHeader;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/incremental/classpathDiff/KotlinClassInfoExternalizer;", "Lorg/jetbrains/kotlin/com/intellij/util/io/DataExternalizer;", "Lorg/jetbrains/kotlin/incremental/KotlinClassInfo;", "()V", "read", "input", "Ljava/io/DataInput;", "save", "", "output", "Ljava/io/DataOutput;", "info", "incremental-compilation-impl"})
public final class KotlinClassInfoExternalizer
implements DataExternalizer<KotlinClassInfo> {
    @NotNull
    public static final KotlinClassInfoExternalizer INSTANCE = new KotlinClassInfoExternalizer();

    private KotlinClassInfoExternalizer() {
    }

    @Override
    public void save(@NotNull DataOutput output, @NotNull KotlinClassInfo info) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        ClassIdExternalizer.INSTANCE.save(output, info.getClassId());
        IntExternalizer.INSTANCE.save(output, info.getClassKind().getId());
        new ListExternalizer(StringExternalizer.INSTANCE).save(output, (Collection)ArraysKt.toList((Object[])info.getClassHeaderData()));
        new ListExternalizer(StringExternalizer.INSTANCE).save(output, (Collection)ArraysKt.toList((Object[])info.getClassHeaderStrings()));
        new NullableValueExternalizer<String>(StringExternalizer.INSTANCE).save(output, info.getMultifileClassName());
        new MapExternalizer(StringExternalizer.INSTANCE, ConstantValueExternalizer.INSTANCE, null, 4, null).save(output, info.getConstantsMap());
        new MapExternalizer(InlineFunctionOrAccessorExternalizer.INSTANCE, LongExternalizer.INSTANCE, null, 4, null).save(output, info.getInlineFunctionsAndAccessorsMap());
    }

    @Override
    @NotNull
    public KotlinClassInfo read(@NotNull DataInput input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Object $this$toTypedArray$iv = new ListExternalizer(StringExternalizer.INSTANCE).read(input);
        boolean $i$f$toTypedArray = false;
        Object thisCollection$iv = $this$toTypedArray$iv;
        $this$toTypedArray$iv = new ListExternalizer(StringExternalizer.INSTANCE).read(input);
        $i$f$toTypedArray = false;
        thisCollection$iv = $this$toTypedArray$iv;
        return new KotlinClassInfo(ClassIdExternalizerWithInterning.INSTANCE.read(input), KotlinClassHeader.Kind.Companion.getById(IntExternalizer.INSTANCE.read(input)), thisCollection$iv.toArray(new String[0]), thisCollection$iv.toArray(new String[0]), (String)new NullableValueExternalizer(StringExternalizer.INSTANCE).read(input), (Map<String, ? extends Object>)new MapExternalizer(StringExternalizer.INSTANCE, ConstantValueExternalizer.INSTANCE, null, 4, null).read(input), (Map<InlineFunctionOrAccessor, Long>)new MapExternalizer(InlineFunctionOrAccessorExternalizer.INSTANCE, LongExternalizer.INSTANCE, null, 4, null).read(input));
    }
}

