/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.detection;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import org.gradle.api.internal.classpath.ModuleRegistry;
import org.gradle.api.internal.tasks.testing.TestFramework;
import org.gradle.api.internal.tasks.testing.worker.ForkedTestClasspath;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.util.internal.CollectionUtils;

public class ForkedTestClasspathFactory {
    private static final Logger LOGGER = Logging.getLogger(ForkedTestClasspathFactory.class);
    private final ModuleRegistry moduleRegistry;

    public ForkedTestClasspathFactory(ModuleRegistry moduleRegistry) {
        this.moduleRegistry = moduleRegistry;
    }

    public ForkedTestClasspath create(Iterable<? extends File> classpath, Iterable<? extends File> modulepath, TestFramework testFramework, boolean isModule) {
        if (!testFramework.getUseDistributionDependencies()) {
            return new ForkedTestClasspath(ImmutableList.copyOf(classpath), ImmutableList.copyOf(modulepath), this.withImplementation((List<URL>)ImmutableList.of()), ImmutableList.of());
        }
        if (isModule) {
            return new ForkedTestClasspath(this.pathWithAdditionalJars(classpath, testFramework.getWorkerApplicationClasspathModuleNames()), this.pathWithAdditionalJars(modulepath, testFramework.getWorkerApplicationModulepathModuleNames()), this.withImplementation((List<URL>)this.loadDistributionUrls(testFramework.getWorkerImplementationClasspathModuleNames())), this.loadDistributionUrls(testFramework.getWorkerImplementationModulepathModuleNames()));
        }
        ImmutableList additionalApplicationClasspath = ImmutableList.builder().addAll(testFramework.getWorkerApplicationClasspathModuleNames()).addAll(testFramework.getWorkerApplicationModulepathModuleNames()).build();
        ImmutableList additionalImplementationClasspath = ImmutableList.builder().addAll(testFramework.getWorkerImplementationClasspathModuleNames()).addAll(testFramework.getWorkerImplementationModulepathModuleNames()).build();
        return new ForkedTestClasspath(this.pathWithAdditionalJars(classpath, (List<String>)additionalApplicationClasspath), ImmutableList.copyOf(modulepath), this.withImplementation((List<URL>)this.loadDistributionUrls((List<String>)additionalImplementationClasspath)), ImmutableList.of());
    }

    private ImmutableList<URL> withImplementation(List<URL> additionalImplementationClasspath) {
        return ImmutableList.copyOf((Collection)CollectionUtils.flattenCollections(URL.class, (Object[])new Object[]{this.moduleRegistry.getModule("gradle-core-api").getImplementationClasspath().getAsURLs(), this.moduleRegistry.getModule("gradle-worker-processes").getImplementationClasspath().getAsURLs(), this.moduleRegistry.getModule("gradle-core").getImplementationClasspath().getAsURLs(), this.moduleRegistry.getModule("gradle-logging").getImplementationClasspath().getAsURLs(), this.moduleRegistry.getModule("gradle-logging-api").getImplementationClasspath().getAsURLs(), this.moduleRegistry.getModule("gradle-messaging").getImplementationClasspath().getAsURLs(), this.moduleRegistry.getModule("gradle-files").getImplementationClasspath().getAsURLs(), this.moduleRegistry.getModule("gradle-file-temp").getImplementationClasspath().getAsURLs(), this.moduleRegistry.getModule("gradle-hashing").getImplementationClasspath().getAsURLs(), this.moduleRegistry.getModule("gradle-base-services").getImplementationClasspath().getAsURLs(), this.moduleRegistry.getModule("gradle-enterprise-logging").getImplementationClasspath().getAsURLs(), this.moduleRegistry.getModule("gradle-enterprise-workers").getImplementationClasspath().getAsURLs(), this.moduleRegistry.getModule("gradle-cli").getImplementationClasspath().getAsURLs(), this.moduleRegistry.getModule("gradle-native").getImplementationClasspath().getAsURLs(), this.moduleRegistry.getModule("gradle-testing-base").getImplementationClasspath().getAsURLs(), this.moduleRegistry.getModule("gradle-testing-jvm-infrastructure").getImplementationClasspath().getAsURLs(), this.moduleRegistry.getModule("gradle-testing-junit-platform").getImplementationClasspath().getAsURLs(), this.moduleRegistry.getModule("gradle-process-services").getImplementationClasspath().getAsURLs(), this.moduleRegistry.getModule("gradle-build-operations").getImplementationClasspath().getAsURLs(), this.moduleRegistry.getExternalModule("slf4j-api").getImplementationClasspath().getAsURLs(), this.moduleRegistry.getExternalModule("jul-to-slf4j").getImplementationClasspath().getAsURLs(), this.moduleRegistry.getExternalModule("native-platform").getImplementationClasspath().getAsURLs(), this.moduleRegistry.getExternalModule("kryo").getImplementationClasspath().getAsURLs(), this.moduleRegistry.getExternalModule("commons-lang").getImplementationClasspath().getAsURLs(), this.moduleRegistry.getExternalModule("javax.inject").getImplementationClasspath().getAsURLs(), additionalImplementationClasspath}));
    }

    private ImmutableList<File> pathWithAdditionalJars(Iterable<? extends File> testFiles, List<String> additionalModules) {
        return ImmutableList.builder().addAll(testFiles).addAll(this.loadDistributionFiles(additionalModules)).build();
    }

    private ImmutableList<File> loadDistributionFiles(List<String> moduleNames) {
        return this.loadFromDistribution(moduleNames, ClassPath::getAsFiles);
    }

    private ImmutableList<URL> loadDistributionUrls(List<String> moduleNames) {
        return this.loadFromDistribution(moduleNames, ClassPath::getAsURLs);
    }

    private <T> ImmutableList<T> loadFromDistribution(List<String> moduleNames, Function<ClassPath, List<T>> extractor) {
        ImmutableList.Builder outputFiles = ImmutableList.builder();
        if (LOGGER.isDebugEnabled() && !moduleNames.isEmpty()) {
            LOGGER.debug("Loaded additional modules from the Gradle distribution: " + Joiner.on((String)",").join(moduleNames));
        }
        for (String module : moduleNames) {
            ClassPath cp = this.moduleRegistry.getExternalModule(module).getImplementationClasspath();
            outputFiles.addAll((Iterable)extractor.apply(cp));
        }
        return outputFiles.build();
    }
}

