/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.antlr.internal.antlr2;

import antlr.Parser;
import antlr.TreeParser;
import java.io.File;
import org.gradle.api.plugins.antlr.internal.antlr2.GrammarDelegate;
import org.gradle.api.plugins.antlr.internal.antlr2.GrammarFileMetadata;

public class GrammarMetadata {
    private final GrammarFileMetadata grammarFileMetadata;
    private final GrammarDelegate grammarDelegate;

    public GrammarMetadata(GrammarFileMetadata grammarFileMetadata, GrammarDelegate grammarDelegate) {
        this.grammarFileMetadata = grammarFileMetadata;
        this.grammarDelegate = grammarDelegate;
        grammarDelegate.associateWith(this);
    }

    public GrammarFileMetadata getGrammarFile() {
        return this.grammarFileMetadata;
    }

    public String getClassName() {
        return this.grammarDelegate.getClassName();
    }

    public String getQualifiedClassName() {
        if (this.isEmpty(this.getPackageName())) {
            return this.getClassName();
        }
        return this.getPackageName() + '.' + this.getClassName();
    }

    public GrammarDelegate getSuperGrammarDelegate() {
        return this.grammarDelegate.getSuperGrammarDelegate();
    }

    public boolean extendsStandardGrammar() {
        String superGrammarClassName = this.getSuperGrammarDelegate().getClassName();
        return Parser.class.getName().equals(superGrammarClassName) || Parser.class.getSimpleName().equals(superGrammarClassName) || TreeParser.class.getName().equals(superGrammarClassName) || TreeParser.class.getSimpleName().equals(superGrammarClassName) || "Lexer".equals(superGrammarClassName);
    }

    public String getImportVocab() {
        return this.grammarDelegate.getImportVocab();
    }

    public String getExportVocab() {
        return this.grammarDelegate.getExportVocab();
    }

    public String getPackageName() {
        return this.getGrammarFile().getPackageName();
    }

    public String determineGeneratedParserPath() {
        if (this.isEmpty(this.getPackageName())) {
            return this.getClassName() + ".java";
        }
        return this.getPackageName().replace('.', File.separatorChar) + File.separatorChar + this.getClassName() + ".java";
    }

    private boolean isEmpty(String packageName) {
        return packageName == null || packageName.trim().length() == 0;
    }
}

