/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph;

import java.util.Arrays;
import java.util.List;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyGraphNode;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyGraphSelector;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyGraphVisitor;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.RootGraphNode;

public class CompositeDependencyGraphVisitor
implements DependencyGraphVisitor {
    private final List<DependencyGraphVisitor> visitors;

    public CompositeDependencyGraphVisitor(DependencyGraphVisitor ... visitors) {
        this.visitors = Arrays.asList(visitors);
    }

    @Override
    public void start(RootGraphNode root) {
        for (DependencyGraphVisitor visitor : this.visitors) {
            visitor.start(root);
        }
    }

    @Override
    public void visitNode(DependencyGraphNode node) {
        for (DependencyGraphVisitor visitor : this.visitors) {
            visitor.visitNode(node);
        }
    }

    @Override
    public void visitSelector(DependencyGraphSelector selector) {
        for (DependencyGraphVisitor visitor : this.visitors) {
            visitor.visitSelector(selector);
        }
    }

    @Override
    public void visitEdges(DependencyGraphNode node) {
        for (DependencyGraphVisitor visitor : this.visitors) {
            visitor.visitEdges(node);
        }
    }

    @Override
    public void finish(DependencyGraphNode root) {
        for (DependencyGraphVisitor visitor : this.visitors) {
            visitor.finish(root);
        }
    }
}

