/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.process.internal;

import com.google.common.collect.Maps;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.gradle.internal.file.PathToFileResolver;
import org.gradle.internal.jvm.Jvm;
import org.gradle.process.ProcessForkOptions;

public class DefaultProcessForkOptions
implements ProcessForkOptions {
    private final PathToFileResolver resolver;
    private Object executable;
    private File workingDir;
    private Map<String, Object> environment;

    public DefaultProcessForkOptions(PathToFileResolver resolver) {
        this.resolver = resolver;
    }

    public String getExecutable() {
        return this.executable == null ? null : this.executable.toString();
    }

    public void setExecutable(String executable) {
        this.executable = executable;
    }

    public void setExecutable(Object executable) {
        this.executable = executable;
    }

    public ProcessForkOptions executable(Object executable) {
        this.setExecutable(executable);
        return this;
    }

    public File getWorkingDir() {
        if (this.workingDir == null) {
            this.workingDir = this.resolver.resolve((Object)".");
        }
        return this.workingDir;
    }

    public void setWorkingDir(File dir) {
        this.workingDir = this.resolver.resolve((Object)dir);
    }

    public void setWorkingDir(Object dir) {
        this.workingDir = this.resolver.resolve(dir);
    }

    public ProcessForkOptions workingDir(Object dir) {
        this.setWorkingDir(dir);
        return this;
    }

    public Map<String, Object> getEnvironment() {
        if (this.environment == null) {
            this.setEnvironment(Jvm.current().getInheritableEnvironmentVariables(System.getenv()));
        }
        return this.environment;
    }

    public Map<String, String> getActualEnvironment() {
        return DefaultProcessForkOptions.getActualEnvironment(this);
    }

    public static Map<String, String> getActualEnvironment(ProcessForkOptions forkOptions) {
        HashMap<String, String> actual = new HashMap<String, String>();
        for (Map.Entry entry : forkOptions.getEnvironment().entrySet()) {
            actual.put((String)entry.getKey(), String.valueOf(entry.getValue()));
        }
        return actual;
    }

    public void setEnvironment(Map<String, ?> environmentVariables) {
        this.environment = Maps.newHashMap(environmentVariables);
    }

    public ProcessForkOptions environment(String name, Object value) {
        this.getEnvironment().put(name, value);
        return this;
    }

    public ProcessForkOptions environment(Map<String, ?> environmentVariables) {
        this.getEnvironment().putAll(environmentVariables);
        return this;
    }

    public ProcessForkOptions copyTo(ProcessForkOptions target) {
        target.setExecutable(this.executable);
        target.setWorkingDir(this.getWorkingDir());
        target.setEnvironment(this.getEnvironment());
        return this;
    }
}

