/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.initialization.transform;

import java.io.File;
import org.gradle.api.artifacts.transform.TransformOutputs;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.internal.initialization.transform.BaseInstrumentingArtifactTransform;
import org.gradle.api.internal.initialization.transform.InstrumentationArtifactMetadata;
import org.gradle.api.internal.initialization.transform.services.CacheInstrumentationDataBuildService;
import org.gradle.api.internal.initialization.transform.services.InjectedInstrumentationServices;
import org.gradle.api.internal.initialization.transform.utils.InstrumentationAnalysisSerializer;
import org.gradle.api.internal.initialization.transform.utils.InstrumentationTransformUtils;
import org.gradle.internal.classpath.types.InstrumentationTypeRegistry;
import org.gradle.internal.classpath.types.PropertiesBackedInstrumentationTypeRegistry;
import org.gradle.internal.instrumentation.api.types.BytecodeInterceptorFilter;
import org.gradle.work.DisableCachingByDefault;

@DisableCachingByDefault(because="Instrumented jars are too big to cache")
public abstract class ExternalDependencyInstrumentingArtifactTransform
extends BaseInstrumentingArtifactTransform {
    public void transform(TransformOutputs outputs) {
        File input = ((FileSystemLocation)this.getInput().get()).getAsFile();
        InstrumentationTransformUtils.InstrumentationInputType inputType = InstrumentationTransformUtils.getInputType(input);
        switch (inputType) {
            case DEPENDENCY_ANALYSIS_DATA: {
                this.doOutputTransformedFile(input, outputs);
                return;
            }
            case ORIGINAL_ARTIFACT: {
                if (((Boolean)((BaseInstrumentingArtifactTransform.Parameters)this.getParameters()).getAgentSupported().get()).booleanValue()) {
                    this.doOutputOriginalArtifact(input, outputs);
                }
                return;
            }
            case INSTRUMENTATION_MARKER: {
                return;
            }
        }
        throw new IllegalStateException("Unexpected input type: " + (Object)((Object)inputType));
    }

    private void doOutputTransformedFile(File input, TransformOutputs outputs) {
        InstrumentationArtifactMetadata metadata = this.readArtifactMetadata(input);
        long contextId = (Long)((BaseInstrumentingArtifactTransform.Parameters)this.getParameters()).getContextId().get();
        File originalArtifact = ((CacheInstrumentationDataBuildService)((BaseInstrumentingArtifactTransform.Parameters)this.getParameters()).getBuildService().get()).getOriginalFile(contextId, metadata);
        this.doTransform(originalArtifact, outputs);
    }

    private InstrumentationArtifactMetadata readArtifactMetadata(File input) {
        InstrumentationAnalysisSerializer serializer = new InstrumentationAnalysisSerializer(((InjectedInstrumentationServices)this.internalServices.get()).getStringInterner());
        return serializer.readMetadataOnly(input);
    }

    @Override
    protected BaseInstrumentingArtifactTransform.InterceptorTypeRegistryAndFilter provideInterceptorTypeRegistryAndFilter() {
        return new BaseInstrumentingArtifactTransform.InterceptorTypeRegistryAndFilter(){

            @Override
            public InstrumentationTypeRegistry getRegistry() {
                return PropertiesBackedInstrumentationTypeRegistry.of(() -> {
                    File analysisFile = ((FileSystemLocation)ExternalDependencyInstrumentingArtifactTransform.this.getInput().get()).getAsFile();
                    InstrumentationAnalysisSerializer serializer = new InstrumentationAnalysisSerializer(((InjectedInstrumentationServices)ExternalDependencyInstrumentingArtifactTransform.this.internalServices.get()).getStringInterner());
                    return serializer.readDependencyAnalysis(analysisFile).getDependencies();
                });
            }

            @Override
            public BytecodeInterceptorFilter getFilter() {
                return BytecodeInterceptorFilter.ALL;
            }
        };
    }
}

