/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.project;

import com.google.common.base.Strings;
import groovy.lang.Closure;
import groovy.lang.MissingPropertyException;
import groovy.lang.Script;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.AntBuilder;
import org.gradle.api.CircularReferenceException;
import org.gradle.api.InvalidUserCodeException;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.NamedDomainObjectFactory;
import org.gradle.api.PathValidation;
import org.gradle.api.Project;
import org.gradle.api.ProjectConfigurationException;
import org.gradle.api.ProjectEvaluationListener;
import org.gradle.api.Task;
import org.gradle.api.UnknownProjectException;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.dsl.ArtifactHandler;
import org.gradle.api.artifacts.dsl.DependencyFactory;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.artifacts.dsl.DependencyLockingHandler;
import org.gradle.api.artifacts.dsl.RepositoryHandler;
import org.gradle.api.component.SoftwareComponentContainer;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.ConfigurableFileTree;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.DeleteSpec;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.file.SyncSpec;
import org.gradle.api.internal.CollectionCallbackActionDecorator;
import org.gradle.api.internal.DomainObjectContext;
import org.gradle.api.internal.DynamicObjectAware;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.MutationGuards;
import org.gradle.api.internal.ProcessOperations;
import org.gradle.api.internal.artifacts.DependencyManagementServices;
import org.gradle.api.internal.artifacts.DependencyResolutionServices;
import org.gradle.api.internal.artifacts.configurations.DependencyMetaDataProvider;
import org.gradle.api.internal.artifacts.configurations.RoleBasedConfigurationContainerInternal;
import org.gradle.api.internal.artifacts.dsl.dependencies.UnknownProjectFinder;
import org.gradle.api.internal.collections.DomainObjectCollectionFactory;
import org.gradle.api.internal.file.DefaultProjectLayout;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.api.internal.file.FileOperations;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.initialization.ClassLoaderScope;
import org.gradle.api.internal.initialization.ScriptHandlerFactory;
import org.gradle.api.internal.initialization.ScriptHandlerInternal;
import org.gradle.api.internal.plugins.DefaultObjectConfigurationAction;
import org.gradle.api.internal.plugins.ExtensionContainerInternal;
import org.gradle.api.internal.plugins.PluginManagerInternal;
import org.gradle.api.internal.project.AbstractPluginAware;
import org.gradle.api.internal.project.CrossProjectConfigurator;
import org.gradle.api.internal.project.CrossProjectModelAccess;
import org.gradle.api.internal.project.DefaultIsolatedProject;
import org.gradle.api.internal.project.DeferredProjectConfiguration;
import org.gradle.api.internal.project.DynamicLookupRoutine;
import org.gradle.api.internal.project.ProjectIdentifier;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.project.ProjectOrderingUtil;
import org.gradle.api.internal.project.ProjectState;
import org.gradle.api.internal.project.ProjectStateInternal;
import org.gradle.api.internal.project.taskfactory.TaskInstantiator;
import org.gradle.api.internal.tasks.TaskContainerInternal;
import org.gradle.api.internal.tasks.TaskDependencyFactory;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.Convention;
import org.gradle.api.plugins.ExtensionContainer;
import org.gradle.api.project.IsolatedProject;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.resources.ResourceHandler;
import org.gradle.api.tasks.WorkResult;
import org.gradle.configuration.ScriptPluginFactory;
import org.gradle.configuration.internal.ListenerBuildOperationDecorator;
import org.gradle.configuration.project.ProjectConfigurationActionContainer;
import org.gradle.configuration.project.ProjectEvaluator;
import org.gradle.groovy.scripts.ScriptSource;
import org.gradle.internal.Actions;
import org.gradle.internal.Cast;
import org.gradle.internal.Factories;
import org.gradle.internal.Factory;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.internal.dispatch.Dispatch;
import org.gradle.internal.event.ListenerBroadcast;
import org.gradle.internal.extensibility.ExtensibleDynamicObject;
import org.gradle.internal.extensibility.NoConventionMapping;
import org.gradle.internal.file.RelativeFilePathResolver;
import org.gradle.internal.instantiation.InstantiatorFactory;
import org.gradle.internal.logging.LoggingManagerInternal;
import org.gradle.internal.logging.StandardOutputCapture;
import org.gradle.internal.metaobject.BeanDynamicObject;
import org.gradle.internal.metaobject.DynamicObject;
import org.gradle.internal.model.ModelContainer;
import org.gradle.internal.model.RuleBasedPluginListener;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.resource.TextUriResourceLoader;
import org.gradle.internal.service.DefaultServiceRegistry;
import org.gradle.internal.service.ServiceLookup;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.internal.service.scopes.ServiceRegistryFactory;
import org.gradle.internal.typeconversion.TypeConverter;
import org.gradle.listener.ClosureBackedMethodInvocationDispatch;
import org.gradle.model.Model;
import org.gradle.model.RuleSource;
import org.gradle.model.dsl.internal.NonTransformedModelDslBacking;
import org.gradle.model.dsl.internal.TransformedModelDslBacking;
import org.gradle.model.internal.core.DefaultNodeInitializerRegistry;
import org.gradle.model.internal.core.Hidden;
import org.gradle.model.internal.core.ModelReference;
import org.gradle.model.internal.core.ModelRegistrations;
import org.gradle.model.internal.core.NamedEntityInstantiator;
import org.gradle.model.internal.core.NodeInitializerRegistry;
import org.gradle.model.internal.manage.binding.StructBindingsStore;
import org.gradle.model.internal.manage.instance.ManagedProxyFactory;
import org.gradle.model.internal.manage.schema.ModelSchemaStore;
import org.gradle.model.internal.registry.ModelRegistry;
import org.gradle.model.internal.type.ModelType;
import org.gradle.normalization.InputNormalizationHandler;
import org.gradle.normalization.internal.InputNormalizationHandlerInternal;
import org.gradle.process.ExecResult;
import org.gradle.process.ExecSpec;
import org.gradle.process.JavaExecSpec;
import org.gradle.util.Path;
import org.gradle.util.internal.ClosureBackedAction;
import org.gradle.util.internal.ConfigureUtil;
import org.gradle.util.internal.GUtil;

@NoConventionMapping
public abstract class DefaultProject
extends AbstractPluginAware
implements ProjectInternal,
DynamicObjectAware {
    private static final ModelType<ServiceRegistry> SERVICE_REGISTRY_MODEL_TYPE = ModelType.of(ServiceRegistry.class);
    private static final ModelType<File> FILE_MODEL_TYPE = ModelType.of(File.class);
    private static final ModelType<ProjectIdentifier> PROJECT_IDENTIFIER_MODEL_TYPE = ModelType.of(ProjectIdentifier.class);
    private static final ModelType<ExtensionContainer> EXTENSION_CONTAINER_MODEL_TYPE = ModelType.of(ExtensionContainer.class);
    private static final Logger BUILD_LOGGER = Logging.getLogger(Project.class);
    private final ProjectState owner;
    private final ClassLoaderScope classLoaderScope;
    private final ClassLoaderScope baseClassLoaderScope;
    private final ServiceRegistry services;
    private final ProjectInternal rootProject;
    private final GradleInternal gradle;
    private final ScriptSource buildScriptSource;
    private final File projectDir;
    private final File buildFile;
    @Nullable
    private final ProjectInternal parent;
    private final String name;
    private Object group;
    private Object version;
    private Property<Object> status;
    private List<String> defaultTasks = new ArrayList<String>();
    private final ProjectStateInternal state;
    private FileResolver fileResolver;
    private TaskDependencyFactory taskDependencyFactory;
    private Factory<AntBuilder> antBuilderFactory;
    private AntBuilder ant;
    private final int depth;
    private final TaskContainerInternal taskContainer;
    private DependencyHandler dependencyHandler;
    private RoleBasedConfigurationContainerInternal configurationContainer;
    private ArtifactHandler artifactHandler;
    private ListenerBroadcast<ProjectEvaluationListener> evaluationListener = this.newProjectEvaluationListenerBroadcast();
    private final ListenerBroadcast<RuleBasedPluginListener> ruleBasedPluginListenerBroadcast = new ListenerBroadcast(RuleBasedPluginListener.class);
    private final ExtensibleDynamicObject extensibleDynamicObject;
    private final DynamicLookupRoutine dynamicLookupRoutine;
    private String description;
    private boolean preparedForRuleBasedPlugins;

    public DefaultProject(String name, @Nullable ProjectInternal parent, File projectDir, File buildFile, ScriptSource buildScriptSource, GradleInternal gradle, ProjectState owner, ServiceRegistryFactory serviceRegistryFactory, ClassLoaderScope selfClassLoaderScope, ClassLoaderScope baseClassLoaderScope) {
        this.owner = owner;
        this.classLoaderScope = selfClassLoaderScope;
        this.baseClassLoaderScope = baseClassLoaderScope;
        this.rootProject = parent != null ? parent.getRootProject() : this;
        this.projectDir = projectDir;
        this.buildFile = buildFile;
        this.parent = parent;
        this.name = name;
        this.state = new ProjectStateInternal();
        this.buildScriptSource = buildScriptSource;
        this.gradle = gradle;
        this.depth = parent == null ? 0 : parent.getDepth() + 1;
        this.services = serviceRegistryFactory.createFor(this);
        this.taskContainer = (TaskContainerInternal)this.services.get(TaskContainerInternal.class);
        this.extensibleDynamicObject = new ExtensibleDynamicObject((Object)this, Project.class, ((InstantiatorFactory)this.services.get(InstantiatorFactory.class)).decorateLenient((ServiceLookup)this.services));
        DynamicObject parentInherited = ((CrossProjectModelAccess)this.services.get(CrossProjectModelAccess.class)).parentProjectDynamicInheritedScope(this);
        if (parentInherited != null) {
            this.extensibleDynamicObject.setParent(parentInherited);
        }
        this.extensibleDynamicObject.addObject(this.taskContainer.getTasksAsDynamicObject(), ExtensibleDynamicObject.Location.AfterConvention);
        this.evaluationListener.add((Object)gradle.getProjectEvaluationBroadcaster());
        this.ruleBasedPluginListenerBroadcast.add(project -> this.populateModelRegistry((ModelRegistry)this.services.get(ModelRegistry.class)));
        this.dynamicLookupRoutine = (DynamicLookupRoutine)this.services.get(DynamicLookupRoutine.class);
    }

    private ListenerBroadcast<ProjectEvaluationListener> newProjectEvaluationListenerBroadcast() {
        return new ListenerBroadcast(ProjectEvaluationListener.class);
    }

    private void populateModelRegistry(ModelRegistry modelRegistry) {
        this.registerServiceOn(modelRegistry, "serviceRegistry", SERVICE_REGISTRY_MODEL_TYPE, this.services, this.instanceDescriptorFor("serviceRegistry"));
        this.registerFactoryOn(modelRegistry, "buildDir", FILE_MODEL_TYPE, () -> (File)this.getLayout().getBuildDirectory().getAsFile().get());
        this.registerInstanceOn(modelRegistry, "projectIdentifier", PROJECT_IDENTIFIER_MODEL_TYPE, this);
        this.registerInstanceOn(modelRegistry, "extensionContainer", EXTENSION_CONTAINER_MODEL_TYPE, this.getExtensions());
        modelRegistry.getRoot().applyToSelf(BasicServicesRules.class);
    }

    private <T> void registerInstanceOn(ModelRegistry modelRegistry, String path, ModelType<T> type, T instance) {
        this.registerFactoryOn(modelRegistry, path, type, Factories.constant(instance));
    }

    private <T> void registerFactoryOn(ModelRegistry modelRegistry, String path, ModelType<T> type, Factory<T> factory) {
        modelRegistry.register(ModelRegistrations.unmanagedInstance((ModelReference)ModelReference.of((String)path, type), factory).descriptor(this.instanceDescriptorFor(path)).hidden(true).build());
    }

    private <T> void registerServiceOn(ModelRegistry modelRegistry, String path, ModelType<T> type, T instance, String descriptor) {
        modelRegistry.register(ModelRegistrations.serviceInstance((ModelReference)ModelReference.of((String)path, type), instance).descriptor(descriptor).build());
    }

    private String instanceDescriptorFor(String path) {
        return "Project.<init>." + path + "()";
    }

    @Override
    public ProjectInternal getRootProject() {
        return this.getRootProject(this);
    }

    @Override
    public ProjectInternal getRootProject(ProjectInternal referrer) {
        return this.getCrossProjectModelAccess().access(referrer, this.rootProject);
    }

    @Override
    public GradleInternal getGradle() {
        return this.getCrossProjectModelAccess().gradleInstanceForProject(this, this.gradle);
    }

    @Inject
    protected abstract ProjectEvaluator getProjectEvaluator();

    @Override
    @Inject
    public abstract ScriptHandlerInternal getBuildscript();

    @Override
    public File getBuildFile() {
        return this.buildFile;
    }

    @Override
    public void setScript(Script buildScript) {
        this.extensibleDynamicObject.addObject((DynamicObject)new BeanDynamicObject((Object)buildScript).withNoProperties().withNotImplementsMissing(), ExtensibleDynamicObject.Location.BeforeConvention);
    }

    @Override
    public ScriptSource getBuildScriptSource() {
        return this.buildScriptSource;
    }

    public File getRootDir() {
        return this.rootProject.getProjectDir();
    }

    @Override
    @Nullable
    public ProjectInternal getParent() {
        return this.getParent(this);
    }

    @Override
    @Nullable
    public ProjectInternal getParent(ProjectInternal referrer) {
        if (this.parent == null) {
            return null;
        }
        return this.getCrossProjectModelAccess().access(referrer, this.parent);
    }

    @Override
    @Nullable
    public ProjectIdentifier getParentIdentifier() {
        return this.parent;
    }

    public DynamicObject getAsDynamicObject() {
        return this.extensibleDynamicObject;
    }

    @Override
    public DynamicObject getInheritedScope() {
        return this.extensibleDynamicObject.getInheritable();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    public void setDescription(@Nullable String description) {
        this.description = description;
    }

    public Object getGroup() {
        if (this.group != null) {
            return this.group;
        }
        if (this == this.rootProject) {
            return "";
        }
        this.group = this.rootProject.getName() + (this.getParent() == this.rootProject ? "" : "." + this.getParent().getPath().substring(1).replace(':', '.'));
        return this.group;
    }

    public void setGroup(Object group) {
        this.group = group;
    }

    public Object getVersion() {
        return this.version == null ? "unspecified" : this.version;
    }

    public void setVersion(Object version) {
        this.version = version;
    }

    public Object getStatus() {
        return this.getInternalStatus().get();
    }

    public void setStatus(Object s) {
        this.getInternalStatus().set(s);
    }

    @Override
    public Property<Object> getInternalStatus() {
        if (this.status == null) {
            this.status = this.getObjects().property(Object.class).convention((Object)"release");
        }
        return this.status;
    }

    @Override
    public Map<String, Project> getChildProjectsUnchecked() {
        TreeMap<String, Project> childProjects = new TreeMap<String, Project>();
        for (ProjectState project : this.owner.getChildProjects()) {
            childProjects.put(project.getName(), project.getMutableModel());
        }
        return childProjects;
    }

    @Override
    public Map<String, Project> getChildProjects() {
        return this.getCrossProjectModelAccess().getChildProjects(this, this);
    }

    public List<String> getDefaultTasks() {
        return this.defaultTasks;
    }

    public void setDefaultTasks(List<String> defaultTasks) {
        this.defaultTasks = defaultTasks;
    }

    @Override
    public ProjectStateInternal getState() {
        return this.state;
    }

    @Override
    public FileResolver getFileResolver() {
        if (this.fileResolver == null) {
            this.fileResolver = (FileResolver)this.services.get(FileResolver.class);
        }
        return this.fileResolver;
    }

    @Override
    public TaskDependencyFactory getTaskDependencyFactory() {
        if (this.taskDependencyFactory == null) {
            this.taskDependencyFactory = (TaskDependencyFactory)this.services.get(TaskDependencyFactory.class);
        }
        return this.taskDependencyFactory;
    }

    public void setFileResolver(FileResolver fileResolver) {
        this.fileResolver = fileResolver;
    }

    public void setAnt(AntBuilder ant) {
        this.ant = ant;
    }

    public ArtifactHandler getArtifacts() {
        if (this.artifactHandler == null) {
            this.artifactHandler = (ArtifactHandler)this.services.get(ArtifactHandler.class);
        }
        return this.artifactHandler;
    }

    @Inject
    public abstract RepositoryHandler getRepositories();

    @Override
    public RoleBasedConfigurationContainerInternal getConfigurations() {
        if (this.configurationContainer == null) {
            this.configurationContainer = (RoleBasedConfigurationContainerInternal)this.services.get(RoleBasedConfigurationContainerInternal.class);
        }
        return this.configurationContainer;
    }

    @Deprecated
    public Convention getConvention() {
        return this.extensibleDynamicObject.getConvention();
    }

    @Override
    public String getPath() {
        return this.owner.getProjectPath().toString();
    }

    public String getBuildTreePath() {
        return this.getIdentityPath().getPath();
    }

    @Override
    public Path getIdentityPath() {
        return this.owner.getIdentityPath();
    }

    public int getDepth() {
        return this.depth;
    }

    @Inject
    protected abstract CrossProjectModelAccess getCrossProjectModelAccess();

    public int depthCompare(Project otherProject) {
        return ProjectOrderingUtil.depthCompare(this, otherProject);
    }

    public int compareTo(Project otherProject) {
        return ProjectOrderingUtil.compare(this, otherProject);
    }

    public String absoluteProjectPath(String path) {
        return this.getProjectPath().absolutePath(path);
    }

    @Override
    public Path identityPath(String name) {
        return this.getIdentityPath().child(name);
    }

    @Override
    @Nonnull
    public Path getProjectPath() {
        return this.owner.getProjectPath();
    }

    public ModelContainer<ProjectInternal> getModel() {
        return this.getOwner();
    }

    @Override
    public Path getBuildPath() {
        return this.gradle.getIdentityPath();
    }

    @Override
    public Path projectPath(String name) {
        return this.getProjectPath().child(name);
    }

    @Override
    public boolean isScript() {
        return false;
    }

    @Override
    public boolean isRootScript() {
        return false;
    }

    @Override
    public boolean isPluginContext() {
        return false;
    }

    public String relativeProjectPath(String path) {
        return this.getProjectPath().relativePath(path);
    }

    @Override
    public ProjectInternal project(String path) {
        return this.project(this, path);
    }

    @Override
    public ProjectInternal project(ProjectInternal referrer, String path) throws UnknownProjectException {
        ProjectInternal project = this.getCrossProjectModelAccess().findProject(referrer, this, path);
        if (project == null) {
            throw new UnknownProjectException(String.format("Project with path '%s' could not be found in %s.", path, this));
        }
        return project;
    }

    @Override
    public ProjectInternal findProject(String path) {
        return this.findProject(this, path);
    }

    @Override
    @Nullable
    public ProjectInternal findProject(ProjectInternal referrer, String path) {
        return this.getCrossProjectModelAccess().findProject(referrer, this, path);
    }

    public Set<Project> getAllprojects() {
        return (Set)Cast.uncheckedCast(this.getAllprojects(this));
    }

    @Override
    public Set<? extends ProjectInternal> getAllprojects(ProjectInternal referrer) {
        return this.getCrossProjectModelAccess().getAllprojects(referrer, this);
    }

    public void allprojects(Closure configureClosure) {
        this.allprojects(this, (Action<? super Project>)ConfigureUtil.configureUsing((Closure)configureClosure));
    }

    public void allprojects(Action<? super Project> action) {
        this.allprojects(this, action);
    }

    @Override
    public void allprojects(ProjectInternal referrer, Action<? super Project> action) {
        this.getProjectConfigurator().allprojects(this.getCrossProjectModelAccess().getAllprojects(referrer, this), action);
    }

    public Set<Project> getSubprojects() {
        return (Set)Cast.uncheckedCast(this.getSubprojects(this));
    }

    @Override
    public Set<? extends ProjectInternal> getSubprojects(ProjectInternal referrer) {
        return this.getCrossProjectModelAccess().getSubprojects(referrer, this);
    }

    public void subprojects(Closure configureClosure) {
        this.subprojects(this, (Action<? super Project>)ConfigureUtil.configureUsing((Closure)configureClosure));
    }

    public void subprojects(Action<? super Project> action) {
        this.subprojects(this, action);
    }

    @Override
    public void subprojects(ProjectInternal referrer, Action<? super Project> configureAction) {
        this.getProjectConfigurator().subprojects(this.getCrossProjectModelAccess().getSubprojects(referrer, this), configureAction);
    }

    public <T> Iterable<T> configure(Iterable<T> objects, Action<? super T> configureAction) {
        for (T object : objects) {
            configureAction.execute(object);
        }
        return objects;
    }

    public AntBuilder getAnt() {
        if (this.ant == null) {
            this.ant = this.createAntBuilder();
        }
        return this.ant;
    }

    public AntBuilder createAntBuilder() {
        return (AntBuilder)this.getAntBuilderFactory().create();
    }

    @Override
    public ProjectInternal getProject() {
        return this;
    }

    public IsolatedProject getIsolated() {
        return new DefaultIsolatedProject(this, this.rootProject);
    }

    @Override
    public DefaultProject evaluate() {
        this.getProjectEvaluator().evaluate(this, this.state);
        return this;
    }

    @Override
    public ProjectInternal bindAllModelRules() {
        try {
            this.getModelRegistry().bindAllReferences();
        }
        catch (Exception e) {
            throw new ProjectConfigurationException(String.format("A problem occurred configuring %s.", this.getDisplayName()), (Throwable)e);
        }
        return this;
    }

    @Override
    public TaskContainerInternal getTasks() {
        return this.taskContainer;
    }

    public void defaultTasks(String ... defaultTasks) {
        if (defaultTasks == null) {
            throw new InvalidUserDataException("Default tasks must not be null!");
        }
        this.defaultTasks = new ArrayList<String>();
        for (String defaultTask : defaultTasks) {
            if (defaultTask == null) {
                throw new InvalidUserDataException("Default tasks must not be null!");
            }
            this.defaultTasks.add(defaultTask);
        }
    }

    @Override
    public File getProjectDir() {
        return this.projectDir;
    }

    @Deprecated
    public File getBuildDir() {
        return (File)this.getLayout().getBuildDirectory().getAsFile().get();
    }

    @Deprecated
    public void setBuildDir(File path) {
        this.setBuildDir((Object)path);
    }

    @Deprecated
    public void setBuildDir(Object path) {
        this.getLayout().setBuildDirectory(path);
    }

    public void evaluationDependsOnChildren() {
        for (ProjectState project : this.owner.getChildProjects()) {
            ProjectInternal defaultProjectToEvaluate = project.getMutableModel();
            this.evaluationDependsOn(defaultProjectToEvaluate);
        }
    }

    public Project evaluationDependsOn(String path) {
        if (Strings.isNullOrEmpty((String)path)) {
            throw new InvalidUserDataException("You must specify a project!");
        }
        ProjectInternal projectToEvaluate = this.project(path);
        return this.evaluationDependsOn(projectToEvaluate);
    }

    private Project evaluationDependsOn(ProjectInternal projectToEvaluate) {
        if (projectToEvaluate.getState().isConfiguring()) {
            throw new CircularReferenceException(String.format("Circular referencing during evaluation for %s.", projectToEvaluate));
        }
        projectToEvaluate.getOwner().ensureConfigured();
        return projectToEvaluate;
    }

    public String getDisplayName() {
        StringBuilder builder = new StringBuilder();
        if (this.parent == null && this.gradle.isRootBuild()) {
            builder.append("root project '");
            builder.append(this.name);
            builder.append('\'');
        } else {
            builder.append("project '");
            builder.append(this.getIdentityPath());
            builder.append("'");
        }
        return builder.toString();
    }

    public String toString() {
        return this.getDisplayName();
    }

    public Map<Project, Set<Task>> getAllTasks(boolean recursive) {
        final TreeMap<Project, Set<Task>> foundTargets = new TreeMap<Project, Set<Task>>();
        Action<Project> action = new Action<Project>(){

            public void execute(Project project) {
                ((ProjectInternal)project).getOwner().ensureTasksDiscovered();
                foundTargets.put(project, new TreeSet(project.getTasks()));
            }
        };
        if (recursive) {
            this.allprojects((Action<? super Project>)action);
        } else {
            action.execute((Object)this);
        }
        return foundTargets;
    }

    public Set<Task> getTasksByName(final String name, boolean recursive) {
        if (Strings.isNullOrEmpty((String)name)) {
            throw new InvalidUserDataException("Name is not specified!");
        }
        final HashSet<Task> foundTasks = new HashSet<Task>();
        Action<Project> action = new Action<Project>(){

            public void execute(Project project) {
                ((ProjectInternal)project).getOwner().ensureTasksDiscovered();
                Task task = (Task)project.getTasks().findByName(name);
                if (task != null) {
                    foundTasks.add(task);
                }
            }
        };
        if (recursive) {
            this.allprojects((Action<? super Project>)action);
        } else {
            action.execute((Object)this);
        }
        return foundTasks;
    }

    @Override
    @Inject
    public abstract FileOperations getFileOperations();

    @Inject
    public abstract ProviderFactory getProviders();

    @Inject
    public abstract ObjectFactory getObjects();

    @Inject
    public abstract DefaultProjectLayout getLayout();

    public File file(Object path) {
        return this.getFileOperations().file(path);
    }

    public File file(Object path, PathValidation validation) {
        return this.getFileOperations().file(path, validation);
    }

    public URI uri(Object path) {
        return this.getFileOperations().uri(path);
    }

    public ConfigurableFileCollection files(Object ... paths) {
        return this.getObjects().fileCollection().from(paths);
    }

    public ConfigurableFileCollection files(Object paths, Closure closure) {
        return (ConfigurableFileCollection)ConfigureUtil.configure((Closure)closure, (Object)this.files(paths));
    }

    public ConfigurableFileCollection files(Object paths, Action<? super ConfigurableFileCollection> configureAction) {
        ConfigurableFileCollection files = this.files(paths);
        configureAction.execute((Object)files);
        return files;
    }

    public ConfigurableFileTree fileTree(Object baseDir) {
        return this.getFileOperations().fileTree(baseDir);
    }

    public ConfigurableFileTree fileTree(Object baseDir, Closure closure) {
        return (ConfigurableFileTree)ConfigureUtil.configure((Closure)closure, (Object)this.fileTree(baseDir));
    }

    public ConfigurableFileTree fileTree(Object baseDir, Action<? super ConfigurableFileTree> configureAction) {
        ConfigurableFileTree fileTree = this.fileTree(baseDir);
        configureAction.execute((Object)fileTree);
        return fileTree;
    }

    public ConfigurableFileTree fileTree(Map<String, ?> args) {
        return this.getFileOperations().fileTree(args);
    }

    public FileTree zipTree(Object zipPath) {
        return this.getFileOperations().zipTree(zipPath);
    }

    public FileTree tarTree(Object tarPath) {
        return this.getFileOperations().tarTree(tarPath);
    }

    public <T> Provider<T> provider(Callable<? extends T> value) {
        return this.getProviders().provider(value);
    }

    public ResourceHandler getResources() {
        return this.getFileOperations().getResources();
    }

    public String relativePath(Object path) {
        return this.getFileOperations().relativePath(path);
    }

    public File mkdir(Object path) {
        return this.getFileOperations().mkdir(path);
    }

    public boolean delete(Object ... paths) {
        return this.getFileOperations().delete(paths);
    }

    public WorkResult delete(Action<? super DeleteSpec> action) {
        return this.getFileOperations().delete(action);
    }

    public Factory<AntBuilder> getAntBuilderFactory() {
        if (this.antBuilderFactory == null) {
            this.antBuilderFactory = this.services.getFactory(AntBuilder.class);
        }
        return this.antBuilderFactory;
    }

    public DependencyHandler getDependencies() {
        if (this.dependencyHandler == null) {
            this.dependencyHandler = (DependencyHandler)this.services.get(DependencyHandler.class);
        }
        return this.dependencyHandler;
    }

    @Inject
    public abstract DependencyFactory getDependencyFactory();

    @Override
    public ProjectEvaluationListener getProjectEvaluationBroadcaster() {
        return (ProjectEvaluationListener)this.evaluationListener.getSource();
    }

    public void beforeEvaluate(Action<? super Project> action) {
        this.assertMutatingMethodAllowed("beforeEvaluate(Action)");
        this.evaluationListener.add("beforeEvaluate", this.getListenerBuildOperationDecorator().decorate("Project.beforeEvaluate", action));
    }

    public void afterEvaluate(Action<? super Project> action) {
        this.assertMutatingMethodAllowed("afterEvaluate(Action)");
        this.failAfterProjectIsEvaluated("afterEvaluate(Action)");
        this.evaluationListener.add("afterEvaluate", this.getListenerBuildOperationDecorator().decorate("Project.afterEvaluate", action));
    }

    public void beforeEvaluate(Closure closure) {
        this.assertMutatingMethodAllowed("beforeEvaluate(Closure)");
        this.evaluationListener.add((Dispatch)new ClosureBackedMethodInvocationDispatch("beforeEvaluate", this.getListenerBuildOperationDecorator().decorate("Project.beforeEvaluate", (Closure)Cast.uncheckedNonnullCast((Object)closure))));
    }

    public void afterEvaluate(Closure closure) {
        this.assertMutatingMethodAllowed("afterEvaluate(Closure)");
        this.failAfterProjectIsEvaluated("afterEvaluate(Closure)");
        this.evaluationListener.add((Dispatch)new ClosureBackedMethodInvocationDispatch("afterEvaluate", this.getListenerBuildOperationDecorator().decorate("Project.afterEvaluate", (Closure)Cast.uncheckedNonnullCast((Object)closure))));
    }

    private void failAfterProjectIsEvaluated(String methodPrototype) {
        if (!this.state.isUnconfigured() && !this.state.isConfiguring()) {
            throw new InvalidUserCodeException("Cannot run Project." + methodPrototype + " when the project is already evaluated.");
        }
    }

    public Logger getLogger() {
        return BUILD_LOGGER;
    }

    @Override
    public StandardOutputCapture getStandardOutputCapture() {
        return this.getLogging();
    }

    @Inject
    public abstract LoggingManagerInternal getLogging();

    @Inject
    public abstract SoftwareComponentContainer getComponents();

    public void components(Action<? super SoftwareComponentContainer> configuration) {
        configuration.execute((Object)this.getComponents());
    }

    @Nullable
    public Object getProperty(String propertyName) {
        return this.property(propertyName);
    }

    @Nullable
    public Object invokeMethod(String name, Object args) {
        if (args instanceof Object[]) {
            return this.dynamicLookupRoutine.invokeMethod((DynamicObject)this.extensibleDynamicObject, name, (Object[])args);
        }
        return this.dynamicLookupRoutine.invokeMethod((DynamicObject)this.extensibleDynamicObject, name, args);
    }

    public Object property(String propertyName) throws MissingPropertyException {
        return this.dynamicLookupRoutine.property((DynamicObject)this.extensibleDynamicObject, propertyName);
    }

    public Object findProperty(String propertyName) {
        return this.dynamicLookupRoutine.findProperty((DynamicObject)this.extensibleDynamicObject, propertyName);
    }

    public void setProperty(String name, Object value) {
        this.dynamicLookupRoutine.setProperty((DynamicObject)this.extensibleDynamicObject, name, value);
    }

    public boolean hasProperty(String propertyName) {
        return this.dynamicLookupRoutine.hasProperty((DynamicObject)this.extensibleDynamicObject, propertyName);
    }

    public Map<String, ?> getProperties() {
        return this.dynamicLookupRoutine.getProperties((DynamicObject)this.extensibleDynamicObject);
    }

    public WorkResult copy(Closure closure) {
        return this.copy((Action<? super CopySpec>)ConfigureUtil.configureUsing((Closure)closure));
    }

    public WorkResult copy(Action<? super CopySpec> action) {
        return this.getFileOperations().copy(action);
    }

    public WorkResult sync(Action<? super SyncSpec> action) {
        return this.getFileOperations().sync(action);
    }

    public CopySpec copySpec(Closure closure) {
        return (CopySpec)ConfigureUtil.configure((Closure)closure, (Object)this.copySpec());
    }

    public CopySpec copySpec(Action<? super CopySpec> action) {
        return (CopySpec)Actions.with((Object)this.copySpec(), action);
    }

    public CopySpec copySpec() {
        return this.getFileOperations().copySpec();
    }

    @Override
    @Inject
    public abstract ProcessOperations getProcessOperations();

    public ExecResult javaexec(Closure closure) {
        return this.javaexec((Action<? super JavaExecSpec>)ConfigureUtil.configureUsing((Closure)closure));
    }

    public ExecResult javaexec(Action<? super JavaExecSpec> action) {
        return this.getProcessOperations().javaexec(action);
    }

    public ExecResult exec(Closure closure) {
        return this.exec((Action<? super ExecSpec>)ConfigureUtil.configureUsing((Closure)closure));
    }

    public ExecResult exec(Action<? super ExecSpec> action) {
        return this.getProcessOperations().exec(action);
    }

    @Override
    public ServiceRegistry getServices() {
        return this.services;
    }

    @Override
    public ServiceRegistryFactory getServiceRegistryFactory() {
        return (ServiceRegistryFactory)this.services.get(ServiceRegistryFactory.class);
    }

    @Override
    @Inject
    public abstract DependencyMetaDataProvider getDependencyMetaDataProvider();

    public AntBuilder ant(Closure configureClosure) {
        return (AntBuilder)ConfigureUtil.configure((Closure)configureClosure, (Object)this.getAnt());
    }

    public AntBuilder ant(Action<? super AntBuilder> configureAction) {
        AntBuilder ant = this.getAnt();
        configureAction.execute((Object)ant);
        return ant;
    }

    public Project project(String path, Closure configureClosure) {
        return this.project(this, path, (Action<? super Project>)ConfigureUtil.configureUsing((Closure)configureClosure));
    }

    public Project project(String path, Action<? super Project> configureAction) {
        return this.project(this, path, configureAction);
    }

    @Override
    public ProjectInternal project(ProjectInternal referrer, String path, Action<? super Project> configureAction) {
        ProjectInternal project = this.project(referrer, path);
        this.getProjectConfigurator().project(project, configureAction);
        return project;
    }

    public Object configure(Object object, Closure configureClosure) {
        return ConfigureUtil.configure((Closure)configureClosure, (Object)object);
    }

    public Iterable<?> configure(Iterable<?> objects, Closure configureClosure) {
        for (Object object : objects) {
            this.configure(object, configureClosure);
        }
        return objects;
    }

    public void configurations(Closure configureClosure) {
        this.getConfigurations().configure(configureClosure);
    }

    public void repositories(Closure configureClosure) {
        ConfigureUtil.configure((Closure)configureClosure, (Object)this.getRepositories());
    }

    public void dependencies(Closure configureClosure) {
        ConfigureUtil.configure((Closure)configureClosure, (Object)this.getDependencies());
    }

    public void artifacts(Closure configureClosure) {
        ConfigureUtil.configure((Closure)configureClosure, (Object)this.getArtifacts());
    }

    public void artifacts(Action<? super ArtifactHandler> configureAction) {
        configureAction.execute((Object)this.getArtifacts());
    }

    public void buildscript(Closure configureClosure) {
        ConfigureUtil.configure((Closure)configureClosure, (Object)this.getBuildscript());
    }

    public Task task(String task) {
        return this.taskContainer.create(task);
    }

    public Task task(Object task) {
        return this.taskContainer.create(task.toString());
    }

    public Task task(String task, Action<? super Task> configureAction) {
        return (Task)this.taskContainer.create(task, configureAction);
    }

    public Task task(String task, Closure configureClosure) {
        return this.taskContainer.create(task).configure(configureClosure);
    }

    public Task task(Object task, Closure configureClosure) {
        return this.task(task.toString(), configureClosure);
    }

    public Task task(Map options, String task) {
        return this.taskContainer.create(GUtil.addMaps((Map)((Map)Cast.uncheckedNonnullCast((Object)options)), Collections.singletonMap("name", task)));
    }

    public Task task(Map options, Object task) {
        return this.task(options, task.toString());
    }

    public Task task(Map options, String task, Closure configureClosure) {
        return this.taskContainer.create(GUtil.addMaps((Map)((Map)Cast.uncheckedNonnullCast((Object)options)), Collections.singletonMap("name", task))).configure(configureClosure);
    }

    public Task task(Map options, Object task, Closure configureClosure) {
        return this.task(options, task.toString(), configureClosure);
    }

    @Override
    @Inject
    public abstract ProjectConfigurationActionContainer getConfigurationActions();

    @Override
    @Inject
    public abstract ModelRegistry getModelRegistry();

    @Override
    protected DefaultObjectConfigurationAction createObjectConfigurationAction() {
        TextUriResourceLoader.Factory textUriResourceLoaderFactory = (TextUriResourceLoader.Factory)this.services.get(TextUriResourceLoader.Factory.class);
        return new DefaultObjectConfigurationAction(this.getFileResolver(), this.getScriptPluginFactory(), this.getScriptHandlerFactory(), this.getBaseClassLoaderScope(), textUriResourceLoaderFactory, this);
    }

    @Override
    @Inject
    public abstract PluginManagerInternal getPluginManager();

    @Inject
    protected abstract ScriptPluginFactory getScriptPluginFactory();

    @Inject
    protected abstract ScriptHandlerFactory getScriptHandlerFactory();

    @Override
    public ClassLoaderScope getClassLoaderScope() {
        return this.classLoaderScope;
    }

    @Override
    public ClassLoaderScope getBaseClassLoaderScope() {
        return this.baseClassLoaderScope;
    }

    public Object passThrough(Object object) {
        return object;
    }

    public <T> NamedDomainObjectContainer<T> container(Class<T> type) {
        return ((DomainObjectCollectionFactory)this.getServices().get(DomainObjectCollectionFactory.class)).newNamedDomainObjectContainerUndecorated(type);
    }

    public <T> NamedDomainObjectContainer<T> container(Class<T> type, NamedDomainObjectFactory<T> factory) {
        return ((DomainObjectCollectionFactory)this.getServices().get(DomainObjectCollectionFactory.class)).newNamedDomainObjectContainer(type, factory);
    }

    public <T> NamedDomainObjectContainer<T> container(Class<T> type, Closure factoryClosure) {
        return ((DomainObjectCollectionFactory)this.getServices().get(DomainObjectCollectionFactory.class)).newNamedDomainObjectContainer(type, factoryClosure);
    }

    @Override
    public ExtensionContainerInternal getExtensions() {
        return (ExtensionContainerInternal)DeprecationLogger.whileDisabled(this::getConvention);
    }

    public void model(Closure<?> modelRules) {
        this.prepareForRuleBasedPlugins();
        ModelRegistry modelRegistry = this.getModelRegistry();
        if (TransformedModelDslBacking.isTransformedBlock(modelRules)) {
            ClosureBackedAction.execute((Object)new TransformedModelDslBacking(modelRegistry, (RelativeFilePathResolver)this.getRootProject().getFileResolver()), modelRules);
        } else {
            new NonTransformedModelDslBacking(modelRegistry).configure(modelRules);
        }
    }

    @Inject
    protected abstract DeferredProjectConfiguration getDeferredProjectConfiguration();

    @Inject
    protected abstract CrossProjectConfigurator getProjectConfigurator();

    @Inject
    protected abstract ListenerBuildOperationDecorator getListenerBuildOperationDecorator();

    @Override
    public void addDeferredConfiguration(Runnable configuration) {
        this.getDeferredProjectConfiguration().add(configuration);
    }

    @Override
    public void fireDeferredConfiguration() {
        this.getDeferredProjectConfiguration().fire();
    }

    @Override
    public void addRuleBasedPluginListener(RuleBasedPluginListener listener) {
        if (this.preparedForRuleBasedPlugins) {
            listener.prepareForRuleBasedPlugins(this);
        } else {
            this.ruleBasedPluginListenerBroadcast.add((Object)listener);
        }
    }

    @Override
    public void prepareForRuleBasedPlugins() {
        if (!this.preparedForRuleBasedPlugins) {
            this.preparedForRuleBasedPlugins = true;
            ((RuleBasedPluginListener)this.ruleBasedPluginListenerBroadcast.getSource()).prepareForRuleBasedPlugins(this);
        }
    }

    @Override
    @Inject
    public abstract InputNormalizationHandlerInternal getNormalization();

    public void normalization(Action<? super InputNormalizationHandler> configuration) {
        configuration.execute((Object)this.getNormalization());
    }

    @Inject
    public abstract DependencyLockingHandler getDependencyLocking();

    public void dependencyLocking(Action<? super DependencyLockingHandler> configuration) {
        configuration.execute((Object)this.getDependencyLocking());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProjectEvaluationListener stepEvaluationListener(ProjectEvaluationListener listener, Action<ProjectEvaluationListener> step) {
        ListenerBroadcast<ProjectEvaluationListener> original = this.evaluationListener;
        ListenerBroadcast<ProjectEvaluationListener> nextBatch = this.newProjectEvaluationListenerBroadcast();
        this.evaluationListener = nextBatch;
        try {
            step.execute((Object)listener);
        }
        finally {
            this.evaluationListener = original;
        }
        return nextBatch.isEmpty() ? null : (ProjectEvaluationListener)nextBatch.getSource();
    }

    private void assertMutatingMethodAllowed(String methodName) {
        MutationGuards.of(this.getProjectConfigurator()).assertMutationAllowed(methodName, this, Project.class);
    }

    @Override
    public ProjectState getOwner() {
        return this.owner;
    }

    @Override
    public ProjectInternal.DetachedResolver newDetachedResolver() {
        final DependencyManagementServices dms = (DependencyManagementServices)this.getServices().get(DependencyManagementServices.class);
        InstantiatorFactory instantiatorFactory = (InstantiatorFactory)this.services.get(InstantiatorFactory.class);
        DefaultServiceRegistry lookup = new DefaultServiceRegistry(new ServiceRegistry[]{this.services});
        lookup.addProvider(new Object(){

            public DependencyResolutionServices createServices() {
                return dms.create((FileResolver)DefaultProject.this.services.get(FileResolver.class), (FileCollectionFactory)DefaultProject.this.services.get(FileCollectionFactory.class), (DependencyMetaDataProvider)DefaultProject.this.services.get(DependencyMetaDataProvider.class), new UnknownProjectFinder("Detached resolvers do not support resolving projects"), new DetachedDependencyResolutionDomainObjectContext((DomainObjectContext)DefaultProject.this.services.get(DomainObjectContext.class)));
            }
        });
        return (ProjectInternal.DetachedResolver)instantiatorFactory.decorate((ServiceLookup)lookup).newInstance(LocalDetachedResolver.class, new Object[0]);
    }

    private static class DetachedDependencyResolutionDomainObjectContext
    implements DomainObjectContext {
        private final DomainObjectContext delegate;

        private DetachedDependencyResolutionDomainObjectContext(DomainObjectContext delegate) {
            this.delegate = delegate;
        }

        @Override
        public Path identityPath(String name) {
            return this.delegate.identityPath(name);
        }

        @Override
        public Path projectPath(String name) {
            return this.delegate.projectPath(name);
        }

        @Override
        @Nullable
        public Path getProjectPath() {
            return this.delegate.getProjectPath();
        }

        @Override
        @Nullable
        public ProjectInternal getProject() {
            return this.delegate.getProject();
        }

        @Override
        public ModelContainer<?> getModel() {
            return this.delegate.getModel();
        }

        @Override
        public Path getBuildPath() {
            return this.delegate.getBuildPath();
        }

        @Override
        public boolean isRootScript() {
            return this.delegate.isRootScript();
        }

        @Override
        public boolean isPluginContext() {
            return this.delegate.isPluginContext();
        }

        @Override
        public boolean isScript() {
            return this.delegate.isScript();
        }

        @Override
        public boolean isDetachedState() {
            return true;
        }
    }

    public static class LocalDetachedResolver
    implements ProjectInternal.DetachedResolver {
        private final DependencyResolutionServices resolutionServices;

        @Inject
        public LocalDetachedResolver(DependencyResolutionServices resolutionServices) {
            this.resolutionServices = resolutionServices;
        }

        @Override
        public RepositoryHandler getRepositories() {
            return this.resolutionServices.getResolveRepositoryHandler();
        }

        @Override
        public DependencyHandler getDependencies() {
            return this.resolutionServices.getDependencyHandler();
        }

        @Override
        public ConfigurationContainer getConfigurations() {
            return this.resolutionServices.getConfigurationContainer();
        }
    }

    static class BasicServicesRules
    extends RuleSource {
        BasicServicesRules() {
        }

        @Hidden
        @Model
        ProjectLayout projectLayoutService(ServiceRegistry serviceRegistry) {
            return (ProjectLayout)serviceRegistry.get(ProjectLayout.class);
        }

        @Hidden
        @Model
        ObjectFactory objectFactory(ServiceRegistry serviceRegistry) {
            return (ObjectFactory)serviceRegistry.get(ObjectFactory.class);
        }

        @Hidden
        @Model
        NamedEntityInstantiator<Task> taskFactory(ServiceRegistry serviceRegistry) {
            return (NamedEntityInstantiator)serviceRegistry.get(TaskInstantiator.class);
        }

        @Hidden
        @Model
        CollectionCallbackActionDecorator collectionCallbackActionDecorator(ServiceRegistry serviceRegistry) {
            return (CollectionCallbackActionDecorator)serviceRegistry.get(CollectionCallbackActionDecorator.class);
        }

        @Hidden
        @Model
        Instantiator instantiator(ServiceRegistry serviceRegistry) {
            return (Instantiator)serviceRegistry.get(Instantiator.class);
        }

        @Hidden
        @Model
        ModelSchemaStore schemaStore(ServiceRegistry serviceRegistry) {
            return (ModelSchemaStore)serviceRegistry.get(ModelSchemaStore.class);
        }

        @Hidden
        @Model
        ManagedProxyFactory proxyFactory(ServiceRegistry serviceRegistry) {
            return (ManagedProxyFactory)serviceRegistry.get(ManagedProxyFactory.class);
        }

        @Hidden
        @Model
        StructBindingsStore structBindingsStore(ServiceRegistry serviceRegistry) {
            return (StructBindingsStore)serviceRegistry.get(StructBindingsStore.class);
        }

        @Hidden
        @Model
        NodeInitializerRegistry nodeInitializerRegistry(ModelSchemaStore schemaStore, StructBindingsStore structBindingsStore) {
            return new DefaultNodeInitializerRegistry(schemaStore, structBindingsStore);
        }

        @Hidden
        @Model
        TypeConverter typeConverter(ServiceRegistry serviceRegistry) {
            return (TypeConverter)serviceRegistry.get(TypeConverter.class);
        }

        @Hidden
        @Model
        FileOperations fileOperations(ServiceRegistry serviceRegistry) {
            return (FileOperations)serviceRegistry.get(FileOperations.class);
        }
    }
}

