/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.classpath.types;

import java.io.File;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.gradle.cache.PersistentCache;
import org.gradle.internal.classpath.ClasspathFileTransformer;
import org.gradle.internal.classpath.ClasspathWalker;
import org.gradle.internal.classpath.DefaultCachedClasspathTransformer;
import org.gradle.internal.classpath.InstrumentingClasspathFileTransformer;
import org.gradle.internal.classpath.types.DefaultInstrumentingDirectSuperTypesCollector;
import org.gradle.internal.classpath.types.ExternalPluginsInstrumentationTypeRegistry;
import org.gradle.internal.classpath.types.InstrumentationTypeRegistry;
import org.gradle.internal.classpath.types.InstrumentationTypeRegistryFactory;
import org.gradle.internal.classpath.types.InstrumentingDirectSuperTypesCollector;
import org.gradle.internal.vfs.FileSystemAccess;

public class DefaultInstrumentationTypeRegistryFactory
implements InstrumentationTypeRegistryFactory {
    private final InstrumentationTypeRegistry gradleCoreInstrumentingRegistry;
    private final InstrumentingDirectSuperTypesCollector directSuperTypesCollector;

    public DefaultInstrumentationTypeRegistryFactory(InstrumentationTypeRegistry gradleCoreInstrumentingRegistry, PersistentCache cache, DefaultCachedClasspathTransformer.ParallelTransformExecutor parallelTransformExecutor, ClasspathWalker classpathWalker, FileSystemAccess fileSystemAccess) {
        this.gradleCoreInstrumentingRegistry = gradleCoreInstrumentingRegistry;
        this.directSuperTypesCollector = new DefaultInstrumentingDirectSuperTypesCollector(cache, parallelTransformExecutor, classpathWalker, fileSystemAccess);
    }

    @Override
    public InstrumentationTypeRegistry createFor(Collection<URL> urls, ClasspathFileTransformer transformer) {
        if (this.shouldReturnEmptyRegistry(transformer)) {
            return InstrumentationTypeRegistry.empty();
        }
        List<File> files = urls.stream().filter(url -> url.getProtocol().equals("file")).map(DefaultCachedClasspathTransformer.Convert::urlToFile).collect(Collectors.toList());
        return this.createFor(files, transformer);
    }

    @Override
    public InstrumentationTypeRegistry createFor(List<File> files, ClasspathFileTransformer transformer) {
        if (this.shouldReturnEmptyRegistry(transformer)) {
            return InstrumentationTypeRegistry.empty();
        }
        Map<String, Set<String>> directSuperTypes = this.directSuperTypesCollector.visit(files, transformer.getFileHasher());
        return new ExternalPluginsInstrumentationTypeRegistry(directSuperTypes, this.gradleCoreInstrumentingRegistry);
    }

    private boolean shouldReturnEmptyRegistry(ClasspathFileTransformer transformer) {
        return this.gradleCoreInstrumentingRegistry.isEmpty() || !(transformer instanceof InstrumentingClasspathFileTransformer);
    }
}

