/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.gradle.StartParameter;
import org.gradle.api.InvalidUserCodeException;
import org.gradle.api.artifacts.ResolutionStrategy;
import org.gradle.api.artifacts.ResolveException;
import org.gradle.api.artifacts.UnresolvedDependency;
import org.gradle.api.artifacts.component.BuildIdentifier;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentSelector;
import org.gradle.api.artifacts.result.ResolvedComponentResult;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.attributes.AttributesSchema;
import org.gradle.api.internal.artifacts.ComponentSelectorConverter;
import org.gradle.api.internal.artifacts.ConfigurationResolver;
import org.gradle.api.internal.artifacts.DefaultResolverResults;
import org.gradle.api.internal.artifacts.GlobalDependencyResolutionRules;
import org.gradle.api.internal.artifacts.ImmutableModuleIdentifierFactory;
import org.gradle.api.internal.artifacts.RepositoriesSupplier;
import org.gradle.api.internal.artifacts.ResolveContext;
import org.gradle.api.internal.artifacts.ResolveExceptionContextualizer;
import org.gradle.api.internal.artifacts.ResolverResults;
import org.gradle.api.internal.artifacts.configurations.ConfigurationInternal;
import org.gradle.api.internal.artifacts.configurations.ConflictResolution;
import org.gradle.api.internal.artifacts.configurations.ResolutionHost;
import org.gradle.api.internal.artifacts.configurations.ResolutionStrategyInternal;
import org.gradle.api.internal.artifacts.dsl.dependencies.DependencyLockingProvider;
import org.gradle.api.internal.artifacts.ivyservice.DefaultLenientConfiguration;
import org.gradle.api.internal.artifacts.ivyservice.DefaultResolvedConfiguration;
import org.gradle.api.internal.artifacts.ivyservice.InMemoryResolutionResultBuilder;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ComponentResolvers;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ExternalModuleComponentResolverFactory;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ResolverProviderFactory;
import org.gradle.api.internal.artifacts.ivyservice.projectmodule.LocalComponentRegistry;
import org.gradle.api.internal.artifacts.ivyservice.projectmodule.ProjectDependencyResolver;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.ComponentResolversChain;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.DependencyGraphResolver;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ArtifactSelectionSpec;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.DefaultResolvedArtifactsBuilder;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.DefaultVisitedArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.DependencyArtifactsVisitor;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedArtifactSetResolver;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedArtifactsGraphVisitor;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedVariantCache;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.VisitedArtifactResults;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.VisitedFileDependencyResults;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.CompositeDependencyArtifactsVisitor;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.CompositeDependencyGraphVisitor;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyGraphVisitor;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.conflicts.FailOnVersionConflictGraphVisitor;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.results.DefaultVisitedGraphResults;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.oldresult.DefaultResolvedConfigurationBuilder;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.oldresult.ResolutionFailureCollector;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.oldresult.ResolvedConfigurationDependencyGraphVisitor;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.oldresult.ResolvedGraphResults;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.oldresult.TransientConfigurationResults;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.oldresult.TransientConfigurationResultsBuilder;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.oldresult.TransientConfigurationResultsLoader;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.projectresult.ResolvedLocalComponentsResultGraphVisitor;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.AttributeContainerSerializer;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ComponentDetailsSerializer;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ComponentSelectionDescriptorFactory;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.FileDependencyCollectingGraphVisitor;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.SelectedVariantSerializer;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.StreamingResolutionResultBuilder;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.store.ResolutionResultsStoreFactory;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.store.StoreSet;
import org.gradle.api.internal.artifacts.repositories.ContentFilteringRepository;
import org.gradle.api.internal.artifacts.repositories.ResolutionAwareRepository;
import org.gradle.api.internal.artifacts.result.MinimalResolutionResult;
import org.gradle.api.internal.artifacts.transform.ArtifactVariantSelector;
import org.gradle.api.internal.artifacts.transform.VariantSelectorFactory;
import org.gradle.api.internal.artifacts.type.ArtifactTypeRegistry;
import org.gradle.api.internal.attributes.AttributeDesugaring;
import org.gradle.api.internal.attributes.AttributesSchemaInternal;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.project.ProjectStateRegistry;
import org.gradle.api.specs.Spec;
import org.gradle.api.specs.Specs;
import org.gradle.cache.internal.BinaryStore;
import org.gradle.cache.internal.Store;
import org.gradle.internal.build.BuildState;
import org.gradle.internal.component.model.DependencyMetadata;
import org.gradle.internal.component.model.GraphVariantSelector;
import org.gradle.internal.locking.DependencyLockingGraphVisitor;
import org.gradle.internal.model.CalculatedValueContainerFactory;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.util.Path;

public class DefaultConfigurationResolver
implements ConfigurationResolver {
    private static final Spec<DependencyMetadata> IS_LOCAL_EDGE = element -> element.getSelector() instanceof ProjectComponentSelector;
    private final DependencyGraphResolver dependencyGraphResolver;
    private final RepositoriesSupplier repositoriesSupplier;
    private final GlobalDependencyResolutionRules metadataHandler;
    private final ResolutionResultsStoreFactory storeFactory;
    private final boolean buildProjectDependencies;
    private final AttributesSchemaInternal consumerSchema;
    private final VariantSelectorFactory variantSelectorFactory;
    private final ImmutableModuleIdentifierFactory moduleIdentifierFactory;
    private final BuildOperationExecutor buildOperationExecutor;
    private final ArtifactTypeRegistry artifactTypeRegistry;
    private final CalculatedValueContainerFactory calculatedValueContainerFactory;
    private final ComponentSelectorConverter componentSelectorConverter;
    private final AttributeContainerSerializer attributeContainerSerializer;
    private final BuildIdentifier currentBuild;
    private final AttributeDesugaring attributeDesugaring;
    private final ResolvedArtifactSetResolver artifactSetResolver;
    private final ComponentSelectionDescriptorFactory componentSelectionDescriptorFactory;
    private final ResolveExceptionContextualizer exceptionContextualizer;
    private final ComponentDetailsSerializer componentDetailsSerializer;
    private final SelectedVariantSerializer selectedVariantSerializer;
    private final ResolvedVariantCache resolvedVariantCache;
    private final GraphVariantSelector graphVariantSelector;
    private final ProjectStateRegistry projectStateRegistry;
    private final LocalComponentRegistry localComponentRegistry;
    private final List<ResolverProviderFactory> resolverFactories;
    private final ExternalModuleComponentResolverFactory externalResolverFactory;
    private final ProjectDependencyResolver projectDependencyResolver;
    private final DependencyLockingProvider dependencyLockingProvider;

    public DefaultConfigurationResolver(DependencyGraphResolver dependencyGraphResolver, RepositoriesSupplier repositoriesSupplier, GlobalDependencyResolutionRules metadataHandler, ResolutionResultsStoreFactory storeFactory, StartParameter startParameter, AttributesSchemaInternal consumerSchema, VariantSelectorFactory variantSelectorFactory, ImmutableModuleIdentifierFactory moduleIdentifierFactory, BuildOperationExecutor buildOperationExecutor, ArtifactTypeRegistry artifactTypeRegistry, CalculatedValueContainerFactory calculatedValueContainerFactory, ComponentSelectorConverter componentSelectorConverter, AttributeContainerSerializer attributeContainerSerializer, BuildState currentBuild, AttributeDesugaring attributeDesugaring, ResolvedArtifactSetResolver artifactSetResolver, ComponentSelectionDescriptorFactory componentSelectionDescriptorFactory, ResolveExceptionContextualizer exceptionContextualizer, ComponentDetailsSerializer componentDetailsSerializer, SelectedVariantSerializer selectedVariantSerializer, ResolvedVariantCache resolvedVariantCache, GraphVariantSelector graphVariantSelector, ProjectStateRegistry projectStateRegistry, LocalComponentRegistry localComponentRegistry, List<ResolverProviderFactory> resolverFactories, ExternalModuleComponentResolverFactory externalResolverFactory, ProjectDependencyResolver projectDependencyResolver, DependencyLockingProvider dependencyLockingProvider) {
        this.dependencyGraphResolver = dependencyGraphResolver;
        this.repositoriesSupplier = repositoriesSupplier;
        this.metadataHandler = metadataHandler;
        this.storeFactory = storeFactory;
        this.buildProjectDependencies = startParameter.isBuildProjectDependencies();
        this.consumerSchema = consumerSchema;
        this.variantSelectorFactory = variantSelectorFactory;
        this.moduleIdentifierFactory = moduleIdentifierFactory;
        this.buildOperationExecutor = buildOperationExecutor;
        this.calculatedValueContainerFactory = calculatedValueContainerFactory;
        this.artifactTypeRegistry = artifactTypeRegistry;
        this.componentSelectorConverter = componentSelectorConverter;
        this.attributeContainerSerializer = attributeContainerSerializer;
        this.currentBuild = currentBuild.getBuildIdentifier();
        this.attributeDesugaring = attributeDesugaring;
        this.artifactSetResolver = artifactSetResolver;
        this.componentSelectionDescriptorFactory = componentSelectionDescriptorFactory;
        this.exceptionContextualizer = exceptionContextualizer;
        this.componentDetailsSerializer = componentDetailsSerializer;
        this.selectedVariantSerializer = selectedVariantSerializer;
        this.resolvedVariantCache = resolvedVariantCache;
        this.graphVariantSelector = graphVariantSelector;
        this.projectStateRegistry = projectStateRegistry;
        this.localComponentRegistry = localComponentRegistry;
        this.resolverFactories = resolverFactories;
        this.externalResolverFactory = externalResolverFactory;
        this.projectDependencyResolver = projectDependencyResolver;
        this.dependencyLockingProvider = dependencyLockingProvider;
    }

    @Override
    public ResolverResults resolveBuildDependencies(ResolveContext resolveContext) {
        ResolutionFailureCollector failureCollector = new ResolutionFailureCollector(this.componentSelectorConverter);
        InMemoryResolutionResultBuilder resolutionResultBuilder = new InMemoryResolutionResultBuilder();
        ResolvedLocalComponentsResultGraphVisitor localComponentsVisitor = new ResolvedLocalComponentsResultGraphVisitor(this.currentBuild, this.projectStateRegistry);
        DefaultResolvedArtifactsBuilder artifactsBuilder = new DefaultResolvedArtifactsBuilder(this.buildProjectDependencies);
        ComponentResolvers resolvers = this.getResolvers(resolveContext, Collections.emptyList());
        ResolvedArtifactsGraphVisitor artifactsGraphVisitor = this.artifactVisitorFor(artifactsBuilder, resolvers);
        ImmutableList visitors = ImmutableList.of((Object)failureCollector, (Object)resolutionResultBuilder, (Object)localComponentsVisitor, (Object)artifactsGraphVisitor);
        this.doResolve(resolveContext, resolvers, false, IS_LOCAL_EDGE, (ImmutableList<DependencyGraphVisitor>)visitors);
        localComponentsVisitor.complete(ConfigurationInternal.InternalState.BUILD_DEPENDENCIES_RESOLVED);
        Set<UnresolvedDependency> unresolvedDependencies = failureCollector.complete(Collections.emptySet());
        DefaultVisitedGraphResults graphResults = new DefaultVisitedGraphResults(resolutionResultBuilder.getResolutionResult(), unresolvedDependencies, null);
        ResolutionHost resolutionHost = resolveContext.getResolutionHost();
        ArtifactVariantSelector artifactVariantSelector = this.variantSelectorFactory.create(resolveContext.getDependenciesResolverFactory());
        DefaultVisitedArtifactSet visitedArtifacts = new DefaultVisitedArtifactSet(graphResults, resolutionHost, artifactsBuilder.complete(), this.artifactSetResolver, artifactVariantSelector);
        ResolverResults.LegacyResolverResults legacyResolverResults = DefaultResolverResults.DefaultLegacyResolverResults.buildDependenciesResolved(dependencySpec -> visitedArtifacts.select(DefaultConfigurationResolver.getImplicitSelectionSpec(resolveContext)));
        return DefaultResolverResults.buildDependenciesResolved(graphResults, visitedArtifacts, legacyResolverResults);
    }

    @Override
    public ResolverResults resolveGraph(ResolveContext resolveContext) {
        StoreSet stores = this.storeFactory.createStoreSet();
        BinaryStore oldModelStore = stores.nextBinaryStore();
        Store<TransientConfigurationResults> oldModelCache = stores.oldModelCache();
        TransientConfigurationResultsBuilder oldTransientModelBuilder = new TransientConfigurationResultsBuilder(oldModelStore, oldModelCache, this.moduleIdentifierFactory, this.buildOperationExecutor);
        DefaultResolvedConfigurationBuilder oldModelBuilder = new DefaultResolvedConfigurationBuilder(oldTransientModelBuilder);
        ResolvedConfigurationDependencyGraphVisitor oldModelVisitor = new ResolvedConfigurationDependencyGraphVisitor(oldModelBuilder);
        BinaryStore newModelStore = stores.nextBinaryStore();
        Store<ResolvedComponentResult> newModelCache = stores.newModelCache();
        ResolutionStrategyInternal resolutionStrategy = resolveContext.getResolutionStrategy();
        StreamingResolutionResultBuilder newModelBuilder = new StreamingResolutionResultBuilder(newModelStore, newModelCache, this.attributeContainerSerializer, this.componentDetailsSerializer, this.selectedVariantSerializer, this.attributeDesugaring, this.componentSelectionDescriptorFactory, resolutionStrategy.getReturnAllVariants());
        ResolvedLocalComponentsResultGraphVisitor localComponentsVisitor = new ResolvedLocalComponentsResultGraphVisitor(this.currentBuild, this.projectStateRegistry);
        DefaultResolvedArtifactsBuilder artifactsBuilder = new DefaultResolvedArtifactsBuilder(this.buildProjectDependencies);
        FileDependencyCollectingGraphVisitor fileDependencyVisitor = new FileDependencyCollectingGraphVisitor();
        ResolutionFailureCollector failureCollector = new ResolutionFailureCollector(this.componentSelectorConverter);
        ImmutableList.Builder graphVisitors = ImmutableList.builder();
        graphVisitors.add((Object)newModelBuilder);
        graphVisitors.add((Object)localComponentsVisitor);
        graphVisitors.add((Object)failureCollector);
        FailOnVersionConflictGraphVisitor versionConflictVisitor = null;
        if (resolutionStrategy.getConflictResolution() == ConflictResolution.strict) {
            Path projectPath = resolveContext.getDomainObjectContext().getProjectPath();
            String path = projectPath != null ? projectPath.getPath() : "";
            versionConflictVisitor = new FailOnVersionConflictGraphVisitor(path, resolveContext.getName());
            graphVisitors.add((Object)versionConflictVisitor);
        }
        ResolutionHost resolutionHost = resolveContext.getResolutionHost();
        DependencyLockingGraphVisitor lockingVisitor = null;
        if (resolutionStrategy.isDependencyLockingEnabled()) {
            lockingVisitor = new DependencyLockingGraphVisitor(resolveContext.getDependencyLockingId(), resolutionHost.displayName(), this.dependencyLockingProvider);
            graphVisitors.add((Object)lockingVisitor);
        } else {
            this.dependencyLockingProvider.confirmNotLocked(resolveContext.getDependencyLockingId());
        }
        ComponentResolvers resolvers = this.getResolvers(resolveContext, this.getFilteredRepositories(resolveContext));
        CompositeDependencyArtifactsVisitor artifactVisitors = new CompositeDependencyArtifactsVisitor((List<DependencyArtifactsVisitor>)ImmutableList.of((Object)oldModelVisitor, (Object)fileDependencyVisitor, (Object)artifactsBuilder));
        graphVisitors.add((Object)this.artifactVisitorFor(artifactVisitors, resolvers));
        this.doResolve(resolveContext, resolvers, true, (Spec<DependencyMetadata>)Specs.satisfyAll(), (ImmutableList<DependencyGraphVisitor>)graphVisitors.build());
        localComponentsVisitor.complete(ConfigurationInternal.InternalState.GRAPH_RESOLVED);
        VisitedArtifactResults artifactsResults = artifactsBuilder.complete();
        VisitedFileDependencyResults fileDependencyResults = fileDependencyVisitor.complete();
        ResolvedGraphResults legacyGraphResults = oldModelBuilder.complete();
        Set<UnresolvedDependency> lockingFailures = Collections.emptySet();
        ImmutableSet.Builder nonFatalFailuresBuilder = ImmutableSet.builder();
        if (lockingVisitor != null) {
            lockingFailures = lockingVisitor.collectLockingFailures();
        }
        if (versionConflictVisitor != null) {
            for (Throwable failure : versionConflictVisitor.collectConflictFailures()) {
                nonFatalFailuresBuilder.add((Object)failure);
            }
        }
        ImmutableSet nonFatalFailures = nonFatalFailuresBuilder.build();
        Set<UnresolvedDependency> resolutionFailures = failureCollector.complete(lockingFailures);
        MinimalResolutionResult resolutionResult = newModelBuilder.complete(lockingFailures);
        ResolveException failure = this.exceptionContextualizer.mapFailures((Collection<Throwable>)nonFatalFailures, resolutionHost.getDisplayName(), "dependencies");
        DefaultVisitedGraphResults graphResults = new DefaultVisitedGraphResults(resolutionResult, resolutionFailures, failure);
        if (lockingVisitor != null && !graphResults.hasAnyFailure()) {
            lockingVisitor.writeLocks();
        }
        ArtifactVariantSelector artifactVariantSelector = this.variantSelectorFactory.create(resolveContext.getDependenciesResolverFactory());
        DefaultVisitedArtifactSet visitedArtifacts = new DefaultVisitedArtifactSet(graphResults, resolutionHost, artifactsResults, this.artifactSetResolver, artifactVariantSelector);
        TransientConfigurationResultsLoader transientConfigurationResultsFactory = new TransientConfigurationResultsLoader(oldTransientModelBuilder, legacyGraphResults);
        DefaultLenientConfiguration lenientConfiguration = new DefaultLenientConfiguration(resolutionHost, graphResults, artifactsResults, fileDependencyResults, transientConfigurationResultsFactory, this.artifactSetResolver, artifactVariantSelector, DefaultConfigurationResolver.getImplicitSelectionSpec(resolveContext));
        ResolverResults.LegacyResolverResults legacyResolverResults = DefaultResolverResults.DefaultLegacyResolverResults.graphResolved(lenientConfiguration, new DefaultResolvedConfiguration(graphResults, resolutionHost, visitedArtifacts, lenientConfiguration));
        return DefaultResolverResults.graphResolved(graphResults, visitedArtifacts, legacyResolverResults);
    }

    private static ArtifactSelectionSpec getImplicitSelectionSpec(ResolveContext resolveContext) {
        ImmutableAttributes requestAttributes = resolveContext.getAttributes().asImmutable();
        ResolutionStrategy.SortOrder sortOrder = resolveContext.getResolutionStrategy().getSortOrder();
        return new ArtifactSelectionSpec(requestAttributes, (Spec<? super ComponentIdentifier>)Specs.satisfyAll(), false, false, sortOrder);
    }

    private ResolvedArtifactsGraphVisitor artifactVisitorFor(DependencyArtifactsVisitor artifactsVisitor, ComponentResolvers resolvers) {
        return new ResolvedArtifactsGraphVisitor(artifactsVisitor, this.artifactTypeRegistry, this.calculatedValueContainerFactory, resolvers.getArtifactResolver(), this.resolvedVariantCache, this.graphVariantSelector, this.consumerSchema);
    }

    @Override
    public List<ResolutionAwareRepository> getAllRepositories() {
        return (List)this.repositoriesSupplier.get();
    }

    private void doResolve(ResolveContext resolveContext, ComponentResolvers resolvers, boolean includeSyntheticDependencies, Spec<DependencyMetadata> edgeFilter, ImmutableList<DependencyGraphVisitor> visitors) {
        ResolutionStrategyInternal resolutionStrategy = resolveContext.getResolutionStrategy();
        if (resolutionStrategy.isDependencyLockingEnabled()) {
            if (resolutionStrategy.isFailingOnDynamicVersions()) {
                throw new InvalidUserCodeException("Both dependency locking and fail on dynamic versions are enabled. You must choose between the two modes.");
            }
            if (resolutionStrategy.isFailingOnChangingVersions()) {
                throw new InvalidUserCodeException("Both dependency locking and fail on changing versions are enabled. You must choose between the two modes.");
            }
        }
        List<Object> syntheticDependencies = includeSyntheticDependencies ? resolveContext.getSyntheticDependencies() : Collections.emptyList();
        this.dependencyGraphResolver.resolve(resolveContext.toRootComponent(), syntheticDependencies, edgeFilter, this.consumerSchema, this.componentSelectorConverter, resolvers.getComponentIdResolver(), resolvers.getComponentResolver(), this.metadataHandler.getModuleMetadataProcessor().getModuleReplacements(), resolutionStrategy.getDependencySubstitutionRule(), resolutionStrategy.getConflictResolution(), resolutionStrategy.getCapabilitiesResolutionRules(), resolutionStrategy.isFailingOnDynamicVersions(), resolutionStrategy.isFailingOnChangingVersions(), new CompositeDependencyGraphVisitor((List<DependencyGraphVisitor>)visitors));
    }

    private List<ResolutionAwareRepository> getFilteredRepositories(ResolveContext resolveContext) {
        return ((List)this.repositoriesSupplier.get()).stream().filter(repository -> !DefaultConfigurationResolver.shouldSkipRepository(repository, resolveContext.getName(), (AttributeContainer)resolveContext.getAttributes())).collect(Collectors.toList());
    }

    private ComponentResolvers getResolvers(ResolveContext resolveContext, List<ResolutionAwareRepository> repositories) {
        ArrayList<ComponentResolvers> resolvers = new ArrayList<ComponentResolvers>(3);
        for (ResolverProviderFactory factory : this.resolverFactories) {
            factory.create(resolvers, this.localComponentRegistry);
        }
        resolvers.add(this.projectDependencyResolver);
        ResolutionStrategyInternal resolutionStrategy = resolveContext.getResolutionStrategy();
        resolvers.add(this.externalResolverFactory.createResolvers(repositories, this.metadataHandler.getComponentMetadataProcessorFactory(), resolutionStrategy.getComponentSelection(), resolutionStrategy.isDependencyVerificationEnabled(), resolutionStrategy.getCachePolicy(), (AttributeContainer)resolveContext.getAttributes(), (AttributesSchema)this.consumerSchema));
        return new ComponentResolversChain(resolvers);
    }

    private static boolean shouldSkipRepository(ResolutionAwareRepository repository, String resolveContextName, AttributeContainer consumerAttributes) {
        if (!(repository instanceof ContentFilteringRepository)) {
            return false;
        }
        ContentFilteringRepository cfr = (ContentFilteringRepository)((Object)repository);
        Set<String> includedConfigurations = cfr.getIncludedConfigurations();
        Set<String> excludedConfigurations = cfr.getExcludedConfigurations();
        if (includedConfigurations != null && !includedConfigurations.contains(resolveContextName) || excludedConfigurations != null && excludedConfigurations.contains(resolveContextName)) {
            return true;
        }
        Map<Attribute<Object>, Set<Object>> requiredAttributes = cfr.getRequiredAttributes();
        return DefaultConfigurationResolver.hasNonRequiredAttribute(requiredAttributes, consumerAttributes);
    }

    private static boolean hasNonRequiredAttribute(@Nullable Map<Attribute<Object>, Set<Object>> requiredAttributes, AttributeContainer consumerAttributes) {
        if (requiredAttributes == null) {
            return false;
        }
        for (Map.Entry<Attribute<Object>, Set<Object>> entry : requiredAttributes.entrySet()) {
            Object value;
            Attribute<Object> key = entry.getKey();
            Set<Object> allowedValues = entry.getValue();
            if (allowedValues.contains(value = consumerAttributes.getAttribute(key))) continue;
            return true;
        }
        return false;
    }
}

