/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.resolution.failure.describer;

import java.util.List;
import java.util.Optional;
import org.gradle.api.internal.attributes.AttributesSchemaInternal;
import org.gradle.internal.component.resolution.failure.CapabilitiesDescriber;
import org.gradle.internal.component.resolution.failure.ResolutionCandidateAssessor;
import org.gradle.internal.component.resolution.failure.describer.AbstractResolutionFailureDescriber;
import org.gradle.internal.component.resolution.failure.exception.VariantSelectionException;
import org.gradle.internal.component.resolution.failure.type.NoMatchingCapabilitiesFailure;

public abstract class NoMatchingCapabilitiesFailureDescriber
extends AbstractResolutionFailureDescriber<NoMatchingCapabilitiesFailure> {
    public VariantSelectionException describeFailure(NoMatchingCapabilitiesFailure failure, Optional<AttributesSchemaInternal> schema) {
        String message = this.buildNoMatchingCapabilitiesFailureMsg(failure);
        List<String> resolutions = this.buildResolutions(this.suggestReviewAlgorithm());
        return new VariantSelectionException(message, failure, resolutions);
    }

    private String buildNoMatchingCapabilitiesFailureMsg(NoMatchingCapabilitiesFailure failure) {
        StringBuilder sb = new StringBuilder("Unable to find a variant of ");
        sb.append(failure.getRequestedName()).append(" providing the requested ");
        sb.append(CapabilitiesDescriber.describeCapabilitiesWithTitle(failure.getTargetComponentId(), failure.getRequestedCapabilities()));
        sb.append(":\n");
        for (ResolutionCandidateAssessor.AssessedCandidate candidate : failure.getCandidates()) {
            sb.append("   - Variant ").append(candidate.getDisplayName()).append(" provides ");
            sb.append(CapabilitiesDescriber.describeCapabilities(failure.getTargetComponentId(), candidate.getCandidateCapabilities().asSet())).append("\n");
        }
        return sb.toString();
    }
}

