/*
 * Decompiled with CFR 0.152.
 */
package org.gradleinternal.buildinit.plugins.internal.maven;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.model.Exclusion;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.model.Repository;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.gradle.api.Action;
import org.gradle.api.JavaVersion;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.file.Directory;
import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.api.internal.artifacts.DefaultModuleIdentifier;
import org.gradle.buildinit.InsecureProtocolOption;
import org.gradle.buildinit.plugins.internal.BuildContentGenerationContext;
import org.gradle.buildinit.plugins.internal.BuildInitDependency;
import org.gradle.buildinit.plugins.internal.BuildScriptBuilder;
import org.gradle.buildinit.plugins.internal.BuildScriptBuilderFactory;
import org.gradle.buildinit.plugins.internal.DependenciesBuilder;
import org.gradle.buildinit.plugins.internal.ScriptBlockBuilder;
import org.gradle.buildinit.plugins.internal.VersionCatalogDependencyRegistry;
import org.gradle.buildinit.plugins.internal.VersionCatalogGenerator;
import org.gradle.buildinit.plugins.internal.modifiers.BuildInitDsl;
import org.gradle.util.internal.RelativePathUtil;
import org.gradleinternal.buildinit.plugins.internal.maven.Dependency;
import org.gradleinternal.buildinit.plugins.internal.maven.ExternalDependency;
import org.gradleinternal.buildinit.plugins.internal.maven.ProjectDependency;

public class Maven2Gradle {
    private final BuildScriptBuilderFactory scriptBuilderFactory;
    private final boolean useIncubatingAPIs;
    private final Set<MavenProject> allProjects;
    private final MavenProject rootProject;
    private final List<MavenProject> dependentWars = new ArrayList<MavenProject>();
    private final Directory workingDir;
    private final BuildInitDsl dsl;
    private final InsecureProtocolOption insecureProtocolOption;

    public Maven2Gradle(Set<MavenProject> mavenProjects, Directory workingDir, BuildInitDsl dsl, boolean useIncubatingAPIs, InsecureProtocolOption insecureProtocolOption) {
        assert (!mavenProjects.isEmpty()) : "No Maven projects provided.";
        this.scriptBuilderFactory = new BuildScriptBuilderFactory(new DocumentationRegistry());
        this.useIncubatingAPIs = useIncubatingAPIs;
        this.allProjects = mavenProjects;
        this.rootProject = mavenProjects.iterator().next();
        this.workingDir = workingDir;
        this.dsl = dsl;
        this.insecureProtocolOption = insecureProtocolOption;
    }

    public void convert() {
        BuildContentGenerationContext buildContentGenerationContext = new BuildContentGenerationContext(new VersionCatalogDependencyRegistry(true));
        if (this.isMultiModule()) {
            String buildLocation = this.useIncubatingAPIs ? "build-logic" : "buildSrc";
            BuildScriptBuilder buildSrcSettingsScriptBuilder = this.scriptBuilderFactory.scriptForMavenConversion(this.dsl, buildContentGenerationContext, buildLocation + "/settings", this.useIncubatingAPIs, this.insecureProtocolOption);
            buildSrcSettingsScriptBuilder.useVersionCatalogFromOuterBuild("Reuse version catalog from the main build.");
            BuildScriptBuilder buildSrcScriptBuilder = this.scriptBuilderFactory.scriptForMavenConversion(this.dsl, buildContentGenerationContext, buildLocation + "/build", this.useIncubatingAPIs, this.insecureProtocolOption);
            buildSrcScriptBuilder.conventionPluginSupport("Support convention plugins written in " + this.dsl.toString() + ". Convention plugins are build scripts in 'src/main' that automatically become available as plugins in the main build.");
            buildSrcScriptBuilder.create(this.workingDir).generate();
            String conventionPluginId = "buildlogic.java-conventions";
            String conventionPluginFileWithoutExt = buildLocation + "/src/main/" + this.dsl.name().toLowerCase() + "/" + conventionPluginId;
            BuildScriptBuilder conventionPluginBuilder = this.scriptBuilderFactory.scriptForMavenConversionWithoutVersionCatalog(this.dsl, buildContentGenerationContext, conventionPluginFileWithoutExt, this.useIncubatingAPIs, this.insecureProtocolOption);
            this.generateSettings(this.rootProject.getArtifactId(), this.allProjects, buildContentGenerationContext);
            LinkedHashMap<String, List<Dependency>> dependencies = new LinkedHashMap<String, List<Dependency>>();
            for (MavenProject project2 : this.allProjects) {
                dependencies.put(project2.getArtifactId(), this.getDependencies(project2, this.allProjects));
            }
            this.coordinatesForProject(this.rootProject, conventionPluginBuilder);
            conventionPluginBuilder.plugin(null, "java-library");
            conventionPluginBuilder.plugin(null, "maven-publish");
            this.compilerSettings(this.rootProject, conventionPluginBuilder);
            this.repositoriesForProjects(this.allProjects, conventionPluginBuilder);
            this.globalExclusions(this.rootProject, conventionPluginBuilder);
            List commonDeps = (List)dependencies.get(this.rootProject.getArtifactId());
            this.declareDependencies(commonDeps, conventionPluginBuilder);
            this.testNg(commonDeps, conventionPluginBuilder);
            this.configurePublishing(conventionPluginBuilder, this.packagesSources(this.rootProject), false, false);
            conventionPluginBuilder.create(this.workingDir).generate();
            for (MavenProject module : this.modules(this.allProjects, false)) {
                String id = module.getArtifactId();
                List moduleDependencies = (List)dependencies.get(id);
                boolean warPack = module.getPackaging().equals("war");
                BuildScriptBuilder moduleScriptBuilder = this.scriptBuilderFactory.scriptForMavenConversion(this.dsl, buildContentGenerationContext, RelativePathUtil.relativePath((File)this.workingDir.getAsFile(), (File)this.projectDir(module)) + "/build", this.useIncubatingAPIs, this.insecureProtocolOption);
                moduleScriptBuilder.plugin(null, conventionPluginId);
                if (!module.getGroupId().equals(this.rootProject.getGroupId())) {
                    moduleScriptBuilder.propertyAssignment(null, "group", module.getGroupId());
                }
                if (warPack) {
                    moduleScriptBuilder.plugin(null, "war");
                    if (this.dependentWars.stream().anyMatch(project -> project.getGroupId().equals(module.getGroupId()) && project.getArtifactId().equals(id))) {
                        moduleScriptBuilder.taskPropertyAssignment(null, "jar", "Jar", "enabled", true);
                    }
                }
                this.descriptionForProject(module, moduleScriptBuilder);
                this.declareDependencies(moduleDependencies, moduleScriptBuilder);
                this.testNg(moduleDependencies, moduleScriptBuilder);
                if (this.packageTests(module, moduleScriptBuilder)) {
                    if (this.dsl == BuildInitDsl.GROOVY) {
                        moduleScriptBuilder.methodInvocation(null, "publishing.publications.maven.artifact", moduleScriptBuilder.propertyExpression("testsJar"));
                    } else {
                        moduleScriptBuilder.methodInvocation(null, "(publishing.publications[\"maven\"] as MavenPublication).artifact", moduleScriptBuilder.propertyExpression("testsJar"));
                    }
                }
                if (this.packagesJavadocs(module)) {
                    ScriptBlockBuilder javaExtension = moduleScriptBuilder.block(null, "java");
                    javaExtension.methodInvocation(null, "withJavadocJar", new Object[0]);
                }
                moduleScriptBuilder.create(this.workingDir).generate();
            }
        } else {
            BuildScriptBuilder scriptBuilder = this.scriptBuilderFactory.scriptForMavenConversion(this.dsl, buildContentGenerationContext, "build", this.useIncubatingAPIs, this.insecureProtocolOption);
            this.generateSettings(this.rootProject.getArtifactId(), Collections.emptySet(), buildContentGenerationContext);
            scriptBuilder.plugin(null, "java-library");
            scriptBuilder.plugin(null, "maven-publish");
            this.coordinatesForProject(this.rootProject, scriptBuilder);
            this.descriptionForProject(this.rootProject, scriptBuilder);
            this.compilerSettings(this.rootProject, scriptBuilder);
            this.globalExclusions(this.rootProject, scriptBuilder);
            boolean testsJarTaskGenerated = this.packageTests(this.rootProject, scriptBuilder);
            this.configurePublishing(scriptBuilder, this.packagesSources(this.rootProject), testsJarTaskGenerated, this.packagesJavadocs(this.rootProject));
            scriptBuilder.repositories().mavenLocal(null);
            LinkedHashSet<String> repoSet = new LinkedHashSet<String>();
            this.getRepositoriesForModule(this.rootProject, repoSet);
            for (String repo : repoSet) {
                scriptBuilder.repositories().maven(null, repo);
            }
            List<Dependency> dependencies = this.getDependencies(this.rootProject, null);
            this.declareDependencies(dependencies, scriptBuilder);
            this.testNg(dependencies, scriptBuilder);
            scriptBuilder.create(this.workingDir).generate();
        }
        VersionCatalogGenerator.create(this.workingDir).generate(buildContentGenerationContext, true);
    }

    private void configurePublishing(BuildScriptBuilder builder, boolean publishesSources, boolean testsJarTaskGenerated, boolean publishesJavadoc) {
        if (publishesSources || publishesJavadoc) {
            ScriptBlockBuilder javaExtension = builder.block(null, "java");
            if (publishesSources) {
                javaExtension.methodInvocation(null, "withSourcesJar", new Object[0]);
            }
            if (publishesJavadoc) {
                javaExtension.methodInvocation(null, "withJavadocJar", new Object[0]);
            }
        }
        ScriptBlockBuilder publishing = builder.block(null, "publishing");
        publishing.containerElement(null, "publications", "maven", "MavenPublication", (Action<? super ScriptBlockBuilder>)((Action)p -> {
            p.methodInvocation(null, "from", builder.containerElementExpression("components", "java"));
            if (testsJarTaskGenerated) {
                p.methodInvocation(null, "artifact", builder.propertyExpression("testsJar"));
            }
        }));
    }

    private void declareDependencies(List<Dependency> dependencies, BuildScriptBuilder builder) {
        DependenciesBuilder dependenciesBuilder = builder.dependencies();
        for (Dependency dep : dependencies) {
            if (dep instanceof ProjectDependency) {
                dependenciesBuilder.projectDependency(dep.getConfiguration(), null, ((ProjectDependency)dep).getProjectPath());
                continue;
            }
            ExternalDependency extDep = (ExternalDependency)dep;
            dependenciesBuilder.dependency(dep.getConfiguration(), null, BuildInitDependency.of(extDep.getGroupId(), extDep.getModule(), extDep.getVersion()));
        }
    }

    private void globalExclusions(MavenProject project, BuildScriptBuilder builder) {
        Xpp3Dom configuration;
        Xpp3Dom bannedDependencies;
        Plugin enforcerPlugin = this.plugin("maven-enforcer-plugin", project);
        PluginExecution enforceGoal = this.pluginGoal("enforce", enforcerPlugin);
        if (enforceGoal != null && (bannedDependencies = (configuration = (Xpp3Dom)enforceGoal.getConfiguration()).getChild("rules").getChild("bannedDependencies")) != null) {
            Xpp3Dom[] children = bannedDependencies.getChild("excludes").getChildren();
            ScriptBlockBuilder block = builder.block(null, "configurations.all");
            if (children != null) {
                for (Xpp3Dom exclude : children) {
                    String[] tokens = exclude.getValue().split(":");
                    LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
                    params.put("group", tokens[0]);
                    if (tokens.length > 1 && !tokens[1].equals("*")) {
                        params.put("module", tokens[1]);
                    }
                    block.methodInvocation(null, "exclude", params);
                }
            }
        }
    }

    private void testNg(List<Dependency> moduleDependencies, BuildScriptBuilder builder) {
        boolean testng = moduleDependencies.stream().anyMatch(dep -> dep instanceof ExternalDependency && "org.testng".equals(((ExternalDependency)dep).getGroupId()) && "testng".equals(((ExternalDependency)dep).getModule()));
        if (testng) {
            builder.taskMethodInvocation(null, "test", "Test", "useTestNG", new Object[0]);
        }
    }

    private Set<MavenProject> modules(Set<MavenProject> projects, boolean incReactors) {
        return projects.stream().filter(project -> {
            Optional<MavenProject> parentIsPartOfThisBuild = projects.stream().filter(proj -> project.getParent() == null || project.getParent() != null && proj.getArtifactId().equals(project.getParent().getArtifactId()) && proj.getGroupId().equals(project.getParent().getGroupId())).findFirst();
            return parentIsPartOfThisBuild.isPresent() && (incReactors || !"pom".equals(project.getPackaging()));
        }).collect(Collectors.toSet());
    }

    private String fqn(MavenProject project, Set<MavenProject> allProjects) {
        StringBuilder buffer = new StringBuilder();
        this.generateFqn(project, allProjects, buffer);
        return buffer.toString();
    }

    private void generateFqn(MavenProject project, Set<MavenProject> allProjects, StringBuilder buffer) {
        String artifactId = project.getArtifactId();
        buffer.insert(0, ":" + artifactId);
        if (!this.getModuleIdentifier(this.rootProject).equals(this.getModuleIdentifier(project.getParent()))) {
            allProjects.stream().filter(proj -> this.getModuleIdentifier((MavenProject)proj) == this.getModuleIdentifier(project.getParent())).findFirst().ifPresent(parentInBuild -> this.generateFqn((MavenProject)parentInBuild, allProjects, buffer));
        }
    }

    private ModuleIdentifier getModuleIdentifier(MavenProject project) {
        if (project == null) {
            return null;
        }
        String artifactId = project.getArtifactId();
        String groupId = StringUtils.isNotEmpty((String)project.getGroupId()) ? project.getGroupId() : project.getParent().getGroupId();
        return DefaultModuleIdentifier.newId((String)groupId, (String)artifactId);
    }

    private void coordinatesForProject(MavenProject project, BuildScriptBuilder builder) {
        builder.propertyAssignment(null, "group", project.getGroupId());
        builder.propertyAssignment(null, "version", project.getVersion());
    }

    private void descriptionForProject(MavenProject project, BuildScriptBuilder builder) {
        if (StringUtils.isNotEmpty((String)project.getName())) {
            builder.propertyAssignment(null, "description", project.getName());
        }
    }

    private void repositoriesForProjects(Set<MavenProject> projects, BuildScriptBuilder builder) {
        builder.repositories().mavenLocal(null);
        LinkedHashSet<String> repoSet = new LinkedHashSet<String>();
        for (MavenProject project : projects) {
            this.getRepositoriesForModule(project, repoSet);
        }
        for (String repo : repoSet) {
            builder.repositories().maven(null, repo);
        }
    }

    private void getRepositoriesForModule(MavenProject module, Set<String> repoSet) {
        for (Repository repo : module.getRepositories()) {
            if (repo.getId().equals("central")) {
                repoSet.add("https://repo.maven.apache.org/maven2/");
                continue;
            }
            repoSet.add(repo.getUrl());
        }
    }

    private List<Dependency> getDependencies(MavenProject project, Set<MavenProject> allProjects) {
        ArrayList<org.apache.maven.model.Dependency> dependencies = new ArrayList<org.apache.maven.model.Dependency>();
        this.collectAllDependencies(project, dependencies);
        boolean war = "war".equals(project.getPackaging());
        ArrayList<org.apache.maven.model.Dependency> compileTimeScope = new ArrayList<org.apache.maven.model.Dependency>();
        ArrayList<org.apache.maven.model.Dependency> runtimeScope = new ArrayList<org.apache.maven.model.Dependency>();
        ArrayList<org.apache.maven.model.Dependency> testScope = new ArrayList<org.apache.maven.model.Dependency>();
        ArrayList<org.apache.maven.model.Dependency> providedScope = new ArrayList<org.apache.maven.model.Dependency>();
        ArrayList<org.apache.maven.model.Dependency> systemScope = new ArrayList<org.apache.maven.model.Dependency>();
        for (org.apache.maven.model.Dependency mavenDependency : dependencies) {
            String scope;
            if (this.duplicateDependency(mavenDependency, project, allProjects)) continue;
            switch (scope = StringUtils.isNotEmpty((String)mavenDependency.getScope()) ? mavenDependency.getScope() : "compile") {
                case "compile": {
                    compileTimeScope.add(mavenDependency);
                    break;
                }
                case "test": {
                    testScope.add(mavenDependency);
                    break;
                }
                case "provided": {
                    providedScope.add(mavenDependency);
                    break;
                }
                case "runtime": {
                    runtimeScope.add(mavenDependency);
                    break;
                }
                case "system": {
                    systemScope.add(mavenDependency);
                }
            }
        }
        ArrayList<Dependency> result = new ArrayList<Dependency>();
        if (!(compileTimeScope.isEmpty() && runtimeScope.isEmpty() && testScope.isEmpty() && providedScope.isEmpty() && systemScope.isEmpty())) {
            if (!compileTimeScope.isEmpty()) {
                for (org.apache.maven.model.Dependency dep : compileTimeScope) {
                    this.createGradleDep("api", result, dep, war);
                }
            }
            if (!runtimeScope.isEmpty()) {
                for (org.apache.maven.model.Dependency dep : runtimeScope) {
                    this.createGradleDep("runtimeOnly", result, dep, war);
                }
            }
            if (!testScope.isEmpty()) {
                for (org.apache.maven.model.Dependency dep : testScope) {
                    this.createGradleDep("testImplementation", result, dep, war);
                }
            }
            if (!providedScope.isEmpty()) {
                for (org.apache.maven.model.Dependency dep : providedScope) {
                    this.createGradleDep("providedCompile", result, dep, war);
                }
            }
            if (!systemScope.isEmpty()) {
                for (org.apache.maven.model.Dependency dep : systemScope) {
                    this.createGradleDep("system", result, dep, war);
                }
            }
        }
        return result;
    }

    private void collectAllDependencies(MavenProject mavenProject, List<org.apache.maven.model.Dependency> dependencies) {
        if (mavenProject.getParent() != null) {
            this.collectAllDependencies(mavenProject.getParent(), dependencies);
        }
        dependencies.addAll(mavenProject.getDependencies());
    }

    private void createGradleDep(String scope, List<Dependency> result, org.apache.maven.model.Dependency mavenDependency, boolean war) {
        Optional<MavenProject> projectDep = this.allProjects.stream().filter(prj -> prj.getArtifactId().equals(mavenDependency.getArtifactId()) && prj.getGroupId().equals(mavenDependency.getGroupId())).findFirst();
        if (projectDep.isPresent()) {
            this.createProjectDependency(projectDep.get(), result, scope, this.allProjects);
        } else {
            if (!war && "providedCompile".equals(scope)) {
                scope = "compileOnly";
            }
            this.createExternalDependency(mavenDependency, result, scope);
        }
    }

    private void compilerSettings(MavenProject project, BuildScriptBuilder builder) {
        String encoding;
        Xpp3Dom configuration;
        String source = "1.8";
        String target = "1.8";
        Plugin compilerPlugin = this.plugin("maven-compiler-plugin", project);
        if (compilerPlugin != null && (configuration = (Xpp3Dom)compilerPlugin.getConfiguration()) != null) {
            Xpp3Dom configuredSource = configuration.getChild("source");
            Xpp3Dom configuredTarget = configuration.getChild("target");
            if (configuredSource != null && configuredSource.getValue() != null && !configuredSource.getValue().trim().isEmpty()) {
                source = configuredSource.getValue();
            }
            if (configuredTarget != null && configuredTarget.getValue() != null && !configuredTarget.getValue().trim().isEmpty()) {
                target = configuredTarget.getValue();
            }
        }
        builder.propertyAssignment(null, "java.sourceCompatibility", JavaVersion.toVersion((Object)source));
        if (!target.equals(source)) {
            builder.propertyAssignment(null, "java.targetCompatibility", JavaVersion.toVersion((Object)target));
        }
        if (StringUtils.isNotEmpty((String)(encoding = (String)project.getProperties().get("project.build.sourceEncoding")))) {
            builder.taskPropertyAssignment(null, "JavaCompile", "options.encoding", encoding);
            builder.taskPropertyAssignment(null, "Javadoc", "options.encoding", encoding);
        }
    }

    private Plugin plugin(String artifactId, MavenProject project) {
        return project.getBuild().getPlugins().stream().filter(pluginTag -> pluginTag.getArtifactId().equals(artifactId)).findFirst().orElse(null);
    }

    private PluginExecution pluginGoal(String goalName, Plugin plugin) {
        if (plugin == null) {
            return null;
        }
        return plugin.getExecutions().stream().filter(exec -> exec.getGoals().stream().anyMatch(gl -> gl.startsWith(goalName))).findFirst().orElse(null);
    }

    boolean packagesSources(MavenProject project) {
        Plugin sourcePlugin = this.plugin("maven-source-plugin", project);
        return sourcePlugin != null && this.pluginGoal("jar", sourcePlugin) != null;
    }

    boolean packageTests(MavenProject project, BuildScriptBuilder builder) {
        Plugin jarPlugin = this.plugin("maven-jar-plugin", project);
        if (this.pluginGoal("test-jar", jarPlugin) != null) {
            builder.taskRegistration(null, "testsJar", "Jar", (Action<? super ScriptBlockBuilder>)((Action)task -> {
                task.propertyAssignment(null, "archiveClassifier", "tests", true);
                task.methodInvocation(null, "from", builder.propertyExpression(builder.containerElementExpression("sourceSets", "test"), "output"));
            }));
            return true;
        }
        return false;
    }

    boolean packagesJavadocs(MavenProject project) {
        Plugin jarPlugin = this.plugin("maven-javadoc-plugin", project);
        return jarPlugin != null && this.pluginGoal("jar", jarPlugin) != null;
    }

    private boolean duplicateDependency(org.apache.maven.model.Dependency dependency, MavenProject project, Set<MavenProject> allProjects) {
        MavenProject parent = project.getParent();
        if (allProjects == null || !allProjects.contains(parent)) {
            return false;
        }
        boolean duplicate = parent.getDependencies().stream().anyMatch(dep -> dep.getGroupId().equals(dependency.getGroupId()) && dep.getArtifactId().equals(dependency.getArtifactId()));
        if (duplicate) {
            return true;
        }
        return this.duplicateDependency(dependency, parent, allProjects);
    }

    private File projectDir(MavenProject project) {
        return new File(project.getBuild().getDirectory()).getParentFile();
    }

    private void generateSettings(String mvnProjectName, Set<MavenProject> projects, BuildContentGenerationContext buildContentGenerationContext) {
        BuildScriptBuilder scriptBuilder = this.scriptBuilderFactory.scriptForMavenConversion(this.dsl, buildContentGenerationContext, "settings", this.useIncubatingAPIs, this.insecureProtocolOption);
        if (this.useIncubatingAPIs && this.isMultiModule()) {
            scriptBuilder.block(null, "pluginManagement").methodInvocation("Include 'plugins build' to define convention plugins.", "includeBuild", "build-logic");
        }
        scriptBuilder.propertyAssignment(null, "rootProject.name", mvnProjectName);
        Set<MavenProject> modules = this.modules(projects, true);
        ArrayList<String> moduleNames = new ArrayList<String>();
        LinkedHashMap<String, String> artifactIdToDir = new LinkedHashMap<String, String>();
        for (MavenProject mavenProject : modules) {
            String fqn = this.fqn(mavenProject, projects);
            File projectDirectory = this.projectDir(mavenProject);
            if (this.workingDir.getAsFile().equals(projectDirectory)) continue;
            moduleNames.add(fqn);
            String relativePath = RelativePathUtil.relativePath((File)this.workingDir.getAsFile(), (File)projectDirectory);
            if (fqn.equals(":" + relativePath)) continue;
            artifactIdToDir.put(fqn, relativePath);
        }
        for (String string : moduleNames) {
            scriptBuilder.methodInvocation(null, "include", string);
        }
        for (Map.Entry entry : artifactIdToDir.entrySet()) {
            BuildScriptBuilder.Expression dirExpression = scriptBuilder.methodInvocationExpression("file", entry.getValue());
            scriptBuilder.propertyAssignment(null, "project(\"" + (String)entry.getKey() + "\").projectDir", dirExpression);
        }
        scriptBuilder.create(this.workingDir).generate();
    }

    private boolean isMultiModule() {
        return !this.rootProject.getModules().isEmpty();
    }

    private void createExternalDependency(org.apache.maven.model.Dependency mavenDependency, List<Dependency> result, String scope) {
        String classifier = mavenDependency.getClassifier();
        List<String> exclusions = mavenDependency.getExclusions().stream().map(Exclusion::getArtifactId).collect(Collectors.toList());
        result.add(new ExternalDependency(scope, mavenDependency.getGroupId(), mavenDependency.getArtifactId(), mavenDependency.getVersion(), classifier, exclusions));
    }

    private void createProjectDependency(MavenProject projectDep, List<Dependency> result, String scope, Set<MavenProject> allProjects) {
        if ("war".equals(projectDep.getPackaging())) {
            this.dependentWars.add(projectDep);
        }
        result.add(new ProjectDependency(scope, this.fqn(projectDep, allProjects)));
    }
}

