/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.logging.events;

import com.google.common.collect.Lists;
import java.util.List;
import org.apache.commons.lang.BooleanUtils;
import org.gradle.internal.Either;
import org.gradle.internal.logging.events.PromptOutputEvent;

public class YesNoQuestionPromptEvent
extends PromptOutputEvent {
    public static final List<String> YES_NO_CHOICES = Lists.newArrayList((Object[])new String[]{"yes", "no"});

    public YesNoQuestionPromptEvent(long timestamp, String prompt) {
        super(timestamp, prompt, true);
    }

    public Either<Boolean, String> convert(String text) {
        String trimmed = text.trim();
        if (YES_NO_CHOICES.contains(trimmed)) {
            return Either.left((Object)BooleanUtils.toBoolean((String)trimmed));
        }
        return Either.right((Object)"Please enter 'yes' or 'no': ");
    }
}

