/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.declarativedsl.mappingToJvm;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.NotImplementedError;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import org.gradle.internal.declarativedsl.analysis.AssignmentMethod;
import org.gradle.internal.declarativedsl.analysis.DataBuilderFunction;
import org.gradle.internal.declarativedsl.analysis.DataParameter;
import org.gradle.internal.declarativedsl.analysis.DataProperty;
import org.gradle.internal.declarativedsl.analysis.ExternalObjectProviderKey;
import org.gradle.internal.declarativedsl.analysis.ObjectOrigin;
import org.gradle.internal.declarativedsl.analysis.ParameterValueBinding;
import org.gradle.internal.declarativedsl.analysis.SchemaFunction;
import org.gradle.internal.declarativedsl.analysis.SchemaMemberFunction;
import org.gradle.internal.declarativedsl.mappingToJvm.DeclarativeReflectionToObjectConverter;
import org.gradle.internal.declarativedsl.mappingToJvm.DeclarativeRuntimeFunction;
import org.gradle.internal.declarativedsl.mappingToJvm.RuntimeCustomAccessors;
import org.gradle.internal.declarativedsl.mappingToJvm.RuntimeFunctionResolver;
import org.gradle.internal.declarativedsl.mappingToJvm.RuntimePropertyResolver;
import org.gradle.internal.declarativedsl.objectGraph.ObjectReflection;
import org.gradle.internal.declarativedsl.objectGraph.PropertyValueReflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u00016B9\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0001\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\b\u0002\u0010\u0014\u001a\u00020\u0015J \u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u001e\u001a\u00020\u0018H\u0002J\u001a\u0010\u001f\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010 \u001a\u00020\u001aH\u0002J \u0010!\u001a\u00020\u00112\u0006\u0010\"\u001a\u00020\u00182\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u0018H\u0002J\u0018\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u00012\u0006\u0010)\u001a\u00020*H\u0002J\"\u0010+\u001a\u0004\u0018\u00010\u00012\u0006\u0010,\u001a\u00020\u000f2\u000e\u0010-\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010.H\u0002J\u0012\u0010/\u001a\u0004\u0018\u00010\u00012\u0006\u0010)\u001a\u000200H\u0002J\u0012\u00101\u001a\u0004\u0018\u00010\u00012\u0006\u0010)\u001a\u000202H\u0002J\n\u00103\u001a\u0004\u0018\u00010\u0001H\u0002J\"\u00104\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010 \u001a\u00020\u001a2\b\u00105\u001a\u0004\u0018\u00010\u0001H\u0002R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\r\u001a\u0010\u0012\u0004\u0012\u00020\u000f\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lorg/gradle/internal/declarativedsl/mappingToJvm/DeclarativeReflectionToObjectConverter;", "", "externalObjectsMap", "", "Lorg/gradle/internal/declarativedsl/analysis/ExternalObjectProviderKey;", "topLevelObject", "functionResolver", "Lorg/gradle/internal/declarativedsl/mappingToJvm/RuntimeFunctionResolver;", "propertyResolver", "Lorg/gradle/internal/declarativedsl/mappingToJvm/RuntimePropertyResolver;", "customAccessors", "Lorg/gradle/internal/declarativedsl/mappingToJvm/RuntimeCustomAccessors;", "(Ljava/util/Map;Ljava/lang/Object;Lorg/gradle/internal/declarativedsl/mappingToJvm/RuntimeFunctionResolver;Lorg/gradle/internal/declarativedsl/mappingToJvm/RuntimePropertyResolver;Lorg/gradle/internal/declarativedsl/mappingToJvm/RuntimeCustomAccessors;)V", "reflectionIdentityObjects", "", "", "apply", "", "objectReflection", "Lorg/gradle/internal/declarativedsl/objectGraph/ObjectReflection;", "conversionFilter", "Lorg/gradle/internal/declarativedsl/mappingToJvm/DeclarativeReflectionToObjectConverter$ConversionFilter;", "applyPropertyValue", "receiver", "Lorg/gradle/internal/declarativedsl/analysis/ObjectOrigin;", "property", "Lorg/gradle/internal/declarativedsl/analysis/DataProperty;", "assigned", "Lorg/gradle/internal/declarativedsl/objectGraph/PropertyValueReflection;", "getObjectByResolvedOrigin", "objectOrigin", "getPropertyValue", "dataProperty", "invokeBuilderFunction", "receiverOrigin", "function", "Lorg/gradle/internal/declarativedsl/analysis/DataBuilderFunction;", "valueOrigin", "invokeFunctionAndGetResult", "Lorg/gradle/internal/declarativedsl/mappingToJvm/DeclarativeRuntimeFunction$InvocationResult;", "receiverInstance", "origin", "Lorg/gradle/internal/declarativedsl/analysis/ObjectOrigin$FunctionInvocationOrigin;", "objectByIdentity", "identity", "newObject", "Lkotlin/Function0;", "objectFromConfiguringLambda", "Lorg/gradle/internal/declarativedsl/analysis/ObjectOrigin$ConfiguringLambdaReceiver;", "objectFromMemberFunction", "Lorg/gradle/internal/declarativedsl/analysis/ObjectOrigin$NewObjectFromMemberFunction;", "objectFromTopLevelFunction", "setPropertyValue", "value", "ConversionFilter", "declarative-dsl-core"})
@SourceDebugExtension(value={"SMAP\nDeclarativeReflectionToObjectConverter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeclarativeReflectionToObjectConverter.kt\norg/gradle/internal/declarativedsl/mappingToJvm/DeclarativeReflectionToObjectConverter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,187:1\n1855#2,2:188\n1855#2,2:190\n1855#2,2:192\n1855#2,2:194\n1238#2,4:198\n1238#2,4:204\n453#3:196\n403#3:197\n453#3:202\n403#3:203\n*S KotlinDebug\n*F\n+ 1 DeclarativeReflectionToObjectConverter.kt\norg/gradle/internal/declarativedsl/mappingToJvm/DeclarativeReflectionToObjectConverter\n*L\n31#1:188,2\n39#1:190,2\n46#1:192,2\n51#1:194,2\n125#1:198,4\n153#1:204,4\n125#1:196\n125#1:197\n153#1:202\n153#1:203\n*E\n"})
public final class DeclarativeReflectionToObjectConverter {
    @NotNull
    private final Map<ExternalObjectProviderKey, Object> externalObjectsMap;
    @NotNull
    private final Object topLevelObject;
    @NotNull
    private final RuntimeFunctionResolver functionResolver;
    @NotNull
    private final RuntimePropertyResolver propertyResolver;
    @NotNull
    private final RuntimeCustomAccessors customAccessors;
    @NotNull
    private final Map<Long, Object> reflectionIdentityObjects;

    public DeclarativeReflectionToObjectConverter(@NotNull Map<ExternalObjectProviderKey, ? extends Object> externalObjectsMap, @NotNull Object topLevelObject, @NotNull RuntimeFunctionResolver functionResolver, @NotNull RuntimePropertyResolver propertyResolver, @NotNull RuntimeCustomAccessors customAccessors) {
        Intrinsics.checkNotNullParameter(externalObjectsMap, (String)"externalObjectsMap");
        Intrinsics.checkNotNullParameter((Object)topLevelObject, (String)"topLevelObject");
        Intrinsics.checkNotNullParameter((Object)functionResolver, (String)"functionResolver");
        Intrinsics.checkNotNullParameter((Object)propertyResolver, (String)"propertyResolver");
        Intrinsics.checkNotNullParameter((Object)customAccessors, (String)"customAccessors");
        this.externalObjectsMap = externalObjectsMap;
        this.topLevelObject = topLevelObject;
        this.functionResolver = functionResolver;
        this.propertyResolver = propertyResolver;
        this.customAccessors = customAccessors;
        this.reflectionIdentityObjects = new LinkedHashMap();
    }

    public final void apply(@NotNull ObjectReflection objectReflection, @NotNull ConversionFilter conversionFilter) {
        Intrinsics.checkNotNullParameter((Object)objectReflection, (String)"objectReflection");
        Intrinsics.checkNotNullParameter((Object)conversionFilter, (String)"conversionFilter");
        if (objectReflection instanceof ObjectReflection.DataObjectReflection) {
            Iterable $this$forEach$iv = conversionFilter.filterProperties((ObjectReflection.DataObjectReflection)objectReflection);
            boolean $i$f$forEach = false;
            Iterator<DataProperty> iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                DataProperty element$iv;
                DataProperty property = element$iv = iterator.next();
                boolean bl = false;
                PropertyValueReflection assigned = (PropertyValueReflection)MapsKt.getValue(((ObjectReflection.DataObjectReflection)objectReflection).getProperties(), (Object)property);
                this.applyPropertyValue(objectReflection.getObjectOrigin(), property, assigned);
                this.apply(assigned.getValue(), conversionFilter);
            }
            $this$forEach$iv = ((ObjectReflection.DataObjectReflection)objectReflection).getAddedObjects();
            $i$f$forEach = false;
            for (DataProperty element$iv : $this$forEach$iv) {
                ObjectReflection addedObject = (ObjectReflection)((Object)element$iv);
                boolean bl = false;
                this.getObjectByResolvedOrigin(addedObject.getObjectOrigin());
                this.apply(addedObject, conversionFilter);
            }
            $this$forEach$iv = ((ObjectReflection.DataObjectReflection)objectReflection).getCustomAccessorObjects();
            $i$f$forEach = false;
            for (DataProperty element$iv : $this$forEach$iv) {
                ObjectReflection customAccessor = (ObjectReflection)((Object)element$iv);
                boolean bl = false;
                if (this.getObjectByResolvedOrigin(customAccessor.getObjectOrigin()) == null) {
                    throw new IllegalStateException(("could not get object by custom accessor " + customAccessor.getObjectOrigin()).toString());
                }
                this.apply(customAccessor, conversionFilter);
            }
            $this$forEach$iv = ((ObjectReflection.DataObjectReflection)objectReflection).getLambdaAccessedObjects();
            $i$f$forEach = false;
            for (DataProperty element$iv : $this$forEach$iv) {
                ObjectReflection lambdaAccessedObject = (ObjectReflection)((Object)element$iv);
                boolean bl = false;
                if (this.getObjectByResolvedOrigin(lambdaAccessedObject.getObjectOrigin()) == null) {
                    throw new IllegalStateException(("could not get object from lambda passed to " + lambdaAccessedObject.getObjectOrigin()).toString());
                }
                this.apply(lambdaAccessedObject, conversionFilter);
            }
        }
    }

    public static /* synthetic */ void apply$default(DeclarativeReflectionToObjectConverter declarativeReflectionToObjectConverter, ObjectReflection objectReflection, ConversionFilter conversionFilter, int n, Object object) {
        if ((n & 2) != 0) {
            conversionFilter = ConversionFilter.Companion.getNone();
        }
        declarativeReflectionToObjectConverter.apply(objectReflection, conversionFilter);
    }

    private final Object objectByIdentity(long identity, Function0<? extends Object> newObject) {
        Long l = identity;
        if (!this.reflectionIdentityObjects.containsKey(l)) {
            Object newInstance = newObject.invoke();
            Long l2 = identity;
            this.reflectionIdentityObjects.put(l2, newInstance);
            return newInstance;
        }
        return this.reflectionIdentityObjects.get(identity);
    }

    private final void applyPropertyValue(ObjectOrigin receiver, DataProperty property, PropertyValueReflection assigned) {
        AssignmentMethod assignmentMethod = assigned.getAssignmentMethod();
        if (assignmentMethod instanceof AssignmentMethod.Property) {
            this.setPropertyValue(receiver, property, this.getObjectByResolvedOrigin(assigned.getValue().getObjectOrigin()));
        } else if (assignmentMethod instanceof AssignmentMethod.BuilderFunction) {
            this.invokeBuilderFunction(receiver, ((AssignmentMethod.BuilderFunction)assigned.getAssignmentMethod()).getFunction(), assigned.getValue().getObjectOrigin());
        } else if (assignmentMethod instanceof AssignmentMethod.AsConstructed) {
            // empty if block
        }
    }

    private final Object getObjectByResolvedOrigin(ObjectOrigin objectOrigin) {
        Object object;
        ObjectOrigin objectOrigin2 = objectOrigin;
        if (objectOrigin2 instanceof ObjectOrigin.DelegatingObjectOrigin) {
            object = this.getObjectByResolvedOrigin(((ObjectOrigin.DelegatingObjectOrigin)objectOrigin).getDelegate());
        } else if (objectOrigin2 instanceof ObjectOrigin.ConstantOrigin) {
            object = ((ObjectOrigin.ConstantOrigin)objectOrigin).getLiteral().getValue();
        } else if (objectOrigin2 instanceof ObjectOrigin.External) {
            object = this.externalObjectsMap.get(((ObjectOrigin.External)objectOrigin).getKey());
            if (object == null) {
                throw new IllegalStateException(("No external object provided for external object key of " + ((ObjectOrigin.External)objectOrigin).getKey()).toString());
            }
        } else if (objectOrigin2 instanceof ObjectOrigin.NewObjectFromMemberFunction) {
            object = this.objectByIdentity(((ObjectOrigin.NewObjectFromMemberFunction)objectOrigin).getInvocationId(), (Function0<? extends Object>)((Function0)new Function0<Object>(this, objectOrigin){
                final /* synthetic */ DeclarativeReflectionToObjectConverter this$0;
                final /* synthetic */ ObjectOrigin $objectOrigin;
                {
                    this.this$0 = $receiver;
                    this.$objectOrigin = $objectOrigin;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return DeclarativeReflectionToObjectConverter.access$objectFromMemberFunction(this.this$0, (ObjectOrigin.NewObjectFromMemberFunction)this.$objectOrigin);
                }
            }));
        } else if (objectOrigin2 instanceof ObjectOrigin.NewObjectFromTopLevelFunction) {
            object = this.objectByIdentity(((ObjectOrigin.NewObjectFromTopLevelFunction)objectOrigin).getInvocationId(), (Function0<? extends Object>)((Function0)new Function0<Object>(this){
                final /* synthetic */ DeclarativeReflectionToObjectConverter this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return DeclarativeReflectionToObjectConverter.access$objectFromTopLevelFunction(this.this$0);
                }
            }));
        } else if (objectOrigin2 instanceof ObjectOrigin.NullObjectOrigin) {
            object = null;
        } else if (objectOrigin2 instanceof ObjectOrigin.PropertyDefaultValue) {
            object = this.getPropertyValue(((ObjectOrigin.PropertyDefaultValue)objectOrigin).getReceiver(), ((ObjectOrigin.PropertyDefaultValue)objectOrigin).getProperty());
        } else if (objectOrigin2 instanceof ObjectOrigin.PropertyReference) {
            object = this.getPropertyValue(((ObjectOrigin.PropertyReference)objectOrigin).getReceiver(), ((ObjectOrigin.PropertyReference)objectOrigin).getProperty());
        } else if (objectOrigin2 instanceof ObjectOrigin.TopLevelReceiver) {
            object = this.topLevelObject;
        } else if (objectOrigin2 instanceof ObjectOrigin.ConfiguringLambdaReceiver) {
            object = this.objectFromConfiguringLambda((ObjectOrigin.ConfiguringLambdaReceiver)objectOrigin);
        } else if (objectOrigin2 instanceof ObjectOrigin.CustomConfigureAccessor) {
            Object object2 = this.getObjectByResolvedOrigin(((ObjectOrigin.CustomConfigureAccessor)objectOrigin).getReceiver());
            if (object2 == null) {
                throw new IllegalStateException("receiver for custom accessor is null".toString());
            }
            object = this.customAccessors.getObjectFromCustomAccessor(object2, ((ObjectOrigin.CustomConfigureAccessor)objectOrigin).getAccessor());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return object;
    }

    private final Object objectFromMemberFunction(ObjectOrigin.NewObjectFromMemberFunction origin) {
        SchemaMemberFunction dataFun = origin.getFunction();
        Object object = this.getObjectByResolvedOrigin(origin.getReceiver());
        if (object == null) {
            throw new IllegalStateException(("Tried to invoke a function " + dataFun + " on a null receiver " + origin.getReceiver()).toString());
        }
        Object receiverInstance = object;
        DeclarativeRuntimeFunction.InvocationResult callResult = this.invokeFunctionAndGetResult(receiverInstance, origin);
        return callResult.getResult();
    }

    /*
     * WARNING - void declaration
     */
    private final DeclarativeRuntimeFunction.InvocationResult invokeFunctionAndGetResult(Object receiverInstance, ObjectOrigin.FunctionInvocationOrigin origin) {
        Map destination$iv$iv;
        SchemaFunction dataFun = origin.getFunction();
        KClass receiverKClass = Reflection.getOrCreateKotlinClass(receiverInstance.getClass());
        RuntimeFunctionResolver.Resolution runtimeFunction = this.functionResolver.resolve(receiverKClass, dataFun.getSimpleName(), origin.getParameterBindings());
        if (runtimeFunction instanceof RuntimeFunctionResolver.Resolution.Resolved) {
            void $this$mapValuesTo$iv$iv;
            Map<DataParameter, ObjectOrigin> $this$mapValues$iv = origin.getParameterBindings().getBindingMap();
            boolean $i$f$mapValues = false;
            Map<DataParameter, ObjectOrigin> map = $this$mapValues$iv;
            destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
            boolean $i$f$mapValuesTo = false;
            Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                void it;
                void it$iv$iv;
                Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                Map map2 = destination$iv$iv;
                boolean bl = false;
                Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                Object k = it$iv$iv.getKey();
                Map map3 = map2;
                boolean bl2 = false;
                Object object = this.getObjectByResolvedOrigin((ObjectOrigin)it.getValue());
                map3.put(k, object);
            }
        } else {
            if (Intrinsics.areEqual((Object)runtimeFunction, (Object)RuntimeFunctionResolver.Resolution.Unresolved.INSTANCE)) {
                throw new IllegalStateException(("could not resolve a member function " + dataFun + " call in the owner class " + receiverKClass).toString());
            }
            throw new NoWhenBranchMatchedException();
        }
        Map bindingWithValues = destination$iv$iv;
        return ((RuntimeFunctionResolver.Resolution.Resolved)runtimeFunction).getFunction().callByWithErrorHandling(receiverInstance, bindingWithValues, origin.getParameterBindings().getProvidesConfigureBlock());
    }

    private final Object objectFromConfiguringLambda(ObjectOrigin.ConfiguringLambdaReceiver origin) {
        SchemaFunction function = origin.getFunction();
        Object object = this.getObjectByResolvedOrigin(origin.getReceiver());
        if (object == null) {
            throw new IllegalStateException(("Tried to invoke a function " + function + " on a null receiver " + origin.getReceiver()).toString());
        }
        Object receiverInstance = object;
        return this.invokeFunctionAndGetResult(receiverInstance, origin).getCapturedValue();
    }

    /*
     * WARNING - void declaration
     */
    private final void invokeBuilderFunction(ObjectOrigin receiverOrigin, DataBuilderFunction function, ObjectOrigin valueOrigin) {
        Object object = this.getObjectByResolvedOrigin(receiverOrigin);
        if (object == null) {
            throw new IllegalStateException(("Tried to invoke a function " + function + " on a null receiver " + receiverOrigin).toString());
        }
        Object receiverInstance = object;
        KClass receiverKClass = Reflection.getOrCreateKotlinClass(receiverInstance.getClass());
        ParameterValueBinding parameterBinding = new ParameterValueBinding(MapsKt.mapOf((Pair)TuplesKt.to((Object)function.getDataParameter(), (Object)valueOrigin)), false);
        RuntimeFunctionResolver.Resolution runtimeFunction = this.functionResolver.resolve(receiverKClass, function.getSimpleName(), parameterBinding);
        if (runtimeFunction instanceof RuntimeFunctionResolver.Resolution.Resolved) {
            Map map;
            void $this$mapValuesTo$iv$iv;
            void $this$mapValues$iv;
            Map<DataParameter, ObjectOrigin> map2 = parameterBinding.getBindingMap();
            Object object2 = receiverInstance;
            DeclarativeRuntimeFunction declarativeRuntimeFunction = ((RuntimeFunctionResolver.Resolution.Resolved)runtimeFunction).getFunction();
            boolean $i$f$mapValues = false;
            void var10_12 = $this$mapValues$iv;
            Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
            boolean $i$f$mapValuesTo = false;
            Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                void it;
                void it$iv$iv;
                Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                Map map3 = destination$iv$iv;
                boolean bl = false;
                Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                Object k = it$iv$iv.getKey();
                map = map3;
                boolean bl2 = false;
                Object object3 = this.getObjectByResolvedOrigin((ObjectOrigin)it.getValue());
                map.put(k, object3);
            }
            map = destination$iv$iv;
            declarativeRuntimeFunction.callByWithErrorHandling(object2, map, parameterBinding.getProvidesConfigureBlock()).getResult();
        } else if (Intrinsics.areEqual((Object)runtimeFunction, (Object)RuntimeFunctionResolver.Resolution.Unresolved.INSTANCE)) {
            throw new IllegalStateException(("could not resolve a member function " + function + " call in the owner class " + receiverKClass).toString());
        }
    }

    private final Object objectFromTopLevelFunction() {
        String string = "support calls to top-level functions: they need to carry the owner class information to get resolved";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    private final Object getPropertyValue(ObjectOrigin receiver, DataProperty dataProperty) {
        Object object = this.getObjectByResolvedOrigin(receiver);
        if (object == null) {
            throw new IllegalStateException(("tried to access a property " + dataProperty.getName() + " on a null receiver").toString());
        }
        Object receiverInstance = object;
        KClass receiverKClass = Reflection.getOrCreateKotlinClass(receiverInstance.getClass());
        RuntimePropertyResolver.ReadResolution property = this.propertyResolver.resolvePropertyRead(receiverKClass, dataProperty.getName());
        if (!(property instanceof RuntimePropertyResolver.ReadResolution.ResolvedRead)) {
            if (Intrinsics.areEqual((Object)property, (Object)RuntimePropertyResolver.ReadResolution.UnresolvedRead.INSTANCE)) {
                throw new IllegalStateException(("cannot get property " + dataProperty.getName() + " from the receiver class " + receiverKClass).toString());
            }
            throw new NoWhenBranchMatchedException();
        }
        return ((RuntimePropertyResolver.ReadResolution.ResolvedRead)property).getGetter().getValue(receiverInstance);
    }

    private final void setPropertyValue(ObjectOrigin receiver, DataProperty dataProperty, Object value) {
        Object object = this.getObjectByResolvedOrigin(receiver);
        if (object == null) {
            throw new IllegalStateException(("tried to access a property " + dataProperty.getName() + " on a null receiver").toString());
        }
        Object receiverInstance = object;
        KClass receiverKClass = Reflection.getOrCreateKotlinClass(receiverInstance.getClass());
        RuntimePropertyResolver.WriteResolution property = this.propertyResolver.resolvePropertyWrite(receiverKClass, dataProperty.getName());
        if (property instanceof RuntimePropertyResolver.WriteResolution.ResolvedWrite) {
            ((RuntimePropertyResolver.WriteResolution.ResolvedWrite)property).getSetter().setValue(receiverInstance, value);
        } else if (Intrinsics.areEqual((Object)property, (Object)RuntimePropertyResolver.WriteResolution.UnresolvedWrite.INSTANCE)) {
            throw new IllegalStateException(("cannot set property " + dataProperty.getName() + " in the receiver class " + receiverKClass).toString());
        }
    }

    public static final /* synthetic */ Object access$objectFromMemberFunction(DeclarativeReflectionToObjectConverter $this, ObjectOrigin.NewObjectFromMemberFunction origin) {
        return $this.objectFromMemberFunction(origin);
    }

    public static final /* synthetic */ Object access$objectFromTopLevelFunction(DeclarativeReflectionToObjectConverter $this) {
        return $this.objectFromTopLevelFunction();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00e6\u0080\u0001\u0018\u0000 \u00072\u00020\u0001:\u0001\u0007J\u0016\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0005\u001a\u00020\u0006H&\u00a8\u0006\b"}, d2={"Lorg/gradle/internal/declarativedsl/mappingToJvm/DeclarativeReflectionToObjectConverter$ConversionFilter;", "", "filterProperties", "", "Lorg/gradle/internal/declarativedsl/analysis/DataProperty;", "dataObjectReflection", "Lorg/gradle/internal/declarativedsl/objectGraph/ObjectReflection$DataObjectReflection;", "Companion", "declarative-dsl-core"})
    public static interface ConversionFilter {
        @NotNull
        public static final Companion Companion = Companion.$$INSTANCE;

        @NotNull
        public Iterable<DataProperty> filterProperties(@NotNull ObjectReflection.DataObjectReflection var1);

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/gradle/internal/declarativedsl/mappingToJvm/DeclarativeReflectionToObjectConverter$ConversionFilter$Companion;", "", "()V", "none", "Lorg/gradle/internal/declarativedsl/mappingToJvm/DeclarativeReflectionToObjectConverter$ConversionFilter;", "getNone", "()Lorg/gradle/internal/declarativedsl/mappingToJvm/DeclarativeReflectionToObjectConverter$ConversionFilter;", "declarative-dsl-core"})
        public static final class Companion {
            static final /* synthetic */ Companion $$INSTANCE;
            @NotNull
            private static final ConversionFilter none;

            private Companion() {
            }

            @NotNull
            public final ConversionFilter getNone() {
                return none;
            }

            static {
                $$INSTANCE = new Companion();
                none = none.1.INSTANCE;
            }
        }
    }
}

