/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.model;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import org.gradle.api.artifacts.DependencyConstraintMetadata;
import org.gradle.api.artifacts.DependencyConstraintsMetadata;
import org.gradle.api.artifacts.DirectDependenciesMetadata;
import org.gradle.api.artifacts.DirectDependencyMetadata;
import org.gradle.api.internal.artifacts.repositories.resolver.DependencyConstraintMetadataAdapter;
import org.gradle.api.internal.artifacts.repositories.resolver.DependencyConstraintsMetadataAdapter;
import org.gradle.api.internal.artifacts.repositories.resolver.DirectDependenciesMetadataAdapter;
import org.gradle.api.internal.artifacts.repositories.resolver.DirectDependencyMetadataAdapter;
import org.gradle.api.internal.attributes.ImmutableAttributesFactory;
import org.gradle.api.specs.Spec;
import org.gradle.internal.component.external.model.ModuleDependencyMetadata;
import org.gradle.internal.component.external.model.VariantMetadataRules;
import org.gradle.internal.component.model.DependencyMetadata;
import org.gradle.internal.component.model.VariantResolveMetadata;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.typeconversion.NotationParser;
import org.gradle.util.internal.CollectionUtils;

public class DependencyMetadataRules {
    private static final Spec<ModuleDependencyMetadata> DEPENDENCY_FILTER = dep -> !dep.isConstraint();
    private static final Spec<ModuleDependencyMetadata> DEPENDENCY_CONSTRAINT_FILTER = DependencyMetadata::isConstraint;
    private final Instantiator instantiator;
    private final NotationParser<Object, DirectDependencyMetadata> dependencyNotationParser;
    private final NotationParser<Object, DependencyConstraintMetadata> dependencyConstraintNotationParser;
    private final List<VariantMetadataRules.VariantAction<? super DirectDependenciesMetadata>> dependencyActions = new ArrayList<VariantMetadataRules.VariantAction<? super DirectDependenciesMetadata>>();
    private final List<VariantMetadataRules.VariantAction<? super DependencyConstraintsMetadata>> dependencyConstraintActions = new ArrayList<VariantMetadataRules.VariantAction<? super DependencyConstraintsMetadata>>();
    private final ImmutableAttributesFactory attributesFactory;

    public DependencyMetadataRules(Instantiator instantiator, NotationParser<Object, DirectDependencyMetadata> dependencyNotationParser, NotationParser<Object, DependencyConstraintMetadata> dependencyConstraintNotationParser, ImmutableAttributesFactory attributesFactory) {
        this.instantiator = instantiator;
        this.dependencyNotationParser = dependencyNotationParser;
        this.dependencyConstraintNotationParser = dependencyConstraintNotationParser;
        this.attributesFactory = attributesFactory;
    }

    public void addDependencyAction(VariantMetadataRules.VariantAction<? super DirectDependenciesMetadata> action) {
        this.dependencyActions.add(action);
    }

    public void addDependencyConstraintAction(VariantMetadataRules.VariantAction<? super DependencyConstraintsMetadata> action) {
        this.dependencyConstraintActions.add(action);
    }

    public <T extends ModuleDependencyMetadata> List<? extends ModuleDependencyMetadata> execute(VariantResolveMetadata variant, List<T> dependencies) {
        ImmutableList.Builder calculatedDependencies = new ImmutableList.Builder();
        calculatedDependencies.addAll(this.executeDependencyRules(variant, dependencies));
        calculatedDependencies.addAll(this.executeDependencyConstraintRules(variant, dependencies));
        return calculatedDependencies.build();
    }

    private <T extends ModuleDependencyMetadata> List<? extends ModuleDependencyMetadata> executeDependencyRules(VariantResolveMetadata variant, List<T> dependencies) {
        if (this.dependencyActions.isEmpty()) {
            return CollectionUtils.filter(dependencies, DEPENDENCY_FILTER);
        }
        DirectDependenciesMetadataAdapter adapter = (DirectDependenciesMetadataAdapter)this.instantiator.newInstance(DirectDependenciesMetadataAdapter.class, new Object[]{this.attributesFactory, this.instantiator, this.dependencyNotationParser});
        CollectionUtils.filter(dependencies, DEPENDENCY_FILTER).forEach(dep -> adapter.add((DirectDependencyMetadata)this.instantiator.newInstance(DirectDependencyMetadataAdapter.class, new Object[]{this.attributesFactory, dep})));
        this.dependencyActions.forEach(action -> action.maybeExecute(variant, adapter));
        return adapter.getMetadatas();
    }

    private <T extends ModuleDependencyMetadata> List<? extends ModuleDependencyMetadata> executeDependencyConstraintRules(VariantResolveMetadata variant, List<T> dependencies) {
        if (this.dependencyConstraintActions.isEmpty()) {
            return CollectionUtils.filter(dependencies, DEPENDENCY_CONSTRAINT_FILTER);
        }
        DependencyConstraintsMetadataAdapter adapter = (DependencyConstraintsMetadataAdapter)this.instantiator.newInstance(DependencyConstraintsMetadataAdapter.class, new Object[]{this.attributesFactory, this.instantiator, this.dependencyConstraintNotationParser});
        CollectionUtils.filter(dependencies, DEPENDENCY_CONSTRAINT_FILTER).forEach(dep -> adapter.add((DependencyConstraintMetadata)this.instantiator.newInstance(DependencyConstraintMetadataAdapter.class, new Object[]{this.attributesFactory, dep})));
        this.dependencyConstraintActions.forEach(action -> action.maybeExecute(variant, adapter));
        return adapter.getMetadatas();
    }
}

