/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.problems.internal;

import com.google.common.base.Preconditions;
import org.gradle.api.problems.internal.AdditionalData;
import org.gradle.api.problems.internal.AdditionalDataBuilder;
import org.gradle.api.problems.internal.AdditionalDataSpec;
import org.gradle.api.problems.internal.DefaultDeprecationData;
import org.gradle.api.problems.internal.DefaultGeneralData;
import org.gradle.api.problems.internal.DefaultTypeValidationData;
import org.gradle.api.problems.internal.DeprecationData;
import org.gradle.api.problems.internal.DeprecationDataSpec;
import org.gradle.api.problems.internal.GeneralData;
import org.gradle.api.problems.internal.GeneralDataSpec;
import org.gradle.api.problems.internal.TypeValidationData;
import org.gradle.api.problems.internal.TypeValidationDataSpec;

public class AdditionalDataBuilderFactory {
    public static <T extends AdditionalData, S extends AdditionalDataSpec> AdditionalDataBuilder<T> builderFor(Class<? extends S> type) {
        Preconditions.checkNotNull(type);
        if (TypeValidationDataSpec.class.isAssignableFrom(type)) {
            return DefaultTypeValidationData.builder();
        }
        if (DeprecationDataSpec.class.isAssignableFrom(type)) {
            return DefaultDeprecationData.builder();
        }
        if (GeneralDataSpec.class.isAssignableFrom(type)) {
            return DefaultGeneralData.builder();
        }
        throw new IllegalArgumentException("Unsupported type: " + type);
    }

    public static <S extends AdditionalData> AdditionalDataBuilder<S> builderFor(S instance) {
        Preconditions.checkNotNull(instance);
        if (TypeValidationData.class.isInstance(instance)) {
            return DefaultTypeValidationData.builder((TypeValidationData)instance);
        }
        if (DeprecationData.class.isInstance(instance)) {
            return DefaultDeprecationData.builder((DeprecationData)instance);
        }
        if (GeneralData.class.isInstance(instance)) {
            return DefaultGeneralData.builder((GeneralData)instance);
        }
        throw new IllegalArgumentException("Unsupported instance: " + instance);
    }
}

