/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.instrumentation.agent;

import java.lang.instrument.ClassFileTransformer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.gradle.internal.UncheckedException;
import org.jspecify.annotations.Nullable;
import org.slf4j.LoggerFactory;

class AgentControl {
    private static final String INSTRUMENTATION_AGENT_CLASS_NAME = "org.gradle.instrumentation.agent.Agent";

    private AgentControl() {
    }

    public static boolean isInstrumentationAgentApplied() {
        Method isAppliedMethod = AgentControl.findAgentMethod(INSTRUMENTATION_AGENT_CLASS_NAME, "isApplied", new Class[0]);
        if (isAppliedMethod == null) {
            return false;
        }
        return AgentControl.callStaticAgentMethod(isAppliedMethod, new Object[0]);
    }

    public static boolean installTransformer(ClassFileTransformer transformer) {
        Method installTransformer = AgentControl.findAgentMethod(INSTRUMENTATION_AGENT_CLASS_NAME, "installTransformer", ClassFileTransformer.class);
        if (installTransformer == null) {
            return false;
        }
        return AgentControl.callStaticAgentMethod(installTransformer, transformer);
    }

    private static @Nullable Class<?> tryLoadAgentClass(String agentClassName) {
        try {
            return ClassLoader.getSystemClassLoader().loadClass(agentClassName);
        }
        catch (ClassNotFoundException e) {
            LoggerFactory.getLogger(AgentControl.class).debug("Agent {} is not loaded", (Object)agentClassName);
            return null;
        }
    }

    private static @Nullable Method findAgentMethod(String agentClassName, String methodName, Class<?> ... args) {
        Class<?> agentClass = AgentControl.tryLoadAgentClass(agentClassName);
        if (agentClass == null) {
            return null;
        }
        try {
            Method method = agentClass.getMethod(methodName, args);
            method.setAccessible(true);
            return method;
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private static boolean callStaticAgentMethod(Method method, Object ... args) {
        try {
            return (Boolean)method.invoke(null, args);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException(e);
        }
        catch (InvocationTargetException e) {
            throw UncheckedException.unwrapAndRethrow((InvocationTargetException)e);
        }
    }
}

