/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.impl;

import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.codehaus.groovy.grails.exceptions.DefaultStackTraceFilterer;
import org.slf4j.helpers.FormattingTuple;
import org.slf4j.helpers.MarkerIgnoringBase;
import org.slf4j.helpers.MessageFormatter;

public class GrailsLog4jLoggerAdapter
extends MarkerIgnoringBase {
    private static final long serialVersionUID = 1L;
    static final String FQCN = GrailsLog4jLoggerAdapter.class.getName();
    private final Logger log4jLogger;

    public GrailsLog4jLoggerAdapter(Logger logger) {
        this.log4jLogger = logger;
        this.name = logger.getName();
    }

    public boolean isTraceEnabled() {
        return this.log4jLogger.isTraceEnabled();
    }

    public void trace(String msg) {
        this.logMessage(Level.TRACE, msg, null);
    }

    public void trace(String format, Object arg) {
        this.logMessageFormat(Level.TRACE, format, arg);
    }

    public void trace(String format, Object arg1, Object arg2) {
        this.logMessageFormat(Level.TRACE, format, arg1, arg2);
    }

    public void trace(String format, Object[] argArray) {
        this.logMessageFormat(Level.TRACE, format, argArray);
    }

    public void trace(String msg, Throwable t) {
        this.logMessage(Level.TRACE, msg, t);
    }

    public boolean isDebugEnabled() {
        return this.log4jLogger.isDebugEnabled();
    }

    public void debug(String msg) {
        this.logMessage(Level.DEBUG, msg, null);
    }

    public void debug(String format, Object arg) {
        this.logMessageFormat(Level.DEBUG, format, arg);
    }

    public void debug(String format, Object arg1, Object arg2) {
        this.logMessageFormat(Level.DEBUG, format, arg1, arg2);
    }

    public void debug(String format, Object[] argArray) {
        this.logMessageFormat(Level.DEBUG, format, argArray);
    }

    public void debug(String msg, Throwable t) {
        this.logMessage(Level.DEBUG, msg, t);
    }

    public boolean isInfoEnabled() {
        return this.log4jLogger.isInfoEnabled();
    }

    public void info(String msg) {
        this.logMessage(Level.INFO, msg, null);
    }

    public void info(String format, Object arg) {
        this.logMessageFormat(Level.INFO, format, arg);
    }

    public void info(String format, Object arg1, Object arg2) {
        this.logMessageFormat(Level.INFO, format, arg1, arg2);
    }

    public void info(String format, Object[] argArray) {
        this.logMessageFormat(Level.INFO, format, argArray);
    }

    public void info(String msg, Throwable t) {
        this.logMessage(Level.INFO, msg, t);
    }

    public boolean isWarnEnabled() {
        return this.log4jLogger.isEnabledFor((Priority)Level.WARN);
    }

    public void warn(String msg) {
        this.logMessage(Level.WARN, msg, null);
    }

    public void warn(String format, Object arg) {
        this.logMessageFormat(Level.WARN, format, arg);
    }

    public void warn(String format, Object[] argArray) {
        this.logMessageFormat(Level.WARN, format, argArray);
    }

    public void warn(String format, Object arg1, Object arg2) {
        this.logMessageFormat(Level.WARN, format, arg1, arg2);
    }

    public void warn(String msg, Throwable t) {
        this.logMessage(Level.WARN, msg, t);
    }

    public boolean isErrorEnabled() {
        return this.log4jLogger.isEnabledFor((Priority)Level.ERROR);
    }

    public void error(String msg) {
        this.logMessage(Level.ERROR, msg, null);
    }

    public void error(String format, Object arg) {
        this.logMessageFormat(Level.ERROR, format, arg);
    }

    public void error(String format, Object arg1, Object arg2) {
        this.logMessageFormat(Level.ERROR, format, arg1, arg2);
    }

    public void error(String format, Object[] argArray) {
        this.logMessageFormat(Level.ERROR, format, argArray);
    }

    public void error(String msg, Throwable t) {
        this.logMessage(Level.ERROR, msg, t);
    }

    private final FormattingTuple getMessageFormat(String format, Object ... args) {
        FormattingTuple ft = MessageFormatter.arrayFormat((String)format, (Object[])args);
        this.cleanIfException(ft.getThrowable());
        return ft;
    }

    private final Throwable cleanIfException(Throwable t) {
        if (t != null) {
            new DefaultStackTraceFilterer().filter(t, true);
        }
        return t;
    }

    private final void logMessageFormat(Level level, String format, Object ... args) {
        if (this.log4jLogger.isEnabledFor((Priority)level)) {
            FormattingTuple ft = this.getMessageFormat(format, args);
            this.log4jLogger.log(FQCN, (Priority)level, (Object)ft.getMessage(), ft.getThrowable());
        }
    }

    private final void logMessage(Level level, String msg, Throwable t) {
        Throwable filteredTrace = t != null && this.log4jLogger.isEnabledFor((Priority)level) && !"StackTrace".equals(this.name) ? this.cleanIfException(t) : t;
        this.log4jLogger.log(FQCN, (Priority)level, (Object)msg, filteredTrace);
    }
}

