/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.uaa.client.internal;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.Provider;
import java.security.Security;
import java.util.prefs.Preferences;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openpgp.PGPObjectFactory;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureList;
import org.bouncycastle.openpgp.PGPUtil;
import org.springframework.uaa.client.internal.UaaDetectedProductsImpl;
import org.springframework.uaa.client.util.Assert;
import org.springframework.uaa.client.util.PreferencesUtils;
import org.springframework.uaa.client.util.StreamUtils;
import org.springframework.uaa.client.util.XmlUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class UaaConfigurationProcessor {
    static final URL SIGNATURE_URL;
    static final URL UAA_URL;
    static final String CONFIGURATION_VERSION_KEY = "configuration_version";
    private static final String KEY_NAME = "/org/springframework/uaa/client/keys/uaa.asc";
    private static final Preferences P;

    private static PGPPublicKeyRing getPublicKey(InputStream in) {
        Object obj;
        try {
            PGPObjectFactory pgpFact = new PGPObjectFactory(PGPUtil.getDecoderStream((InputStream)in));
            obj = pgpFact.nextObject();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        if (obj != null && obj instanceof PGPPublicKeyRing) {
            PGPPublicKeyRing keyRing = (PGPPublicKeyRing)obj;
            return keyRing;
        }
        throw new IllegalStateException("Public key not available");
    }

    private static void storeConfigurationFromNode(Element elem) {
        String path = elem.getAttribute("path");
        Preferences p = Preferences.userRoot().node(path);
        NodeList keys = elem.getElementsByTagName("key");
        for (int i = 0; i < keys.getLength(); ++i) {
            if (!(keys.item(i) instanceof Element)) continue;
            Element keyElem = (Element)keys.item(i);
            String key = keyElem.getAttribute("name");
            String value = keyElem.getAttribute("value");
            if (key.length() <= 0 || value.length() <= 0) continue;
            p.put(key, value);
        }
    }

    private static void storeConfigurationFromNodes(NodeList nodes) {
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (!(node instanceof Element)) continue;
            UaaConfigurationProcessor.storeConfigurationFromNode((Element)node);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final boolean updateConfiguration(InputStream configuration, InputStream configurationSignature) {
        Assert.notNull(configuration, "Configuration required");
        Assert.notNull(configurationSignature, "Configuration signature required");
        InputStream bais = null;
        try {
            bais = StreamUtils.copyIntoResettableStream(configuration);
            if (UaaConfigurationProcessor.validateConfigurationSignature(bais, configurationSignature)) {
                bais.reset();
                Document configurationDocument = XmlUtils.parse(bais);
                Element documentElement = configurationDocument.getDocumentElement();
                Integer incomingVersion = new Integer(documentElement.getAttribute("version"));
                Integer existingVersion = P.getInt(CONFIGURATION_VERSION_KEY, 0);
                if (incomingVersion > existingVersion) {
                    UaaConfigurationProcessor.storeConfigurationFromNodes(documentElement.getElementsByTagName("node"));
                    P.putInt(CONFIGURATION_VERSION_KEY, incomingVersion);
                }
                bais.reset();
                UaaDetectedProductsImpl.setProducts(bais);
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception e) {
        }
        finally {
            if (bais != null) {
                try {
                    bais.close();
                }
                catch (IOException e) {}
            }
        }
        return false;
    }

    static final boolean validateConfigurationSignature(InputStream resource, InputStream signature) {
        try {
            int chunk;
            PGPPublicKey publicKey = UaaConfigurationProcessor.getPublicKey(UaaConfigurationProcessor.class.getResourceAsStream(KEY_NAME)).getPublicKey();
            PGPObjectFactory factory = new PGPObjectFactory(PGPUtil.getDecoderStream((InputStream)signature));
            PGPSignatureList p3 = (PGPSignatureList)factory.nextObject();
            PGPSignature pgpSignature = p3.get(0);
            pgpSignature.initVerify(publicKey, "BC");
            byte[] buff = new byte[1024];
            do {
                if ((chunk = resource.read(buff)) <= 0) continue;
                pgpSignature.update(buff, 0, chunk);
            } while (chunk >= 0);
            return pgpSignature.verify();
        }
        catch (Exception e) {
            return false;
        }
    }

    static {
        P = PreferencesUtils.getPreferencesFor(UaaConfigurationProcessor.class);
        Security.addProvider((Provider)new BouncyCastleProvider());
        try {
            UAA_URL = new URL("http://uaa.springsource.org/uaa-client.xml");
            SIGNATURE_URL = new URL("http://uaa.springsource.org/uaa-client.xml.asc");
        }
        catch (MalformedURLException neverHappens) {
            throw new IllegalStateException(neverHappens);
        }
    }
}

