/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.plugins;

import groovy.util.ConfigObject;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.codehaus.groovy.grails.plugins.ExcludingPluginFilter;
import org.codehaus.groovy.grails.plugins.IdentityPluginFilter;
import org.codehaus.groovy.grails.plugins.IncludingPluginFilter;
import org.codehaus.groovy.grails.plugins.PluginFilter;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class PluginFilterRetriever {
    public PluginFilter getPluginFilter(Map properties) {
        Object excludes;
        Object includes;
        Assert.notNull((Object)properties);
        if (properties instanceof ConfigObject) {
            properties = ((ConfigObject)properties).flatten();
        }
        if ((includes = properties.get("grails.plugin.includes")) == null) {
            properties.get("plugin.includes");
        }
        if ((excludes = properties.get("grails.plugin.excludes")) == null) {
            properties.get("plugin.excludes");
        }
        return this.getPluginFilter(includes, excludes);
    }

    PluginFilter getPluginFilter(Object includes, Object excludes) {
        PluginFilter pluginFilter = null;
        if (includes != null) {
            if (includes instanceof Collection) {
                pluginFilter = new IncludingPluginFilter((Set)new HashSet((Collection)includes));
            } else {
                String[] includesArray = StringUtils.commaDelimitedListToStringArray((String)includes.toString());
                pluginFilter = new IncludingPluginFilter(includesArray);
            }
        } else if (excludes != null) {
            if (excludes instanceof Collection) {
                pluginFilter = new ExcludingPluginFilter((Set)new HashSet((Collection)excludes));
            } else {
                String[] excludesArray = StringUtils.commaDelimitedListToStringArray((String)excludes.toString());
                pluginFilter = new ExcludingPluginFilter(excludesArray);
            }
        } else {
            pluginFilter = new IdentityPluginFilter();
        }
        return pluginFilter;
    }
}

