/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.engine;

import java.util.Iterator;
import org.springframework.core.style.StylerUtils;
import org.springframework.core.style.ToStringCreator;
import org.springframework.webflow.definition.TransitionDefinition;
import org.springframework.webflow.definition.TransitionableStateDefinition;
import org.springframework.webflow.engine.ActionList;
import org.springframework.webflow.engine.Flow;
import org.springframework.webflow.engine.NoMatchingTransitionException;
import org.springframework.webflow.engine.RequestControlContext;
import org.springframework.webflow.engine.State;
import org.springframework.webflow.engine.Transition;
import org.springframework.webflow.engine.TransitionSet;
import org.springframework.webflow.execution.RequestContext;

public abstract class TransitionableState
extends State
implements TransitionableStateDefinition {
    private TransitionSet transitions = new TransitionSet();
    private ActionList exitActionList = new ActionList();

    protected TransitionableState(Flow flow, String id) throws IllegalArgumentException {
        super(flow, id);
    }

    public TransitionDefinition[] getTransitions() {
        return this.getTransitionSet().toArray();
    }

    public TransitionDefinition getTransition(String eventId) {
        Iterator it = this.transitions.iterator();
        while (it.hasNext()) {
            Transition transition = (Transition)it.next();
            if (!transition.getId().equals(eventId)) continue;
            return transition;
        }
        return null;
    }

    public TransitionSet getTransitionSet() {
        return this.transitions;
    }

    public Transition getRequiredTransition(RequestContext context) throws NoMatchingTransitionException {
        Transition transition = this.getTransitionSet().getTransition(context);
        if (transition == null) {
            throw new NoMatchingTransitionException(this.getFlow().getId(), this.getId(), context.getCurrentEvent(), "No transition found on occurence of event '" + context.getCurrentEvent() + "' in state '" + this.getId() + "' of flow '" + this.getFlow().getId() + "' -- valid transitional criteria are " + StylerUtils.style((Object)this.getTransitionSet().getTransitionCriterias()) + " -- likely programmer error, check the set of TransitionCriteria for this state");
        }
        return transition;
    }

    public ActionList getExitActionList() {
        return this.exitActionList;
    }

    public boolean handleEvent(RequestControlContext context) throws NoMatchingTransitionException {
        return context.execute(this.getRequiredTransition(context));
    }

    public void exit(RequestControlContext context) {
        this.exitActionList.execute(context);
    }

    protected void appendToString(ToStringCreator creator) {
        creator.append("transitions", (Object)this.transitions).append("exitActionList", (Object)this.exitActionList);
    }
}

