/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.binding.convert.converters;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.binding.convert.converters.InvalidFormatException;
import org.springframework.binding.convert.converters.StringToObject;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.util.StringUtils;

public class StringToDate
extends StringToObject {
    private static Log logger;
    private static final String DEFAULT_PATTERN = "yyyy-MM-dd";
    private String pattern;
    private Locale locale;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.springframework.binding.convert.converters.StringToDate");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = LogFactory.getLog((Class)clazz);
    }

    public StringToDate() {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("java.util.Date");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        super(clazz);
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public Object toObject(String string, Class targetClass) throws Exception {
        if (!StringUtils.hasText((String)string)) {
            return null;
        }
        DateFormat dateFormat = this.getDateFormat();
        try {
            return dateFormat.parse(string);
        }
        catch (ParseException e) {
            throw new InvalidFormatException(string, this.getPattern(dateFormat), e);
        }
    }

    public String toString(Object target) throws Exception {
        Date date = (Date)target;
        if (date == null) {
            return "";
        }
        return this.getDateFormat().format(date);
    }

    protected DateFormat getDateFormat() {
        Locale locale = this.determineLocale(this.locale);
        DateFormat format = DateFormat.getDateInstance(3, locale);
        format.setLenient(false);
        if (format instanceof SimpleDateFormat) {
            String pattern = this.determinePattern(this.pattern);
            ((SimpleDateFormat)format).applyPattern(pattern);
        } else {
            logger.warn((Object)("Unable to apply format pattern '" + this.pattern + "'; Returned DateFormat is not a SimpleDateFormat"));
        }
        return format;
    }

    private String determinePattern(String pattern) {
        return pattern != null ? pattern : DEFAULT_PATTERN;
    }

    private Locale determineLocale(Locale locale) {
        return locale != null ? locale : LocaleContextHolder.getLocale();
    }

    private String getPattern(DateFormat format) {
        if (format instanceof SimpleDateFormat) {
            return ((SimpleDateFormat)format).toPattern();
        }
        logger.warn((Object)"Pattern string cannot be determined because DateFormat is not a SimpleDateFormat");
        return "defaultDateFormatInstance";
    }
}

