/*
 * Decompiled with CFR 0.152.
 */
package org.grails.plugins.tomcat;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParentDelegatingClassLoader
extends ClassLoader {
    private Method findClassMethod = this.findMethod(ClassLoader.class, "findClass", String.class);

    protected ParentDelegatingClassLoader(ClassLoader parent) {
        super(parent);
        this.findClassMethod.setAccessible(true);
    }

    private Method findMethod(Class<?> clazz, String name, Class<?> ... paramTypes) {
        for (Class<?> searchType = clazz; searchType != null; searchType = searchType.getSuperclass()) {
            Method[] methods;
            for (Method method : methods = searchType.isInterface() ? searchType.getMethods() : searchType.getDeclaredMethods()) {
                if (!name.equals(method.getName()) || paramTypes != null && !Arrays.equals(paramTypes, method.getParameterTypes())) continue;
                return method;
            }
        }
        return null;
    }

    @Override
    protected Class<?> findClass(String className) throws ClassNotFoundException {
        try {
            return (Class)this.findClassMethod.invoke((Object)this.getParent(), className);
        }
        catch (IllegalAccessException e) {
            throw new ClassNotFoundException(className);
        }
        catch (InvocationTargetException e) {
            throw new ClassNotFoundException(className);
        }
    }
}

