/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.event;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.Status;
import net.sf.ehcache.distribution.CacheReplicator;
import net.sf.ehcache.event.CacheEventListener;

public class TerracottaCacheEventReplication
implements CacheReplicator {
    private Status status = Status.STATUS_ALIVE;
    private final ConcurrentMap<Ehcache, CacheEventListener> replicators = new ConcurrentHashMap<Ehcache, CacheEventListener>();

    public void notifyElementRemoved(Ehcache cache, Element element) throws CacheException {
        if (cache.getCacheConfiguration().isTerracottaClustered()) {
            this.createCacheEventReplicator(cache).notifyElementRemoved(cache, element);
        }
    }

    public void notifyElementPut(Ehcache cache, Element element) throws CacheException {
        if (cache.getCacheConfiguration().isTerracottaClustered()) {
            this.createCacheEventReplicator(cache).notifyElementPut(cache, element);
        }
    }

    public void notifyElementUpdated(Ehcache cache, Element element) throws CacheException {
        if (cache.getCacheConfiguration().isTerracottaClustered()) {
            this.createCacheEventReplicator(cache).notifyElementUpdated(cache, element);
        }
    }

    public void notifyElementExpired(Ehcache cache, Element element) {
        if (cache.getCacheConfiguration().isTerracottaClustered()) {
            this.createCacheEventReplicator(cache).notifyElementExpired(cache, element);
        }
    }

    public void notifyElementEvicted(Ehcache cache, Element element) {
        if (cache.getCacheConfiguration().isTerracottaClustered()) {
            this.createCacheEventReplicator(cache).notifyElementEvicted(cache, element);
        }
    }

    public void notifyRemoveAll(Ehcache cache) {
        if (cache.getCacheConfiguration().isTerracottaClustered()) {
            this.createCacheEventReplicator(cache).notifyRemoveAll(cache);
        }
    }

    private CacheEventListener createCacheEventReplicator(Ehcache cache) {
        CacheEventListener replicator = (CacheEventListener)this.replicators.get(cache);
        if (null == replicator) {
            replicator = cache.getCacheManager().createTerracottaEventReplicator(cache);
            this.replicators.put(cache, replicator);
        }
        return replicator;
    }

    public TerracottaCacheEventReplication clone() throws CloneNotSupportedException {
        return (TerracottaCacheEventReplication)super.clone();
    }

    public boolean isReplicateUpdatesViaCopy() {
        return false;
    }

    public final boolean notAlive() {
        return !this.alive();
    }

    public final boolean alive() {
        return this.status != null && this.status.equals(Status.STATUS_ALIVE);
    }

    public void dispose() {
        this.status = Status.STATUS_SHUTDOWN;
    }
}

