/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.convert.support;

import java.util.Locale;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.converter.ConverterRegistry;
import org.springframework.core.convert.support.ArrayToArrayConverter;
import org.springframework.core.convert.support.ArrayToCollectionConverter;
import org.springframework.core.convert.support.ArrayToObjectConverter;
import org.springframework.core.convert.support.ArrayToStringConverter;
import org.springframework.core.convert.support.CharacterToNumberFactory;
import org.springframework.core.convert.support.CollectionToArrayConverter;
import org.springframework.core.convert.support.CollectionToCollectionConverter;
import org.springframework.core.convert.support.CollectionToObjectConverter;
import org.springframework.core.convert.support.CollectionToStringConverter;
import org.springframework.core.convert.support.EnumToStringConverter;
import org.springframework.core.convert.support.FallbackObjectToStringConverter;
import org.springframework.core.convert.support.GenericConversionService;
import org.springframework.core.convert.support.IdToEntityConverter;
import org.springframework.core.convert.support.MapToMapConverter;
import org.springframework.core.convert.support.NumberToCharacterConverter;
import org.springframework.core.convert.support.NumberToNumberConverterFactory;
import org.springframework.core.convert.support.ObjectToArrayConverter;
import org.springframework.core.convert.support.ObjectToCollectionConverter;
import org.springframework.core.convert.support.ObjectToObjectConverter;
import org.springframework.core.convert.support.ObjectToStringConverter;
import org.springframework.core.convert.support.PropertiesToStringConverter;
import org.springframework.core.convert.support.StringToArrayConverter;
import org.springframework.core.convert.support.StringToBooleanConverter;
import org.springframework.core.convert.support.StringToCharacterConverter;
import org.springframework.core.convert.support.StringToCollectionConverter;
import org.springframework.core.convert.support.StringToEnumConverterFactory;
import org.springframework.core.convert.support.StringToLocaleConverter;
import org.springframework.core.convert.support.StringToNumberConverterFactory;
import org.springframework.core.convert.support.StringToPropertiesConverter;

public class DefaultConversionService
extends GenericConversionService {
    public DefaultConversionService() {
        DefaultConversionService.addDefaultConverters(this);
    }

    public static void addDefaultConverters(ConverterRegistry converterRegistry) {
        DefaultConversionService.addScalarConverters(converterRegistry);
        DefaultConversionService.addCollectionConverters(converterRegistry);
        DefaultConversionService.addFallbackConverters(converterRegistry);
    }

    private static void addScalarConverters(ConverterRegistry converterRegistry) {
        converterRegistry.addConverter(new StringToBooleanConverter());
        converterRegistry.addConverter(Boolean.class, String.class, new ObjectToStringConverter());
        converterRegistry.addConverterFactory(new StringToNumberConverterFactory());
        converterRegistry.addConverter(Number.class, String.class, new ObjectToStringConverter());
        converterRegistry.addConverterFactory(new NumberToNumberConverterFactory());
        converterRegistry.addConverter(new StringToCharacterConverter());
        converterRegistry.addConverter(Character.class, String.class, new ObjectToStringConverter());
        converterRegistry.addConverter(new NumberToCharacterConverter());
        converterRegistry.addConverterFactory(new CharacterToNumberFactory());
        converterRegistry.addConverterFactory(new StringToEnumConverterFactory());
        converterRegistry.addConverter(Enum.class, String.class, new EnumToStringConverter());
        converterRegistry.addConverter(new StringToLocaleConverter());
        converterRegistry.addConverter(Locale.class, String.class, new ObjectToStringConverter());
        converterRegistry.addConverter(new PropertiesToStringConverter());
        converterRegistry.addConverter(new StringToPropertiesConverter());
    }

    private static void addCollectionConverters(ConverterRegistry converterRegistry) {
        ConversionService conversionService = (ConversionService)((Object)converterRegistry);
        converterRegistry.addConverter(new ArrayToCollectionConverter(conversionService));
        converterRegistry.addConverter(new CollectionToArrayConverter(conversionService));
        converterRegistry.addConverter(new ArrayToArrayConverter(conversionService));
        converterRegistry.addConverter(new CollectionToCollectionConverter(conversionService));
        converterRegistry.addConverter(new MapToMapConverter(conversionService));
        converterRegistry.addConverter(new ArrayToStringConverter(conversionService));
        converterRegistry.addConverter(new StringToArrayConverter(conversionService));
        converterRegistry.addConverter(new ArrayToObjectConverter(conversionService));
        converterRegistry.addConverter(new ObjectToArrayConverter(conversionService));
        converterRegistry.addConverter(new CollectionToStringConverter(conversionService));
        converterRegistry.addConverter(new StringToCollectionConverter(conversionService));
        converterRegistry.addConverter(new CollectionToObjectConverter(conversionService));
        converterRegistry.addConverter(new ObjectToCollectionConverter(conversionService));
    }

    private static void addFallbackConverters(ConverterRegistry converterRegistry) {
        ConversionService conversionService = (ConversionService)((Object)converterRegistry);
        converterRegistry.addConverter(new ObjectToObjectConverter());
        converterRegistry.addConverter(new IdToEntityConverter(conversionService));
        converterRegistry.addConverter(new FallbackObjectToStringConverter());
    }
}

