/*
 * Decompiled with CFR 0.152.
 */
package com.springsource.loaded;

import com.springsource.loaded.FieldMember;
import com.springsource.loaded.FieldReaderWriter;
import com.springsource.loaded.GlobalConfiguration;
import com.springsource.loaded.ReloadableType;
import com.springsource.loaded.Utils;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ISMgr {
    private static Logger log = Logger.getLogger(ISMgr.class.getName());
    Map<String, Map<String, Object>> values = new HashMap<String, Map<String, Object>>();

    public ISMgr(Object instance, ReloadableType rtype) {
        if (rtype.getTypeDescriptor().isGroovyType()) {
            rtype.trackLiveInstance(instance);
        }
    }

    public Object getValue(ReloadableType rtype, Object instance, String name) throws IllegalAccessException {
        if (GlobalConfiguration.isRuntimeLogging && log.isLoggable(Level.FINER)) {
            log.finer(">getValue(rtype=" + rtype + ",instance=" + instance + ",name=" + name + ")");
        }
        Object result = null;
        FieldMember field = rtype.findInstanceField(name);
        if (field == null) {
            FieldReaderWriter frw = rtype.locateField(name);
            if (frw == null) {
                log.info("Unexpectedly unable to locate instance field " + name + " starting from type " + rtype.dottedtypename + ": clinit running late?");
                return null;
            }
            result = frw.getValue(instance, this);
        } else {
            if (field.isStatic()) {
                throw new IncompatibleClassChangeError("Expected non-static field " + rtype.dottedtypename + "." + field.getName());
            }
            String declaringTypeName = field.getDeclaringTypeName();
            Map<String, Object> typeLevelValues = this.values.get(declaringTypeName);
            boolean knownField = false;
            if (typeLevelValues != null) {
                knownField = typeLevelValues.containsKey(name);
            }
            if (knownField) {
                result = typeLevelValues.get(name);
            }
            if (typeLevelValues == null || !knownField) {
                FieldMember fieldOnOriginalType = rtype.getTypeRegistry().getReloadableType(field.getDeclaringTypeName()).getTypeDescriptor().getField(name);
                if (fieldOnOriginalType != null) {
                    ReloadableType rt = rtype.getTypeRegistry().getReloadableType(field.getDeclaringTypeName());
                    try {
                        Field f = rt.getClazz().getDeclaredField(name);
                        f.setAccessible(true);
                        result = f.get(instance);
                        if (typeLevelValues == null) {
                            typeLevelValues = new HashMap<String, Object>();
                            this.values.put(declaringTypeName, typeLevelValues);
                        }
                        typeLevelValues.put(name, result);
                    }
                    catch (Exception e) {
                        throw new IllegalStateException("Unexpectedly unable to access field " + name + " on type " + rt.getClazz().getName(), e);
                    }
                } else {
                    result = Utils.toResultCheckIfNull(null, field.getDescriptor());
                    if (typeLevelValues == null) {
                        typeLevelValues = new HashMap<String, Object>();
                        this.values.put(declaringTypeName, typeLevelValues);
                    }
                    typeLevelValues.put(name, result);
                    return result;
                }
            }
            if (result != null && (result = Utils.checkCompatibility(rtype.getTypeRegistry(), result, field.getDescriptor())) == null) {
                typeLevelValues.remove(field.getName());
            }
            result = Utils.toResultCheckIfNull(result, field.getDescriptor());
        }
        if (GlobalConfiguration.isRuntimeLogging && log.isLoggable(Level.FINER)) {
            log.finer("<getValue() value of " + name + " is " + result);
        }
        return result;
    }

    public void setValue(ReloadableType rtype, Object instance, Object value, String name) throws IllegalAccessException {
        FieldMember fieldmember = rtype.findInstanceField(name);
        if (fieldmember == null) {
            FieldReaderWriter frw = rtype.locateField(name);
            if (frw == null) {
                log.info("Unexpectedly unable to locate instance field " + name + " starting from type " + rtype.dottedtypename + ": clinit running late?");
                return;
            }
            frw.setValue(instance, value, this);
        } else {
            if (fieldmember.isStatic()) {
                throw new IncompatibleClassChangeError("Expected non-static field " + rtype.dottedtypename + "." + fieldmember.getName());
            }
            Map<String, Object> typeValues = this.values.get(fieldmember.getDeclaringTypeName());
            if (typeValues == null) {
                typeValues = new HashMap<String, Object>();
                this.values.put(fieldmember.getDeclaringTypeName(), typeValues);
            }
            typeValues.put(name, value);
        }
    }

    private String valuesToString() {
        StringBuilder s = new StringBuilder();
        s.append("InstanceState:" + System.identityHashCode(this)).append("\n");
        for (Map.Entry<String, Map<String, Object>> entry : this.values.entrySet()) {
            s.append("Type " + entry.getKey()).append("\n");
            for (Map.Entry<String, Object> entry2 : entry.getValue().entrySet()) {
                s.append(" " + entry2.getKey() + "=" + entry2.getValue()).append("\n");
            }
        }
        return s.toString();
    }

    public String toString() {
        return this.valuesToString();
    }

    Map<String, Map<String, Object>> getMap() {
        return this.values;
    }
}

