/*
 * Decompiled with CFR 0.152.
 */
package com.springsource.loaded.ri;

import com.springsource.loaded.ri.Invoker;
import com.springsource.loaded.ri.MethodProvider;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetMethodsLookup {
    public Collection<Invoker> lookup(MethodProvider methodProvider) {
        HashMap<String, Invoker> found = new HashMap<String, Invoker>();
        this.collectAll(methodProvider, found);
        return found.values();
    }

    private void collectAll(MethodProvider methodProvider, Map<String, Invoker> found) {
        MethodProvider[] itfs = methodProvider.getInterfaces();
        int i = itfs.length - 1;
        while (i >= 0) {
            this.collectAll(itfs[i], found);
            --i;
        }
        MethodProvider supr = methodProvider.getSuper();
        if (supr != null && !methodProvider.isInterface()) {
            this.collectAll(supr, found);
        }
        for (Invoker method : methodProvider.getDeclaredMethods()) {
            if (!Modifier.isPublic(method.getModifiers())) continue;
            found.put(String.valueOf(method.getName()) + method.getMethodDescriptor(), method);
        }
    }
}

