/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.sdk.discord;

import java.util.LinkedHashMap;
import org.jreleaser.model.Discord;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.announcer.spi.AnnounceException;
import org.jreleaser.model.announcer.spi.Announcer;
import org.jreleaser.sdk.commons.ClientUtils;
import org.jreleaser.sdk.discord.Message;
import org.jreleaser.util.JReleaserLogger;
import org.jreleaser.util.MustacheUtils;
import org.jreleaser.util.StringUtils;

public class DiscordAnnouncer
implements Announcer {
    private final JReleaserContext context;

    DiscordAnnouncer(JReleaserContext context) {
        this.context = context;
    }

    public String getName() {
        return "discord";
    }

    public boolean isEnabled() {
        return this.context.getModel().getAnnounce().getDiscord().isEnabled();
    }

    public void announce() throws AnnounceException {
        Discord discord = this.context.getModel().getAnnounce().getDiscord();
        String message = "";
        if (StringUtils.isNotBlank((String)discord.getMessage())) {
            message = discord.getResolvedMessage(this.context);
        } else {
            LinkedHashMap<String, String> props = new LinkedHashMap<String, String>();
            props.put("changelog", MustacheUtils.passThrough((String)this.context.getChangelog()));
            this.context.getModel().getRelease().getGitService().fillProps(props, this.context.getModel());
            message = discord.getResolvedMessageTemplate(this.context, props);
        }
        this.context.getLogger().info("message: {}", new Object[]{message});
        if (!this.context.isDryrun()) {
            ClientUtils.webhook((JReleaserLogger)this.context.getLogger(), (String)discord.getResolvedWebhook(), (int)discord.getConnectTimeout(), (int)discord.getReadTimeout(), (Object)Message.of(message));
        }
    }
}

