/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.sdk.mail;

import java.util.LinkedHashMap;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.Mail;
import org.jreleaser.model.announcer.spi.AnnounceException;
import org.jreleaser.model.announcer.spi.Announcer;
import org.jreleaser.sdk.mail.MailException;
import org.jreleaser.sdk.mail.MessageMailCommand;
import org.jreleaser.util.MustacheUtils;
import org.jreleaser.util.StringUtils;

public class MailAnnouncer
implements Announcer {
    private final JReleaserContext context;

    MailAnnouncer(JReleaserContext context) {
        this.context = context;
    }

    public String getName() {
        return "mail";
    }

    public boolean isEnabled() {
        return this.context.getModel().getAnnounce().getMail().isEnabled();
    }

    public void announce() throws AnnounceException {
        Mail mail = this.context.getModel().getAnnounce().getMail();
        String message = "";
        if (StringUtils.isNotBlank((String)mail.getMessage())) {
            message = mail.getResolvedMessage(this.context);
        } else {
            LinkedHashMap<String, String> props = new LinkedHashMap<String, String>();
            props.put("changelog", MustacheUtils.passThrough((String)this.context.getChangelog()));
            this.context.getModel().getRelease().getGitService().fillProps(props, this.context.getModel());
            message = mail.getResolvedMessageTemplate(this.context, props);
        }
        String subject = mail.getResolvedSubject(this.context);
        this.context.getLogger().info("subject: {}", new Object[]{subject});
        this.context.getLogger().debug("message: {}", new Object[]{message});
        try {
            MessageMailCommand.builder(this.context.getLogger()).dryrun(this.context.isDryrun()).transport(mail.getTransport()).host(mail.getHost()).port(mail.getPort()).auth(mail.isAuth()).username(mail.getUsername()).password(this.context.isDryrun() ? "**UNDEFINED**" : mail.getResolvedPassword()).from(mail.getFrom()).to(mail.getTo()).cc(mail.getCc()).bcc(mail.getBcc()).subject(subject).message(message).mimeType(mail.getMimeType()).build().execute();
        }
        catch (MailException e) {
            this.context.getLogger().trace((Throwable)e);
            throw new AnnounceException((Throwable)e);
        }
    }
}

