/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.jreleaser.model.AbstractAnnouncer;
import org.jreleaser.model.Artifact;
import org.jreleaser.model.CommitAuthor;
import org.jreleaser.model.CommitAuthorAware;
import org.jreleaser.model.Repository;

public class Article
extends AbstractAnnouncer
implements CommitAuthorAware {
    public static final String NAME = "article";
    private final Set<Artifact> files = new LinkedHashSet<Artifact>();
    private final CommitAuthor commitAuthor = new CommitAuthor();
    private final Repository repository = new Repository();
    private String templateDirectory;

    public Article() {
        super(NAME);
    }

    void setAll(Article article) {
        super.setAll(article);
        this.templateDirectory = article.templateDirectory;
        this.setFiles(article.files);
        this.setCommitAuthor(article.commitAuthor);
        this.setRepository(article.repository);
    }

    public Set<Artifact> getFiles() {
        return Artifact.sortArtifacts(this.files);
    }

    public void setFiles(Set<Artifact> files) {
        this.files.clear();
        this.files.addAll(files);
    }

    public void addFiles(Set<Artifact> files) {
        this.files.addAll(files);
    }

    public void addFile(Artifact artifact) {
        if (null != artifact) {
            this.files.add(artifact);
        }
    }

    @Override
    public CommitAuthor getCommitAuthor() {
        return this.commitAuthor;
    }

    @Override
    public void setCommitAuthor(CommitAuthor commitAuthor) {
        this.commitAuthor.setAll(commitAuthor);
    }

    public Repository getRepository() {
        return this.repository;
    }

    public void setRepository(Repository repository) {
        this.repository.setAll(repository);
    }

    public String getTemplateDirectory() {
        return this.templateDirectory;
    }

    public void setTemplateDirectory(String templateDirectory) {
        this.templateDirectory = templateDirectory;
    }

    @Override
    protected void asMap(Map<String, Object> props, boolean full) {
        props.put("commitAuthor", this.commitAuthor.asMap(full));
        props.put("repository", this.repository.asMap(full));
        LinkedHashMap<String, Map<String, Object>> mappedArtifacts = new LinkedHashMap<String, Map<String, Object>>();
        int i = 0;
        for (Artifact artifact : this.getFiles()) {
            mappedArtifacts.put("files " + i++, artifact.asMap(full));
        }
        props.put("files", mappedArtifacts);
        props.put("templateDirectory", this.templateDirectory);
    }
}

