/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.Assembler;
import org.jreleaser.model.Distribution;
import org.jreleaser.model.Domain;
import org.jreleaser.model.ExtraProperties;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.util.Artifacts;
import org.jreleaser.util.Algorithm;
import org.jreleaser.util.JReleaserException;
import org.jreleaser.util.StringUtils;

public class Artifact
implements Domain,
ExtraProperties {
    private final Map<String, Object> extraProperties = new LinkedHashMap<String, Object>();
    @JsonIgnore
    private final Map<Algorithm, String> hashes = new LinkedHashMap<Algorithm, String>();
    private String path;
    private String platform;
    private String transform;
    @JsonIgnore
    private boolean active;
    @JsonIgnore
    private Path effectivePath;
    @JsonIgnore
    private Path resolvedPath;
    @JsonIgnore
    private Path resolvedTransform;

    void setAll(Artifact artifact) {
        this.effectivePath = artifact.effectivePath;
        this.path = artifact.path;
        this.platform = artifact.platform;
        this.transform = artifact.transform;
        this.resolvedPath = artifact.resolvedPath;
        this.resolvedTransform = artifact.resolvedTransform;
        this.active = artifact.active;
        this.setExtraProperties(artifact.extraProperties);
        this.setHashes(artifact.hashes);
    }

    public boolean isActive() {
        return this.active;
    }

    public void activate() {
        this.active = true;
    }

    public Path getEffectivePath() {
        return this.effectivePath;
    }

    public Path getEffectivePath(JReleaserContext context) {
        if (null == this.effectivePath) {
            Path rp = this.getResolvedPath(context);
            Path tp = this.getResolvedTransform(context);
            this.effectivePath = Artifacts.checkAndCopyFile(context, rp, tp);
        }
        return this.effectivePath;
    }

    public Path getEffectivePath(JReleaserContext context, Distribution distribution) {
        if (null == this.effectivePath) {
            Path rp = this.getResolvedPath(context, distribution);
            Path tp = this.getResolvedTransform(context, distribution);
            this.effectivePath = Artifacts.checkAndCopyFile(context, rp, tp);
        }
        return this.effectivePath;
    }

    public Path getEffectivePath(JReleaserContext context, Assembler assembler) {
        if (null == this.effectivePath) {
            Path rp = this.getResolvedPath(context, assembler);
            Path tp = this.getResolvedTransform(context, assembler);
            this.effectivePath = Artifacts.checkAndCopyFile(context, rp, tp);
        }
        return this.effectivePath;
    }

    public Path getResolvedPath(JReleaserContext context, Path basedir, boolean checkIfExists) {
        if (null == this.resolvedPath) {
            this.path = Artifacts.resolveForArtifact(this.path, context, this);
            this.resolvedPath = basedir.resolve(Paths.get(this.path, new String[0])).normalize();
            if (checkIfExists && !Files.exists(this.resolvedPath, new LinkOption[0])) {
                throw new JReleaserException(RB.$((String)"ERROR_path_does_not_exist", (Object[])new Object[]{context.relativizeToBasedir(this.resolvedPath)}));
            }
        }
        return this.resolvedPath;
    }

    public Path getResolvedPath(JReleaserContext context) {
        return this.getResolvedPath(context, context.getBasedir(), context.getMode().validatePaths());
    }

    public Path getResolvedPath(JReleaserContext context, Distribution distribution) {
        if (null == this.resolvedPath) {
            this.path = Artifacts.resolveForArtifact(this.path, context, this, distribution);
            this.resolvedPath = context.getBasedir().resolve(Paths.get(this.path, new String[0])).normalize();
            if (context.getMode().validatePaths() && !Files.exists(this.resolvedPath, new LinkOption[0])) {
                throw new JReleaserException(RB.$((String)"ERROR_path_does_not_exist", (Object[])new Object[]{context.relativizeToBasedir(this.resolvedPath)}));
            }
        }
        return this.resolvedPath;
    }

    public Path getResolvedPath(JReleaserContext context, Assembler assembler) {
        if (null == this.resolvedPath) {
            this.path = Artifacts.resolveForArtifact(this.path, context, this, assembler);
            this.resolvedPath = context.getBasedir().resolve(Paths.get(this.path, new String[0])).normalize();
            if (context.getMode().validatePaths() && !Files.exists(this.resolvedPath, new LinkOption[0])) {
                throw new JReleaserException(RB.$((String)"ERROR_path_does_not_exist", (Object[])new Object[]{context.relativizeToBasedir(this.resolvedPath)}));
            }
        }
        return this.resolvedPath;
    }

    public Path getResolvedPath() {
        return this.resolvedPath;
    }

    public Path getResolvedTransform(JReleaserContext context, Path basedir) {
        if (null == this.resolvedTransform && StringUtils.isNotBlank((String)this.transform)) {
            this.transform = Artifacts.resolveForArtifact(this.transform, context, this);
            this.resolvedTransform = basedir.resolve(Paths.get(this.transform, new String[0])).normalize();
        }
        return this.resolvedTransform;
    }

    public Path getResolvedTransform(JReleaserContext context) {
        return this.getResolvedTransform(context, context.getArtifactsDirectory());
    }

    public Path getResolvedTransform(JReleaserContext context, Distribution distribution) {
        if (null == this.resolvedTransform && StringUtils.isNotBlank((String)this.transform)) {
            this.transform = Artifacts.resolveForArtifact(this.transform, context, this, distribution);
            this.resolvedTransform = context.getArtifactsDirectory().resolve(Paths.get(this.transform, new String[0])).normalize();
        }
        return this.resolvedTransform;
    }

    public Path getResolvedTransform(JReleaserContext context, Assembler assembler) {
        if (null == this.resolvedTransform && StringUtils.isNotBlank((String)this.transform)) {
            this.transform = Artifacts.resolveForArtifact(this.transform, context, this, assembler);
            this.resolvedTransform = context.getArtifactsDirectory().resolve(Paths.get(this.transform, new String[0])).normalize();
        }
        return this.resolvedTransform;
    }

    public Path getResolvedTransform() {
        return this.resolvedTransform;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
        this.resolvedPath = null;
        this.effectivePath = null;
        this.resolvedTransform = null;
    }

    public String getHash() {
        return this.getHash(Algorithm.SHA_256);
    }

    public void setHash(String hash) {
        this.setHash(Algorithm.SHA_256, hash);
    }

    public String getHash(Algorithm algorithm) {
        return this.hashes.get(algorithm);
    }

    public void setHash(Algorithm algorithm, String hash) {
        if (StringUtils.isNotBlank((String)hash)) {
            this.hashes.put(algorithm, hash.trim());
        }
    }

    public Map<Algorithm, String> getHashes() {
        return Collections.unmodifiableMap(this.hashes);
    }

    void setHashes(Map<Algorithm, String> hashes) {
        this.hashes.clear();
        this.hashes.putAll(hashes);
    }

    public String getPlatform() {
        return this.platform;
    }

    public void setPlatform(String platform) {
        this.platform = platform;
    }

    public String getTransform() {
        return this.transform;
    }

    public void setTransform(String transform) {
        this.transform = transform;
    }

    @Override
    public String getPrefix() {
        return "artifact";
    }

    @Override
    public Map<String, Object> getExtraProperties() {
        return this.extraProperties;
    }

    @Override
    public void setExtraProperties(Map<String, Object> extraProperties) {
        this.extraProperties.clear();
        this.extraProperties.putAll(extraProperties);
    }

    @Override
    public void addExtraProperties(Map<String, Object> extraProperties) {
        this.extraProperties.putAll(extraProperties);
    }

    public void mergeExtraProperties(Map<String, Object> extraProperties) {
        extraProperties.forEach((k, v) -> {
            if (!this.extraProperties.containsKey(k)) {
                this.extraProperties.put((String)k, v);
            }
        });
    }

    @Override
    public Map<String, Object> asMap(boolean full) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("path", this.path);
        map.put("transform", this.transform);
        map.put("platform", this.platform);
        map.put("extraProperties", this.getResolvedExtraProperties());
        return map;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Artifact that = (Artifact)o;
        return this.path.equals(that.path);
    }

    public int hashCode() {
        return Objects.hash(this.path);
    }

    public void merge(Artifact other) {
        if (this == other) {
            return;
        }
        if (StringUtils.isBlank((String)this.platform)) {
            this.platform = other.platform;
        }
        if (StringUtils.isBlank((String)this.transform)) {
            this.transform = other.transform;
        }
        this.mergeExtraProperties(other.extraProperties);
    }

    public Artifact copy() {
        Artifact copy = new Artifact();
        copy.setAll(this);
        return copy;
    }

    public static Set<Artifact> sortArtifacts(Set<Artifact> artifacts) {
        return artifacts.stream().sorted(Artifact.comparatorByPlatform()).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public static Comparator<Artifact> comparatorByPlatform() {
        return (a1, a2) -> {
            String p1 = a1.platform;
            String p2 = a2.platform;
            if (StringUtils.isBlank((String)p1)) {
                p1 = "";
            }
            if (StringUtils.isBlank((String)p2)) {
                p2 = "";
            }
            return p1.compareTo(p2);
        };
    }

    public static Artifact of(Path resolvedPath, String platform, Map<String, Object> props) {
        Artifact artifact = new Artifact();
        artifact.path = resolvedPath.toAbsolutePath().toString();
        artifact.platform = platform;
        artifact.resolvedPath = resolvedPath;
        artifact.effectivePath = resolvedPath;
        artifact.setExtraProperties(props);
        return artifact;
    }

    public static Artifact of(Path resolvedPath, Map<String, Object> props) {
        Artifact artifact = new Artifact();
        artifact.path = resolvedPath.toAbsolutePath().toString();
        artifact.resolvedPath = resolvedPath;
        artifact.effectivePath = resolvedPath;
        artifact.setExtraProperties(props);
        return artifact;
    }

    public static Artifact of(Path resolvedPath) {
        Artifact artifact = new Artifact();
        artifact.path = resolvedPath.toAbsolutePath().toString();
        artifact.resolvedPath = resolvedPath;
        artifact.effectivePath = resolvedPath;
        return artifact;
    }

    public static Artifact of(Path resolvedPath, String platform) {
        Artifact artifact = new Artifact();
        artifact.path = resolvedPath.toAbsolutePath().toString();
        artifact.resolvedPath = resolvedPath;
        artifact.effectivePath = resolvedPath;
        artifact.platform = platform;
        return artifact;
    }
}

