/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.jreleaser.model.AbstractUploader;
import org.jreleaser.model.Activatable;
import org.jreleaser.model.Active;
import org.jreleaser.model.Artifact;
import org.jreleaser.model.Domain;
import org.jreleaser.model.HttpUploader;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.Project;
import org.jreleaser.util.Env;
import org.jreleaser.util.FileType;
import org.jreleaser.util.StringUtils;
import org.jreleaser.util.Templates;

public class Artifactory
extends AbstractUploader {
    public static final String TYPE = "artifactory";
    private final List<ArtifactoryRepository> repositories = new ArrayList<ArtifactoryRepository>();
    private String host;
    private String username;
    private String password;
    private HttpUploader.Authorization authorization;

    public Artifactory() {
        super(TYPE);
    }

    void setAll(Artifactory artifactory) {
        super.setAll(artifactory);
        this.host = artifactory.host;
        this.username = artifactory.username;
        this.password = artifactory.password;
        this.authorization = artifactory.authorization;
        this.setRepositories(artifactory.repositories);
    }

    public HttpUploader.Authorization resolveAuthorization() {
        if (null == this.authorization) {
            this.authorization = HttpUploader.Authorization.BEARER;
        }
        return this.authorization;
    }

    public String getResolvedHost() {
        return Env.resolve((String)("ARTIFACTORY_" + Env.toVar((String)this.name) + "_HOST"), (String)this.host);
    }

    public String getResolvedUsername() {
        return Env.resolve((String)("ARTIFACTORY_" + Env.toVar((String)this.name) + "_USERNAME"), (String)this.username);
    }

    public String getResolvedPassword() {
        return Env.resolve((String)("ARTIFACTORY_" + Env.toVar((String)this.name) + "_PASSWORD"), (String)this.password);
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public HttpUploader.Authorization getAuthorization() {
        return this.authorization;
    }

    public void setAuthorization(HttpUploader.Authorization authorization) {
        this.authorization = authorization;
    }

    public void setAuthorization(String authorization) {
        this.authorization = HttpUploader.Authorization.of(authorization);
    }

    public List<ArtifactoryRepository> getRepositories() {
        return this.repositories;
    }

    public void setRepositories(List<ArtifactoryRepository> repositories) {
        this.repositories.clear();
        this.repositories.addAll(repositories);
    }

    public void addRepository(ArtifactoryRepository repository) {
        if (null != repository) {
            this.repositories.add(repository);
        }
    }

    @Override
    protected void asMap(Map<String, Object> props, boolean full) {
        props.put("authorization", (Object)this.authorization);
        props.put("host", this.getResolvedHost());
        props.put("username", StringUtils.isNotBlank((String)this.getResolvedUsername()) ? "************" : "**unset**");
        props.put("password", StringUtils.isNotBlank((String)this.getResolvedPassword()) ? "************" : "**unset**");
        List repositories = this.repositories.stream().filter(d -> full || d.isEnabled()).map(d -> d.asMap(full)).collect(Collectors.toList());
        if (!repositories.isEmpty()) {
            props.put("repositories", repositories);
        }
    }

    @Override
    public String getResolvedDownloadUrl(JReleaserContext context, Artifact artifact) {
        return this.resolveUrl(context.fullProps(), artifact);
    }

    @Override
    public String getResolvedDownloadUrl(Map<String, Object> props, Artifact artifact) {
        return this.resolveUrl(props, artifact);
    }

    public String getResolvedUploadUrl(JReleaserContext context, Artifact artifact) {
        return this.resolveUrl(context.fullProps(), artifact);
    }

    private String resolveUrl(Map<String, Object> props, Artifact artifact) {
        LinkedHashMap<String, String> p = new LinkedHashMap<String, String>(this.artifactProps((Map)props, artifact));
        p.put("artifactoryHost", this.host);
        Optional<ArtifactoryRepository> repository = this.repositories.stream().filter(r -> r.handles(artifact)).findFirst();
        if (repository.isPresent()) {
            p.put("repositoryPath", repository.get().getPath());
            String url = "{{artifactoryHost}}/{{repositoryPath}}";
            return Templates.resolveTemplate((String)url, p);
        }
        return "";
    }

    public static class ArtifactoryRepository
    implements Domain,
    Activatable {
        private final Set<FileType> fileTypes = new LinkedHashSet<FileType>();
        private Active active;
        private boolean enabled;
        private String path;

        void setAll(ArtifactoryRepository repository) {
            this.active = repository.active;
            this.enabled = repository.enabled;
            this.path = repository.path;
            this.setFileTypes(repository.fileTypes);
        }

        @Override
        public boolean isEnabled() {
            return this.enabled;
        }

        @Override
        public void disable() {
            this.active = Active.NEVER;
            this.enabled = false;
        }

        public boolean resolveEnabled(Project project) {
            if (null == this.active) {
                this.active = Active.RELEASE;
            }
            this.enabled = this.active.check(project);
            return this.enabled;
        }

        @Override
        public Active getActive() {
            return this.active;
        }

        @Override
        public void setActive(Active active) {
            this.active = active;
        }

        @Override
        public void setActive(String str) {
            this.active = Active.of(str);
        }

        @Override
        public boolean isActiveSet() {
            return this.active != null;
        }

        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public Set<FileType> getFileTypes() {
            return this.fileTypes;
        }

        public void setFileTypes(Set<FileType> fileTypes) {
            this.fileTypes.clear();
            this.fileTypes.addAll(fileTypes);
        }

        public void addFileType(FileType fileType) {
            this.fileTypes.add(fileType);
        }

        @Override
        public Map<String, Object> asMap(boolean full) {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            map.put("enabled", this.isEnabled());
            map.put("active", (Object)this.active);
            map.put("path", this.path);
            map.put("fileTypes", this.fileTypes);
            return map;
        }

        public boolean handles(Artifact artifact) {
            if (!this.enabled) {
                return false;
            }
            if (this.fileTypes.isEmpty()) {
                return true;
            }
            String artifactFileName = artifact.getResolvedPath().getFileName().toString();
            String artifactName = StringUtils.getFilename((String)artifactFileName, (Collection)FileType.getSupportedExtensions());
            String archiveFormat = artifactFileName.substring(artifactName.length() + 1);
            FileType fileType = FileType.of((String)archiveFormat);
            return this.fileTypes.contains(fileType);
        }
    }
}

