/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jreleaser.model.AbstractJavaAssembler;
import org.jreleaser.model.Activatable;
import org.jreleaser.model.Active;
import org.jreleaser.model.Archive;
import org.jreleaser.model.Artifact;
import org.jreleaser.model.Distribution;
import org.jreleaser.model.Domain;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.Project;
import org.jreleaser.util.PlatformUtils;
import org.jreleaser.util.StringUtils;
import org.jreleaser.util.Templates;

public class NativeImage
extends AbstractJavaAssembler {
    public static final String TYPE = "native-image";
    private final List<String> args = new ArrayList<String>();
    private final Artifact graal = new Artifact();
    private final Set<Artifact> graalJdks = new LinkedHashSet<Artifact>();
    private final Upx upx = new Upx();
    private final Linux linux = new Linux();
    private final Windows windows = new Windows();
    private final Osx osx = new Osx();
    private String imageName;
    private String imageNameTransform;
    private Archive.Format archiveFormat;

    public NativeImage() {
        super(TYPE);
    }

    @Override
    public Distribution.DistributionType getDistributionType() {
        return Distribution.DistributionType.NATIVE_IMAGE;
    }

    void setAll(NativeImage nativeImage) {
        super.setAll(nativeImage);
        this.imageName = nativeImage.imageName;
        this.imageNameTransform = nativeImage.imageNameTransform;
        this.archiveFormat = nativeImage.archiveFormat;
        this.setGraal(nativeImage.graal);
        this.setGraalJdks(nativeImage.graalJdks);
        this.setArgs(nativeImage.args);
        this.setUpx(nativeImage.upx);
        this.setLinux(nativeImage.linux);
        this.setWindows(nativeImage.windows);
        this.setOsx(nativeImage.osx);
    }

    public String getResolvedImageName(JReleaserContext context) {
        Map<String, Object> props = context.getModel().props();
        props.putAll(this.props());
        return Templates.resolveTemplate((String)this.imageName, props);
    }

    public String getResolvedImageNameTransform(JReleaserContext context) {
        if (StringUtils.isBlank((String)this.imageNameTransform)) {
            return null;
        }
        Map<String, Object> props = context.getModel().props();
        props.putAll(this.props());
        return Templates.resolveTemplate((String)this.imageNameTransform, props);
    }

    public PlatformCustomizer getResolvedPlatformCustomizer() {
        String currentPlatform = PlatformUtils.getCurrentFull();
        if (PlatformUtils.isMac((String)currentPlatform)) {
            return this.getOsx();
        }
        if (PlatformUtils.isWindows((String)currentPlatform)) {
            return this.getWindows();
        }
        return this.getLinux();
    }

    public String getImageName() {
        return this.imageName;
    }

    public void setImageName(String imageName) {
        this.imageName = imageName;
    }

    public String getImageNameTransform() {
        return this.imageNameTransform;
    }

    public void setImageNameTransform(String imageNameTransform) {
        this.imageNameTransform = imageNameTransform;
    }

    public Archive.Format getArchiveFormat() {
        return this.archiveFormat;
    }

    public void setArchiveFormat(Archive.Format archiveFormat) {
        this.archiveFormat = archiveFormat;
    }

    public void setArchiveFormat(String archiveFormat) {
        this.archiveFormat = Archive.Format.of(archiveFormat);
    }

    public Artifact getGraal() {
        return this.graal;
    }

    public void setGraal(Artifact graal) {
        this.graal.setAll(graal);
    }

    public Set<Artifact> getGraalJdks() {
        return Artifact.sortArtifacts(this.graalJdks);
    }

    public void setGraalJdks(Set<Artifact> graalJdks) {
        this.graalJdks.clear();
        this.graalJdks.addAll(graalJdks);
    }

    public void addGraalJdks(Set<Artifact> graalJdks) {
        this.graalJdks.addAll(graalJdks);
    }

    public void addGraalJdk(Artifact jdk) {
        if (null != jdk) {
            this.graalJdks.add(jdk);
        }
    }

    public List<String> getArgs() {
        return this.args;
    }

    public void setArgs(List<String> args) {
        this.args.clear();
        this.args.addAll(args);
    }

    public void addArgs(List<String> args) {
        this.args.addAll(args);
    }

    public void addArg(String arg) {
        if (StringUtils.isNotBlank((String)arg)) {
            this.args.add(arg.trim());
        }
    }

    public void removeArg(String arg) {
        if (StringUtils.isNotBlank((String)arg)) {
            this.args.remove(arg.trim());
        }
    }

    public Upx getUpx() {
        return this.upx;
    }

    public void setUpx(Upx upx) {
        this.upx.setAll(upx);
    }

    public Linux getLinux() {
        return this.linux;
    }

    public void setLinux(Linux linux) {
        this.linux.setAll(linux);
    }

    public Windows getWindows() {
        return this.windows;
    }

    public void setWindows(Windows windows) {
        this.windows.setAll(windows);
    }

    public Osx getOsx() {
        return this.osx;
    }

    public void setOsx(Osx osx) {
        this.osx.setAll(osx);
    }

    @Override
    protected void asMap(boolean full, Map<String, Object> props) {
        super.asMap(full, props);
        props.put("imageName", this.imageName);
        props.put("imageNameTransform", this.imageNameTransform);
        props.put("archiveFormat", (Object)this.archiveFormat);
        LinkedHashMap<String, Map<String, Object>> mappedJdks = new LinkedHashMap<String, Map<String, Object>>();
        int i = 0;
        for (Artifact graalJdk : this.getGraalJdks()) {
            mappedJdks.put("jdk " + i++, graalJdk.asMap(full));
        }
        props.put("graal", this.graal.asMap(full));
        props.put("graalJdks", mappedJdks);
        props.put("args", this.args);
        props.put("upx", this.upx.asMap(full));
        props.putAll(this.linux.asMap(full));
        props.putAll(this.osx.asMap(full));
        props.putAll(this.windows.asMap(full));
    }

    public static class Osx
    extends AbstractPlatformCustomizer {
        public Osx() {
            super("osx");
        }
    }

    public static class Windows
    extends AbstractPlatformCustomizer {
        public Windows() {
            super("windows");
        }
    }

    public static class Linux
    extends AbstractPlatformCustomizer {
        public Linux() {
            super("linux");
        }
    }

    private static abstract class AbstractPlatformCustomizer
    implements PlatformCustomizer {
        private final List<String> args = new ArrayList<String>();
        private final String platform;

        protected AbstractPlatformCustomizer(String platform) {
            this.platform = platform;
        }

        void setAll(AbstractPlatformCustomizer customizer) {
            this.setArgs(customizer.args);
        }

        @Override
        public List<String> getArgs() {
            return this.args;
        }

        @Override
        public void setArgs(List<String> args) {
            this.args.clear();
            this.args.addAll(args);
        }

        @Override
        public void addArgs(List<String> args) {
            this.args.addAll(args);
        }

        @Override
        public String getPlatform() {
            return this.platform;
        }

        @Override
        public Map<String, Object> asMap(boolean full) {
            LinkedHashMap<String, List<String>> props = new LinkedHashMap<String, List<String>>();
            props.put("args", this.args);
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            map.put(this.platform, props);
            return map;
        }
    }

    public static class Upx
    implements Domain,
    Activatable {
        private final List<String> args = new ArrayList<String>();
        @JsonIgnore
        private boolean enabled;
        private Active active;
        private String version;

        void setAll(Upx upx) {
            this.active = upx.active;
            this.enabled = upx.enabled;
            this.version = upx.version;
            this.setArgs(upx.args);
        }

        @Override
        public boolean isEnabled() {
            return this.enabled;
        }

        @Override
        public void disable() {
            this.active = Active.NEVER;
            this.enabled = false;
        }

        public boolean resolveEnabled(Project project) {
            if (null == this.active) {
                this.active = Active.NEVER;
            }
            this.enabled = this.active.check(project);
            return this.enabled;
        }

        @Override
        public Active getActive() {
            return this.active;
        }

        @Override
        public void setActive(Active active) {
            this.active = active;
        }

        @Override
        public void setActive(String str) {
            this.active = Active.of(str);
        }

        @Override
        public boolean isActiveSet() {
            return this.active != null;
        }

        public String getVersion() {
            return this.version;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public List<String> getArgs() {
            return this.args;
        }

        public void setArgs(List<String> args) {
            this.args.clear();
            this.args.addAll(args);
        }

        public void addArgs(List<String> args) {
            this.args.addAll(args);
        }

        public void addArg(String arg) {
            if (StringUtils.isNotBlank((String)arg)) {
                this.args.add(arg.trim());
            }
        }

        @Override
        public Map<String, Object> asMap(boolean full) {
            if (!full && !this.isEnabled()) {
                return Collections.emptyMap();
            }
            LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>();
            props.put("enabled", this.isEnabled());
            props.put("active", (Object)this.active);
            props.put("version", this.version);
            return props;
        }
    }

    public static interface PlatformCustomizer
    extends Domain {
        public String getPlatform();

        public List<String> getArgs();

        public void setArgs(List<String> var1);

        public void addArgs(List<String> var1);
    }
}

