/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.validation;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.Active;
import org.jreleaser.model.Artifact;
import org.jreleaser.model.Distribution;
import org.jreleaser.model.Docker;
import org.jreleaser.model.DockerConfiguration;
import org.jreleaser.model.DockerSpec;
import org.jreleaser.model.GitService;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.JReleaserModel;
import org.jreleaser.model.Project;
import org.jreleaser.model.Registry;
import org.jreleaser.model.TemplatePackager;
import org.jreleaser.model.validation.DistributionsValidator;
import org.jreleaser.model.validation.ExtraPropertiesValidator;
import org.jreleaser.model.validation.TemplateValidator;
import org.jreleaser.model.validation.Validator;
import org.jreleaser.util.Env;
import org.jreleaser.util.Errors;
import org.jreleaser.util.PlatformUtils;
import org.jreleaser.util.StringUtils;

public abstract class DockerValidator
extends Validator {
    public static void validateDocker(JReleaserContext context, Distribution distribution, Docker packager, Errors errors) {
        JReleaserModel model = context.getModel();
        Project project = model.getProject();
        Docker parentPackager = model.getPackagers().getDocker();
        if (!packager.isActiveSet() && parentPackager.isActiveSet()) {
            packager.setActive(parentPackager.getActive());
        }
        if (!packager.resolveEnabled(context.getModel().getProject(), distribution)) {
            return;
        }
        String element = "distribution." + distribution.getName() + ".docker";
        context.getLogger().debug(element);
        List<Artifact> candidateArtifacts = packager.resolveCandidateArtifacts(context, distribution);
        if (candidateArtifacts.size() == 0) {
            packager.setActive(Active.NEVER);
            packager.disable();
            return;
        }
        for (DockerSpec spec : packager.getSpecs().values()) {
            if (!spec.isActiveSet() && packager.isActiveSet()) {
                spec.setActive(packager.getActive());
            }
            spec.resolveEnabled(context.getModel().getProject(), distribution);
        }
        TemplateValidator.validateTemplate(context, distribution, packager, (TemplatePackager)parentPackager, errors);
        DockerValidator.validateCommitAuthor(packager, parentPackager);
        Docker.DockerRepository repository = packager.getRepository();
        repository.resolveEnabled(model.getProject());
        if (!repository.isVersionedSubfoldersSet()) {
            repository.setVersionedSubfolders(parentPackager.getRepository().isVersionedSubfolders());
        }
        if (StringUtils.isBlank((String)repository.getName())) {
            repository.setName(project.getName() + "-docker");
        }
        DockerValidator.validateTap(context, distribution, repository, parentPackager.getRepository(), "docker.repository");
        ExtraPropertiesValidator.mergeExtraProperties(packager, parentPackager);
        DockerValidator.validateContinueOnError(packager, parentPackager);
        if (StringUtils.isBlank((String)packager.getDownloadUrl())) {
            packager.setDownloadUrl(parentPackager.getDownloadUrl());
        }
        if (StringUtils.isBlank((String)packager.getBaseImage())) {
            packager.setBaseImage(parentPackager.getBaseImage());
        }
        DockerValidator.validateBaseImage(distribution, packager);
        if (packager.getImageNames().isEmpty()) {
            packager.setImageNames(parentPackager.getImageNames());
        }
        if (packager.getImageNames().isEmpty()) {
            packager.addImageName("{{repoOwner}}/{{distributionName}}:{{tagName}}");
        }
        if (context.getModel().getProject().isSnapshot()) {
            Optional<String> imageName = packager.getImageNames().stream().filter(n -> n.endsWith(":{{tagName}}") || n.endsWith(":{{ tagName }}")).findFirst();
            packager.setImageNames(Collections.singleton(imageName.orElse("{{repoOwner}}/{{distributionName}}:{{tagName}}")));
        }
        DockerValidator.validateCommands(packager, parentPackager);
        LinkedHashMap<String, String> labels = new LinkedHashMap<String, String>();
        labels.putAll(parentPackager.getLabels());
        labels.putAll(packager.getLabels());
        packager.setLabels(labels);
        if (!packager.getLabels().containsKey("org.opencontainers.image.title")) {
            packager.getLabels().put("org.opencontainers.image.title", "{{distributionName}}");
        }
        DockerValidator.validateLabels(packager);
        DistributionsValidator.validateArtifactPlatforms(context, distribution, packager, candidateArtifacts, errors);
        DockerValidator.validateRegistries(context, packager, parentPackager, errors, element);
        if (!packager.isUseLocalArtifactSet() && parentPackager.isUseLocalArtifactSet()) {
            packager.setUseLocalArtifact(parentPackager.isUseLocalArtifact());
        }
        if (distribution.getType() == Distribution.DistributionType.SINGLE_JAR) {
            packager.setUseLocalArtifact(true);
        }
        for (Map.Entry<String, DockerSpec> e : packager.getSpecs().entrySet()) {
            DockerSpec spec = e.getValue();
            if (StringUtils.isBlank((String)spec.getName())) {
                spec.setName(e.getKey());
            }
            DockerValidator.validateDockerSpec(context, distribution, spec, packager, errors);
        }
    }

    public static void validateDockerSpec(JReleaserContext context, Distribution distribution, DockerSpec spec, Docker docker, Errors errors) {
        if (!spec.isEnabled()) {
            return;
        }
        String element = "distribution." + distribution.getName() + ".docker.spec." + spec.getName();
        context.getLogger().debug(element);
        TemplateValidator.validateTemplate(context, distribution, spec, docker, errors);
        ExtraPropertiesValidator.mergeExtraProperties(spec, docker);
        DockerValidator.validateBaseImage(distribution, spec);
        if (spec.getImageNames().isEmpty()) {
            spec.addImageName("{{repoOwner}}/{{distributionName}}-{{dockerSpecName}}:{{tagName}}");
        }
        if (context.getModel().getProject().isSnapshot()) {
            Optional<String> imageName = spec.getImageNames().stream().filter(n -> n.endsWith(":{{tagName}}") || n.endsWith(":{{ tagName }}")).findFirst();
            spec.setImageNames(Collections.singleton(imageName.orElse("{{repoOwner}}/{{distributionName}}-{{dockerSpecName}}:{{tagName}}")));
        }
        DockerValidator.validateCommands(spec, docker);
        LinkedHashMap<String, String> labels = new LinkedHashMap<String, String>();
        labels.putAll(docker.getLabels());
        labels.putAll(spec.getLabels());
        if (!spec.getLabels().containsKey("org.opencontainers.image.title")) {
            labels.put("org.opencontainers.image.title", docker.getLabels().get("org.opencontainers.image.title") + "-{{dockerSpecName}}");
        }
        spec.setLabels(labels);
        DockerValidator.validateLabels(spec);
        DockerValidator.validateRegistries(context, spec, docker, errors, element);
        long artifactCount = distribution.getArtifacts().stream().filter(Artifact::isActive).count();
        if (artifactCount > 1L && spec.getMatchers().isEmpty()) {
            errors.configuration(RB.$((String)"validation_must_not_be_empty", (Object[])new Object[]{element + ".matchers"}));
        }
        if (!spec.isUseLocalArtifactSet() && docker.isUseLocalArtifactSet()) {
            spec.setUseLocalArtifact(docker.isUseLocalArtifact());
        }
        if (distribution.getType() == Distribution.DistributionType.SINGLE_JAR) {
            spec.setUseLocalArtifact(true);
        }
    }

    private static void validateBaseImage(Distribution distribution, DockerConfiguration docker) {
        if (StringUtils.isBlank((String)docker.getBaseImage())) {
            if (distribution.getType() == Distribution.DistributionType.JAVA_BINARY || distribution.getType() == Distribution.DistributionType.SINGLE_JAR) {
                int version = Integer.parseInt(distribution.getJava().getVersion());
                boolean ltsmts = version == 8 || version % 2 == 1;
                docker.setBaseImage("azul/zulu-openjdk-alpine:{{distributionJavaVersion}}" + (ltsmts ? "-jre" : ""));
            } else if (distribution.getType() == Distribution.DistributionType.JLINK) {
                if (DockerValidator.isAlpineCompatible(distribution, docker)) {
                    docker.setBaseImage("alpine:latest");
                } else {
                    docker.setBaseImage("ubuntu:latest");
                }
            } else {
                docker.setBaseImage("scratch");
            }
        } else if (docker instanceof DockerSpec) {
            DockerSpec spec = (DockerSpec)docker;
            distribution.getArtifacts().stream().filter(artifact -> artifact.getPath().endsWith(".zip")).filter(spec::matches).findFirst().ifPresent(spec::setArtifact);
        }
    }

    private static boolean isAlpineCompatible(Distribution distribution, DockerConfiguration docker) {
        List artifacts = distribution.getArtifacts().stream().filter(artifact -> artifact.getPath().endsWith(".zip")).collect(Collectors.toList());
        if (docker instanceof DockerSpec) {
            DockerSpec spec = (DockerSpec)docker;
            Optional<Artifact> artifact2 = artifacts.stream().filter(spec::matches).findFirst();
            if (artifact2.isPresent()) {
                spec.setArtifact(artifact2.get());
                return PlatformUtils.isAlpineLinux((String)artifact2.get().getPlatform());
            }
            return false;
        }
        return artifacts.stream().anyMatch(artifact -> PlatformUtils.isAlpineLinux((String)artifact.getPlatform()));
    }

    private static void validateCommands(DockerConfiguration self, DockerConfiguration other) {
        if (self.getBuildArgs().isEmpty() && !other.getBuildArgs().isEmpty()) {
            self.setBuildArgs(other.getBuildArgs());
        }
        if (self.getPreCommands().isEmpty() && !other.getPreCommands().isEmpty()) {
            self.setPreCommands(other.getPreCommands());
        }
        if (self.getPostCommands().isEmpty() && !other.getPostCommands().isEmpty()) {
            self.setPostCommands(other.getPostCommands());
        }
    }

    private static void validateLabels(DockerConfiguration self) {
        if (!self.getLabels().containsKey("org.opencontainers.image.description")) {
            self.getLabels().put("org.opencontainers.image.description", "{{projectDescription}}");
        }
        if (!self.getLabels().containsKey("org.opencontainers.image.url")) {
            self.getLabels().put("org.opencontainers.image.url", "{{projectWebsite}}");
        }
        if (!self.getLabels().containsKey("org.opencontainers.image.licenses")) {
            self.getLabels().put("org.opencontainers.image.licenses", "{{projectLicense}}");
        }
        if (!self.getLabels().containsKey("org.opencontainers.image.version")) {
            self.getLabels().put("org.opencontainers.image.version", "{{projectVersion}}");
        }
        if (!self.getLabels().containsKey("org.opencontainers.image.revision")) {
            self.getLabels().put("org.opencontainers.image.revision", "{{commitFullHash}}");
        }
    }

    private static void validateRegistries(JReleaserContext context, DockerConfiguration self, DockerConfiguration other, Errors errors, String element) {
        JReleaserModel model = context.getModel();
        LinkedHashSet<Registry> registries = new LinkedHashSet<Registry>();
        registries.addAll(self.getRegistries());
        registries.addAll(other.getRegistries());
        self.setRegistries(registries);
        if (registries.isEmpty()) {
            context.getLogger().warn(RB.$((String)"validation_docker_no_registries", (Object[])new Object[]{element}));
            return;
        }
        for (Registry registry : registries) {
            GitService service = model.getRelease().getGitService();
            String serverName = registry.getServerName();
            registry.setUsername(DockerValidator.checkProperty(context, "DOCKER_" + Env.toVar((String)serverName) + "_USERNAME", "registry." + Env.toVar((String)serverName) + ".username", registry.getUsername(), service.getResolvedUsername()));
            if (StringUtils.isBlank((String)registry.getRepositoryName())) {
                registry.setRepositoryName(service.getOwner());
            }
            if (StringUtils.isBlank((String)registry.getUsername())) {
                errors.configuration(RB.$((String)"validation_must_not_be_blank", (Object[])new Object[]{element + ".registry." + serverName + ".username"}));
            }
            registry.setPassword(DockerValidator.checkProperty(context, "DOCKER_" + Env.toVar((String)serverName) + "_PASSWORD", "registry." + Env.toVar((String)serverName) + ".password", registry.getPassword(), errors, context.isDryrun()));
        }
    }
}

