/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.validation;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.Active;
import org.jreleaser.model.Artifact;
import org.jreleaser.model.FileSet;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.Jlink;
import org.jreleaser.model.Platform;
import org.jreleaser.model.Project;
import org.jreleaser.model.validation.TemplateValidator;
import org.jreleaser.model.validation.Validator;
import org.jreleaser.util.Errors;
import org.jreleaser.util.PlatformUtils;
import org.jreleaser.util.StringUtils;

public abstract class JlinkValidator
extends Validator {
    public static void validateJlink(JReleaserContext context, JReleaserContext.Mode mode, Errors errors) {
        context.getLogger().debug("jlink");
        Map<String, Jlink> jlink = context.getModel().getAssemble().getJlink();
        for (Map.Entry<String, Jlink> e : jlink.entrySet()) {
            e.getValue().setName(e.getKey());
            JlinkValidator.validateJlink(context, mode, e.getValue(), errors);
        }
    }

    private static void validateJlink(JReleaserContext context, JReleaserContext.Mode mode, Jlink jlink, Errors errors) {
        context.getLogger().debug("jlink.{}", new Object[]{jlink.getName()});
        if (!jlink.isActiveSet()) {
            jlink.setActive(Active.NEVER);
        }
        if (!jlink.resolveEnabled(context.getModel().getProject())) {
            return;
        }
        if (StringUtils.isBlank((String)jlink.getName())) {
            errors.configuration(RB.$((String)"validation_must_not_be_blank", (Object[])new Object[]{"jlink.name"}));
            return;
        }
        context.getLogger().debug("jlink.{}.java", new Object[]{jlink.getName()});
        if (!JlinkValidator.validateJava(context, jlink, errors)) {
            return;
        }
        Platform platform = jlink.getPlatform().merge(context.getModel().getPlatform());
        jlink.setPlatform(platform);
        if (StringUtils.isBlank((String)jlink.getImageName())) {
            jlink.setImageName(jlink.getJava().getGroupId() + "." + jlink.getJava().getArtifactId() + "-" + context.getModel().getProject().getResolvedVersion());
        }
        if (StringUtils.isBlank((String)jlink.getExecutable())) {
            jlink.setExecutable(jlink.getName());
        }
        int i = 0;
        for (Artifact targetJdk : jlink.getTargetJdks()) {
            JlinkValidator.validateJdk(context, mode, jlink, targetJdk, i++, errors);
        }
        Map<String, List<Artifact>> byPlatform = jlink.getTargetJdks().stream().collect(Collectors.groupingBy(jdk -> StringUtils.isBlank((String)jdk.getPlatform()) ? "<nil>" : jdk.getPlatform()));
        if (byPlatform.containsKey("<nil>")) {
            errors.configuration(RB.$((String)"validation_jlink_jdk_platform", (Object[])new Object[]{jlink.getName()}));
        }
        byPlatform.forEach((p, jdks) -> {
            if (jdks.size() > 1) {
                errors.configuration(RB.$((String)"validation_jlink_jdk_multiple_platforms", (Object[])new Object[]{jlink.getName(), p}));
            }
        });
        if (StringUtils.isBlank((String)jlink.getJdk().getPath())) {
            String currentPlatform = PlatformUtils.getCurrentFull();
            String javaHome = System.getProperty("java.home");
            if (jlink.getTargetJdks().isEmpty()) {
                if (StringUtils.isBlank((String)javaHome)) {
                    errors.configuration(RB.$((String)"validation_java_home_missing", (Object[])new Object[0]));
                    return;
                }
                jlink.getJdk().setPath(javaHome);
                jlink.getJdk().setPlatform(currentPlatform);
                jlink.addTargetJdk(jlink.getJdk());
            } else {
                Optional<Artifact> jdk2 = jlink.getTargetJdks().stream().filter(j -> PlatformUtils.isCompatible((String)currentPlatform, (String)j.getPlatform())).findFirst();
                if (jdk2.isPresent()) {
                    jlink.setJdk(jdk2.get());
                } else {
                    if (StringUtils.isBlank((String)javaHome)) {
                        errors.configuration(RB.$((String)"validation_java_home_missing", (Object[])new Object[0]));
                        return;
                    }
                    jlink.getJdk().setPath(javaHome);
                    jlink.getJdk().setPlatform(currentPlatform);
                }
            }
        }
        if (jlink.getArgs().isEmpty()) {
            jlink.getArgs().add("--no-header-files");
            jlink.getArgs().add("--no-man-pages");
            jlink.getArgs().add("--compress=2");
            jlink.getArgs().add("--strip-debug");
        }
        if (null == jlink.getMainJar()) {
            errors.configuration(RB.$((String)"validation_is_null", (Object[])new Object[]{"jlink." + jlink.getName() + ".mainJar"}));
            return;
        }
        if (StringUtils.isBlank((String)jlink.getMainJar().getPath())) {
            errors.configuration(RB.$((String)"validation_must_not_be_null", (Object[])new Object[]{"jlink." + jlink.getName() + ".mainJar.path"}));
        }
        JlinkValidator.validateGlobs(context, jlink.getJars(), "jlink." + jlink.getName() + ".jars", errors);
        if (mode == JReleaserContext.Mode.ASSEMBLE) {
            TemplateValidator.validateTemplate(context, jlink, errors);
        }
        if (!jlink.getFileSets().isEmpty()) {
            i = 0;
            for (FileSet fileSet : jlink.getFileSets()) {
                JlinkValidator.validateFileSet(context, mode, jlink, fileSet, i++, errors);
            }
        }
    }

    private static boolean validateJava(JReleaserContext context, Jlink jlink, Errors errors) {
        Project project = context.getModel().getProject();
        if (!jlink.getJava().isEnabledSet() && project.getJava().isEnabledSet()) {
            jlink.getJava().setEnabled(project.getJava().isEnabled());
        }
        if (!jlink.getJava().isEnabledSet()) {
            jlink.getJava().setEnabled(jlink.getJava().isSet());
        }
        if (!jlink.getJava().isEnabled()) {
            return true;
        }
        if (StringUtils.isBlank((String)jlink.getJava().getArtifactId())) {
            jlink.getJava().setArtifactId(project.getJava().getArtifactId());
        }
        if (StringUtils.isBlank((String)jlink.getJava().getGroupId())) {
            jlink.getJava().setGroupId(project.getJava().getGroupId());
        }
        if (StringUtils.isBlank((String)jlink.getJava().getVersion())) {
            jlink.getJava().setVersion(project.getJava().getVersion());
        }
        if (StringUtils.isBlank((String)jlink.getJava().getMainModule())) {
            jlink.getJava().setMainModule(project.getJava().getMainModule());
        }
        if (StringUtils.isBlank((String)jlink.getJava().getMainClass())) {
            jlink.getJava().setMainClass(project.getJava().getMainClass());
        }
        if (StringUtils.isBlank((String)jlink.getJava().getGroupId())) {
            errors.configuration(RB.$((String)"validation_must_not_be_blank", (Object[])new Object[]{"jlink." + jlink.getName() + ".java.groupId"}));
        }
        return true;
    }

    private static void validateJdk(JReleaserContext context, JReleaserContext.Mode mode, Jlink jlink, Artifact jdk, int index, Errors errors) {
        if (mode == JReleaserContext.Mode.FULL) {
            return;
        }
        if (null == jdk) {
            errors.configuration(RB.$((String)"validation_is_null", (Object[])new Object[]{"jlink." + jlink.getName() + ".targetJdk[" + index + "]"}));
            return;
        }
        if (StringUtils.isBlank((String)jdk.getPath())) {
            errors.configuration(RB.$((String)"validation_must_not_be_null", (Object[])new Object[]{"jlink." + jlink.getName() + ".targetJdk[" + index + "].path"}));
        }
        if (StringUtils.isNotBlank((String)jdk.getPlatform()) && !PlatformUtils.isSupported((String)jdk.getPlatform().trim())) {
            context.getLogger().warn(RB.$((String)"validation_jlink_platform", (Object[])new Object[]{jlink.getName(), index, jdk.getPlatform(), System.lineSeparator(), PlatformUtils.getSupportedOsNames(), System.lineSeparator(), PlatformUtils.getSupportedOsArchs()}));
        }
    }
}

