/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.validation;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.Active;
import org.jreleaser.model.Artifact;
import org.jreleaser.model.Distribution;
import org.jreleaser.model.GitService;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.JReleaserModel;
import org.jreleaser.model.Sdkman;
import org.jreleaser.model.validation.DistributionsValidator;
import org.jreleaser.model.validation.ExtraPropertiesValidator;
import org.jreleaser.model.validation.Validator;
import org.jreleaser.util.Errors;
import org.jreleaser.util.StringUtils;

public abstract class SdkmanValidator
extends Validator {
    public static void validateSdkman(JReleaserContext context, Distribution distribution, Sdkman packager, Errors errors) {
        JReleaserModel model = context.getModel();
        Sdkman parentPackager = model.getPackagers().getSdkman();
        boolean packagerSet = packager.isActiveSet();
        boolean parentPackagerSet = parentPackager.isActiveSet();
        packager.getExtraProperties().put("__MAGIC_SET__", packagerSet || parentPackagerSet);
        if (!packager.isActiveSet() && parentPackager.isActiveSet()) {
            packager.setActive(parentPackager.getActive());
        }
        if (!packager.resolveEnabled(context.getModel().getProject(), distribution)) {
            return;
        }
        GitService service = model.getRelease().getGitService();
        if (!service.isReleaseSupported()) {
            packager.disable();
            return;
        }
        context.getLogger().debug("distribution.{}.sdkman", new Object[]{distribution.getName()});
        List<Artifact> candidateArtifacts = packager.resolveCandidateArtifacts(context, distribution);
        if (candidateArtifacts.size() == 0) {
            packager.setActive(Active.NEVER);
            packager.disable();
            return;
        }
        ExtraPropertiesValidator.mergeExtraProperties(packager, parentPackager);
        SdkmanValidator.validateContinueOnError(packager, parentPackager);
        if (StringUtils.isBlank((String)packager.getDownloadUrl())) {
            packager.setDownloadUrl(parentPackager.getDownloadUrl());
        }
        if (null == packager.getCommand()) {
            packager.setCommand(parentPackager.getCommand());
            if (null == packager.getCommand()) {
                packager.setCommand(Sdkman.Command.MAJOR);
            }
        }
        if (StringUtils.isBlank((String)packager.getCandidate())) {
            packager.setCandidate(parentPackager.getCandidate());
            if (StringUtils.isBlank((String)packager.getCandidate())) {
                packager.setCandidate(distribution.getName());
            }
        }
        if (StringUtils.isBlank((String)packager.getReleaseNotesUrl())) {
            packager.setReleaseNotesUrl(parentPackager.getReleaseNotesUrl());
            if (StringUtils.isBlank((String)packager.getReleaseNotesUrl())) {
                packager.setReleaseNotesUrl(service.getReleaseNotesUrl());
            }
        }
        if (StringUtils.isBlank((String)packager.getConsumerKey())) {
            packager.setConsumerKey(parentPackager.getConsumerKey());
        }
        if (StringUtils.isBlank((String)packager.getConsumerToken())) {
            packager.setConsumerToken(parentPackager.getConsumerToken());
        }
        packager.setConsumerKey(SdkmanValidator.checkProperty(context, "SDKMAN_CONSUMER_KEY", "sdkman.consumerKey", packager.getConsumerKey(), errors, context.isDryrun()));
        packager.setConsumerToken(SdkmanValidator.checkProperty(context, "SDKMAN_CONSUMER_TOKEN", "sdkman.consumerToken", packager.getConsumerToken(), errors, context.isDryrun()));
        SdkmanValidator.validateTimeout(packager);
        DistributionsValidator.validateArtifactPlatforms(context, distribution, packager, candidateArtifacts, errors);
    }

    public static void postValidateSdkman(JReleaserContext context, Errors errors) {
        Map<String, List<Distribution>> map = context.getModel().getActiveDistributions().stream().peek(distribution -> {
            boolean set;
            if (distribution.getSdkman().getExtraProperties().containsKey("__MAGIC_SET__") && (set = ((Boolean)distribution.getSdkman().getExtraProperties().remove("__MAGIC_SET__")).booleanValue())) {
                context.getModel().getAnnounce().getSdkman().getExtraProperties().put("__MAGIC_SET__", set);
            }
        }).filter(d -> d.getSdkman().isEnabled()).collect(Collectors.groupingBy(d -> d.getSdkman().getCandidate()));
        map.forEach((candidate, distributions) -> {
            if (distributions.size() > 1) {
                errors.configuration(RB.$((String)"validation_sdkman_multiple_definition", (Object[])new Object[]{candidate, distributions.stream().map(Distribution::getName).collect(Collectors.joining(", "))}));
            }
        });
    }
}

