/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.validation;

import java.util.Collections;
import java.util.List;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.Active;
import org.jreleaser.model.Artifact;
import org.jreleaser.model.Distribution;
import org.jreleaser.model.GitService;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.JReleaserModel;
import org.jreleaser.model.Spec;
import org.jreleaser.model.validation.DistributionsValidator;
import org.jreleaser.model.validation.ExtraPropertiesValidator;
import org.jreleaser.model.validation.TemplateValidator;
import org.jreleaser.model.validation.Validator;
import org.jreleaser.util.Errors;
import org.jreleaser.util.StringUtils;

public abstract class SpecValidator
extends Validator {
    public static void validateSpec(JReleaserContext context, Distribution distribution, Spec packager, Errors errors) {
        JReleaserModel model = context.getModel();
        Spec parentPackager = model.getPackagers().getSpec();
        if (!packager.isActiveSet() && parentPackager.isActiveSet()) {
            packager.setActive(parentPackager.getActive());
        }
        if (!packager.resolveEnabled(context.getModel().getProject(), distribution)) {
            packager.disable();
            return;
        }
        GitService service = model.getRelease().getGitService();
        if (!service.isReleaseSupported()) {
            packager.disable();
            return;
        }
        context.getLogger().debug("distribution.{}.spec", new Object[]{distribution.getName()});
        List<Artifact> candidateArtifacts = packager.resolveCandidateArtifacts(context, distribution);
        if (candidateArtifacts.size() == 0) {
            packager.setActive(Active.NEVER);
            packager.disable();
            return;
        }
        if (candidateArtifacts.size() > 1) {
            errors.configuration(RB.$((String)"validation_packager_multiple_artifacts", (Object[])new Object[]{"distribution." + distribution.getName() + ".spec"}));
            packager.disable();
            return;
        }
        if (StringUtils.isBlank((String)packager.getRelease())) {
            packager.setRelease(parentPackager.getRelease());
        }
        if (StringUtils.isBlank((String)packager.getRelease())) {
            packager.setRelease("1");
        }
        try {
            Integer.parseInt(packager.getRelease());
            packager.setRelease(packager.getRelease() + "%{?dist}");
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (packager.getRequires().isEmpty()) {
            packager.setRequires(parentPackager.getRequires());
        }
        if (packager.getRequires().isEmpty()) {
            packager.setRequires(Collections.singletonList("java"));
        }
        SpecValidator.validateCommitAuthor(packager, parentPackager);
        Spec.SpecRepository repository = packager.getRepository();
        repository.resolveEnabled(model.getProject());
        SpecValidator.validateTap(context, distribution, repository, parentPackager.getRepository(), "spec.repository");
        TemplateValidator.validateTemplate(context, distribution, packager, parentPackager, errors);
        ExtraPropertiesValidator.mergeExtraProperties(packager, parentPackager);
        SpecValidator.validateContinueOnError(packager, parentPackager);
        if (StringUtils.isBlank((String)packager.getDownloadUrl())) {
            packager.setDownloadUrl(parentPackager.getDownloadUrl());
        }
        DistributionsValidator.validateArtifactPlatforms(context, distribution, packager, candidateArtifacts, errors);
        if (StringUtils.isBlank((String)packager.getPackageName())) {
            packager.setPackageName(parentPackager.getPackageName());
            if (StringUtils.isBlank((String)packager.getPackageName())) {
                packager.setPackageName(distribution.getName());
            }
        }
    }
}

