/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.HttpURLConnection;

public abstract class AbuseLimitHandler {
    public static final AbuseLimitHandler WAIT = new AbuseLimitHandler(){

        @Override
        public void onError(IOException e, HttpURLConnection uc) throws IOException {
            try {
                Thread.sleep(this.parseWaitTime(uc));
            }
            catch (InterruptedException ex) {
                throw (InterruptedIOException)new InterruptedIOException().initCause(e);
            }
        }

        private long parseWaitTime(HttpURLConnection uc) {
            String v = uc.getHeaderField("Retry-After");
            if (v == null) {
                return 60000L;
            }
            return Math.max(1000L, Long.parseLong(v) * 1000L);
        }
    };
    public static final AbuseLimitHandler FAIL = new AbuseLimitHandler(){

        @Override
        public void onError(IOException e, HttpURLConnection uc) throws IOException {
            throw (IOException)new IOException("Abuse limit reached").initCause(e);
        }
    };

    public abstract void onError(IOException var1, HttpURLConnection var2) throws IOException;
}

