/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.cli.internal;

import java.io.PrintWriter;
import org.jreleaser.cli.internal.Colorizer;
import org.jreleaser.util.AbstractJReleaserLogger;
import org.slf4j.helpers.MessageFormatter;
import picocli.CommandLine;

public class ColorizedJReleaserLoggerAdapter
extends AbstractJReleaserLogger {
    private final PrintWriter out;
    private final Level level;

    public ColorizedJReleaserLoggerAdapter(PrintWriter tracer, PrintWriter out) {
        this(tracer, out, Level.WARN);
    }

    public ColorizedJReleaserLoggerAdapter(PrintWriter tracer, PrintWriter out, Level level) {
        super(tracer);
        this.out = out;
        this.level = level;
    }

    public void debug(String message) {
        String msg = this.formatMessage(message);
        if (this.isLevelEnabled(Level.DEBUG)) {
            this.out.println((Object)((Object)Level.DEBUG) + msg);
        }
        this.trace(Level.DEBUG.asString() + msg);
    }

    public void info(String message) {
        String msg = this.formatMessage(message);
        if (this.isLevelEnabled(Level.INFO)) {
            this.out.println((Object)((Object)Level.INFO) + msg);
        }
        this.trace(Level.INFO.asString() + msg);
    }

    public void warn(String message) {
        String msg = this.formatMessage(message);
        if (this.isLevelEnabled(Level.WARN)) {
            this.out.println((Object)((Object)Level.WARN) + msg);
        }
        this.trace(Level.WARN.asString() + msg);
    }

    public void error(String message) {
        String msg = this.formatMessage(message);
        if (this.isLevelEnabled(Level.ERROR)) {
            this.out.println((Object)((Object)Level.ERROR) + msg);
        }
        this.trace(Level.ERROR.asString() + msg);
    }

    public void debug(String message, Object ... args) {
        String msg = this.formatMessage(MessageFormatter.arrayFormat((String)message, (Object[])args).getMessage());
        if (this.isLevelEnabled(Level.DEBUG)) {
            this.out.println((Object)((Object)Level.DEBUG) + msg);
        }
        this.trace(Level.DEBUG.asString() + msg);
    }

    public void info(String message, Object ... args) {
        String msg = this.formatMessage(MessageFormatter.arrayFormat((String)message, (Object[])args).getMessage());
        if (this.isLevelEnabled(Level.INFO)) {
            this.out.println((Object)((Object)Level.INFO) + msg);
        }
        this.trace(Level.INFO.asString() + msg);
    }

    public void warn(String message, Object ... args) {
        String msg = this.formatMessage(MessageFormatter.arrayFormat((String)message, (Object[])args).getMessage());
        if (this.isLevelEnabled(Level.WARN)) {
            this.out.println((Object)((Object)Level.WARN) + msg);
        }
        this.trace(Level.WARN.asString() + msg);
    }

    public void error(String message, Object ... args) {
        String msg = this.formatMessage(MessageFormatter.arrayFormat((String)message, (Object[])args).getMessage());
        if (this.isLevelEnabled(Level.ERROR)) {
            this.out.println((Object)((Object)Level.ERROR) + msg);
        }
        this.trace(Level.ERROR.asString() + msg);
    }

    public void debug(String message, Throwable throwable) {
        String msg = this.formatMessage(message);
        if (this.isLevelEnabled(Level.DEBUG)) {
            this.out.println((Object)((Object)Level.DEBUG) + msg);
            this.printThrowable(throwable);
        }
        this.trace(Level.DEBUG.asString() + msg, throwable);
    }

    public void info(String message, Throwable throwable) {
        String msg = this.formatMessage(message);
        if (this.isLevelEnabled(Level.INFO)) {
            this.out.println((Object)((Object)Level.INFO) + msg);
            this.printThrowable(throwable);
        }
        this.trace(Level.INFO.asString() + msg, throwable);
    }

    public void warn(String message, Throwable throwable) {
        String msg = this.formatMessage(message);
        if (this.isLevelEnabled(Level.WARN)) {
            this.out.println((Object)((Object)Level.WARN) + msg);
            this.printThrowable(throwable);
        }
        this.trace(Level.WARN.asString() + msg, throwable);
    }

    public void error(String message, Throwable throwable) {
        String msg = this.formatMessage(message);
        if (this.isLevelEnabled(Level.ERROR)) {
            this.out.println((Object)((Object)Level.ERROR) + msg);
            this.printThrowable(throwable);
        }
        this.trace(Level.ERROR.asString() + msg, throwable);
    }

    private void printThrowable(Throwable throwable) {
        if (null != throwable) {
            throwable.printStackTrace(new Colorizer(this.out));
        }
    }

    private boolean isLevelEnabled(Level requested) {
        return requested.ordinal() >= this.level.ordinal();
    }

    public static enum Level {
        DEBUG("cyan"),
        INFO("blue"),
        WARN("yellow"),
        ERROR("red");

        private final String color;

        private Level(String color) {
            this.color = color;
        }

        public String toString() {
            return "[" + this.colorize(this.name()) + "] " + (this.name().length() == 4 ? " " : "");
        }

        public String asString() {
            return "[" + this.name() + "] " + (this.name().length() == 4 ? " " : "");
        }

        private String colorize(String input) {
            return CommandLine.Help.Ansi.AUTO.string("@|" + this.color + " " + input + "|@");
        }
    }
}

