/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.validation.announce;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.Collection;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.announce.OpenCollectiveAnnouncer;
import org.jreleaser.model.internal.common.Activatable;
import org.jreleaser.model.internal.validation.common.Validator;
import org.jreleaser.util.CollectionUtils;
import org.jreleaser.util.Errors;
import org.jreleaser.util.StringUtils;

public final class OpenCollectiveAnnouncerValidator {
    private static final String DEFAULT_OPENCOLLECTIVE_TPL = "src/jreleaser/templates/opencollective.tpl";

    private OpenCollectiveAnnouncerValidator() {
    }

    public static void validateOpenCollective(JReleaserContext context, OpenCollectiveAnnouncer announcer, Errors errors) {
        context.getLogger().debug("announce.openCollective");
        Validator.resolveActivatable(context, (Activatable)announcer, "announce.openCollective", "NEVER");
        if (!announcer.resolveEnabledWithSnapshot(context.getModel().getProject())) {
            context.getLogger().debug(RB.$((String)"validation.disabled", (Object[])new Object[0]));
            return;
        }
        if (StringUtils.isBlank((String)announcer.getHost())) {
            announcer.setHost("https://api.opencollective.com/graphql/v2");
        }
        announcer.setToken(Validator.checkProperty(context, (Collection<String>)CollectionUtils.listOf((Object[])new String[]{"announce.openCollective.token", "OPENCOLLECTIVE_TOKEN"}), "announce.openCollective.token", announcer.getToken(), errors, context.isDryrun()));
        announcer.setSlug(Validator.checkProperty(context, (Collection<String>)CollectionUtils.listOf((Object[])new String[]{"announce.openCollective.slug", "OPENCOLLECTIVE_SLUG"}), "announce.openCollective.slug", announcer.getSlug(), context.getModel().getProject().getResolvedName()));
        if (StringUtils.isBlank((String)announcer.getTitle())) {
            announcer.setTitle(RB.$((String)"default.discussion.title", (Object[])new Object[0]));
        }
        if (StringUtils.isBlank((String)announcer.getMessage()) && StringUtils.isBlank((String)announcer.getMessageTemplate())) {
            if (Files.exists(context.getBasedir().resolve(DEFAULT_OPENCOLLECTIVE_TPL), new LinkOption[0])) {
                announcer.setMessageTemplate(DEFAULT_OPENCOLLECTIVE_TPL);
            } else {
                announcer.setMessage(RB.$((String)"default.release.message.html", (Object[])new Object[0]));
            }
        }
        if (StringUtils.isNotBlank((String)announcer.getMessageTemplate()) && !Files.exists(context.getBasedir().resolve(announcer.getMessageTemplate().trim()), new LinkOption[0])) {
            errors.configuration(RB.$((String)"validation_directory_not_exist", (Object[])new Object[]{"openCollective.messageTemplate", announcer.getMessageTemplate()}));
        }
        Validator.validateTimeout(announcer);
    }
}

