/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.validation.announce;

import java.util.Collection;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.Active;
import org.jreleaser.model.Sdkman;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.announce.SdkmanAnnouncer;
import org.jreleaser.model.internal.packagers.SdkmanPackager;
import org.jreleaser.model.internal.validation.common.Validator;
import org.jreleaser.util.CollectionUtils;
import org.jreleaser.util.Errors;
import org.jreleaser.util.StringUtils;

public final class SdkmanAnnouncerValidator {
    private SdkmanAnnouncerValidator() {
    }

    public static void validateSdkmanAnnouncer(JReleaserContext context, SdkmanAnnouncer announcer, Errors errors) {
        context.getLogger().debug("announce.sdkman");
        context.getModel().getActiveDistributions().stream().filter(d -> d.getSdkman().isEnabled()).findFirst().ifPresent(distribution -> announcer.setActive(Active.ALWAYS));
        if (!announcer.resolveEnabledWithSnapshot(context.getModel().getProject())) {
            context.getLogger().debug(RB.$((String)"validation.disabled", (Object[])new Object[0]));
            return;
        }
        if (!context.getModel().getRelease().getReleaser().isReleaseSupported()) {
            context.getLogger().debug(RB.$((String)"validation.disabled.release", (Object[])new Object[0]));
            announcer.disable();
            return;
        }
        Boolean set = (Boolean)announcer.getExtraProperties().get("__MAGIC_SET__");
        if (null != set && set.booleanValue()) {
            context.getLogger().debug(RB.$((String)"validation.disabled", (Object[])new Object[0]));
            announcer.disable();
            return;
        }
        announcer.setConsumerKey(Validator.checkProperty(context, (Collection<String>)CollectionUtils.listOf((Object[])new String[]{"announce.sdkman.consumer.key", "SDKMAN_CONSUMER_KEY"}), "announce.sdkman.consumerKey", announcer.getConsumerKey(), errors, context.isDryrun()));
        announcer.setConsumerToken(Validator.checkProperty(context, (Collection<String>)CollectionUtils.listOf((Object[])new String[]{"announce.sdkman.consumer.token", "SDKMAN_CONSUMER_TOKEN"}), "announce.sdkman.consumerToken", announcer.getConsumerToken(), errors, context.isDryrun()));
        SdkmanPackager sdkmanPackager = context.getModel().getPackagers().getSdkman();
        if (StringUtils.isBlank((String)announcer.getConsumerKey()) && sdkmanPackager.isEnabled()) {
            announcer.setConsumerKey(sdkmanPackager.getConsumerKey());
        }
        if (StringUtils.isBlank((String)announcer.getConsumerToken()) && sdkmanPackager.isEnabled()) {
            announcer.setConsumerToken(sdkmanPackager.getConsumerToken());
        }
        if (StringUtils.isBlank((String)announcer.getReleaseNotesUrl())) {
            announcer.setReleaseNotesUrl(context.getModel().getRelease().getReleaser().getReleaseNotesUrl());
        }
        if (context.getModel().getActiveDistributions().isEmpty()) {
            errors.warning(RB.$((String)"validation_skdman_disable", (Object[])new Object[0]));
            announcer.disable();
        }
        if (null == announcer.getCommand()) {
            announcer.setCommand(Sdkman.Command.MAJOR);
        }
        Validator.validateTimeout(announcer);
    }
}

