/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.validation.packagers;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.JReleaserModel;
import org.jreleaser.model.internal.common.Activatable;
import org.jreleaser.model.internal.distributions.Distribution;
import org.jreleaser.model.internal.packagers.JbangPackager;
import org.jreleaser.model.internal.release.BaseReleaser;
import org.jreleaser.model.internal.validation.common.ExtraPropertiesValidator;
import org.jreleaser.model.internal.validation.common.TemplateValidator;
import org.jreleaser.model.internal.validation.common.Validator;
import org.jreleaser.util.Errors;
import org.jreleaser.util.StringUtils;

public final class JbangPackagerValidator {
    private JbangPackagerValidator() {
    }

    public static void validateJbang(JReleaserContext context, Distribution distribution, JbangPackager packager, Errors errors) {
        context.getLogger().debug("distribution.{}." + packager.getType(), new Object[]{distribution.getName()});
        JReleaserModel model = context.getModel();
        JbangPackager parentPackager = model.getPackagers().getJbang();
        Validator.resolveActivatable(context, (Activatable)packager, "distributions." + distribution.getName() + "." + packager.getType(), parentPackager);
        if (!packager.resolveEnabled(context.getModel().getProject(), distribution)) {
            context.getLogger().debug(RB.$((String)"validation.disabled", (Object[])new Object[0]));
            return;
        }
        BaseReleaser<?, ?> service = model.getRelease().getReleaser();
        if (!service.isReleaseSupported()) {
            context.getLogger().debug(RB.$((String)"validation.disabled.release", (Object[])new Object[0]));
            packager.disable();
            return;
        }
        Validator.validateCommitAuthor(packager, parentPackager);
        JbangPackager.JbangRepository catalog = packager.getCatalog();
        Validator.validateTap(context, distribution, catalog, parentPackager.getCatalog(), "jbang.catalog", "ALWAYS");
        TemplateValidator.validateTemplate(context, distribution, packager, parentPackager, errors);
        ExtraPropertiesValidator.mergeExtraProperties(packager, parentPackager);
        Validator.validateContinueOnError(packager, parentPackager);
        if (StringUtils.isBlank((String)packager.getDownloadUrl())) {
            packager.setDownloadUrl(parentPackager.getDownloadUrl());
        }
        if (StringUtils.isBlank((String)packager.getAlias())) {
            packager.setAlias(distribution.getExecutable().getName());
        }
        if (model.getProject().getExtraProperties().containsKey("reverseRepoHost") && !parentPackager.getExtraProperties().containsKey("reverseRepoHost")) {
            parentPackager.getExtraProperties().put("reverseRepoHost", model.getProject().getExtraProperties().get("reverseRepoHost"));
        }
        if (parentPackager.getExtraProperties().containsKey("reverseRepoHost") && !distribution.getExtraProperties().containsKey("reverseRepoHost")) {
            distribution.getExtraProperties().put("reverseRepoHost", parentPackager.getExtraProperties().get("reverseRepoHost"));
        }
        if (distribution.getExtraProperties().containsKey("reverseRepoHost") && !packager.getExtraProperties().containsKey("reverseRepoHost")) {
            packager.getExtraProperties().put("reverseRepoHost", distribution.getExtraProperties().get("reverseRepoHost"));
        }
        if (StringUtils.isBlank((String)service.getReverseRepoHost()) && !packager.getExtraProperties().containsKey("reverseRepoHost")) {
            errors.configuration(RB.$((String)"validation_jbang_reverse_host", (Object[])new Object[]{distribution.getName(), "reverseRepoHost"}));
        }
        if (StringUtils.isBlank((String)distribution.getJava().getMainClass())) {
            errors.configuration(RB.$((String)"validation_must_not_be_blank", (Object[])new Object[]{"distribution." + distribution.getName() + ".java.mainClass"}));
        }
    }

    public static void postValidateJBang(JReleaserContext context, Errors errors) {
        Map<String, List<Distribution>> map = context.getModel().getActiveDistributions().stream().filter(d -> d.getJbang().isEnabled()).collect(Collectors.groupingBy(d -> d.getJbang().getAlias()));
        map.forEach((alias, distributions) -> {
            if (distributions.size() > 1) {
                errors.configuration(RB.$((String)"validation_jbang_multiple_definition", (Object[])new Object[]{alias, distributions.stream().map(Distribution::getName).collect(Collectors.joining(", "))}));
            }
        });
    }
}

