/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.light;

import java.util.List;
import java.util.Objects;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.lang.Language;
import org.jetbrains.kotlin.com.intellij.lang.java.JavaLanguage;
import org.jetbrains.kotlin.com.intellij.navigation.ItemPresentation;
import org.jetbrains.kotlin.com.intellij.navigation.ItemPresentationProviders;
import org.jetbrains.kotlin.com.intellij.openapi.util.Computable;
import org.jetbrains.kotlin.com.intellij.psi.HierarchicalMethodSignature;
import org.jetbrains.kotlin.com.intellij.psi.JavaElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.JavaPsiFacade;
import org.jetbrains.kotlin.com.intellij.psi.OriginInfoAwareElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiClassType;
import org.jetbrains.kotlin.com.intellij.psi.PsiCodeBlock;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiEllipsisType;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiIdentifier;
import org.jetbrains.kotlin.com.intellij.psi.PsiManager;
import org.jetbrains.kotlin.com.intellij.psi.PsiMethod;
import org.jetbrains.kotlin.com.intellij.psi.PsiModifierList;
import org.jetbrains.kotlin.com.intellij.psi.PsiParameter;
import org.jetbrains.kotlin.com.intellij.psi.PsiParameterList;
import org.jetbrains.kotlin.com.intellij.psi.PsiReferenceList;
import org.jetbrains.kotlin.com.intellij.psi.PsiSubstitutor;
import org.jetbrains.kotlin.com.intellij.psi.PsiType;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeParameter;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeParameterList;
import org.jetbrains.kotlin.com.intellij.psi.impl.ElementPresentationUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiClassImplUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiImplUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiSuperMethodImplUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.light.LightElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.light.LightModifierList;
import org.jetbrains.kotlin.com.intellij.psi.impl.light.LightParameter;
import org.jetbrains.kotlin.com.intellij.psi.impl.light.LightParameterListBuilder;
import org.jetbrains.kotlin.com.intellij.psi.impl.light.LightReferenceListBuilder;
import org.jetbrains.kotlin.com.intellij.psi.impl.light.LightTypeParameter;
import org.jetbrains.kotlin.com.intellij.psi.impl.light.LightTypeParameterListBuilder;
import org.jetbrains.kotlin.com.intellij.psi.javadoc.PsiDocComment;
import org.jetbrains.kotlin.com.intellij.psi.search.SearchScope;
import org.jetbrains.kotlin.com.intellij.psi.util.MethodSignature;
import org.jetbrains.kotlin.com.intellij.psi.util.MethodSignatureBackedByPsiMethod;
import org.jetbrains.kotlin.com.intellij.ui.IconManager;
import org.jetbrains.kotlin.com.intellij.ui.icons.RowIcon;
import org.jetbrains.kotlin.com.intellij.util.IncorrectOperationException;
import org.jetbrains.kotlin.com.intellij.util.PlatformIcons;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;

public class LightMethodBuilder
extends LightElement
implements OriginInfoAwareElement,
PsiMethod {
    private final String myName;
    private Computable<? extends PsiType> myReturnType;
    private final PsiModifierList myModifierList;
    private final PsiParameterList myParameterList;
    private final PsiTypeParameterList myTypeParameterList;
    private final PsiReferenceList myThrowsList;
    private Icon myBaseIcon;
    private PsiClass myContainingClass;
    private boolean myConstructor;
    private String myMethodKind;
    private String myOriginInfo;

    public LightMethodBuilder(PsiClass constructedClass, Language language) {
        this(constructedClass.getManager(), language, constructedClass.getName());
        this.setContainingClass(constructedClass);
    }

    public LightMethodBuilder(PsiManager manager, String name2) {
        this(manager, JavaLanguage.INSTANCE, name2);
    }

    public LightMethodBuilder(PsiManager manager, Language language, String name2) {
        this(manager, language, name2, new LightParameterListBuilder(manager, language), new LightModifierList(manager, language, new String[0]));
    }

    public LightMethodBuilder(PsiManager manager, Language language, String name2, PsiParameterList parameterList, PsiModifierList modifierList2) {
        this(manager, language, name2, parameterList, modifierList2, new LightReferenceListBuilder(manager, language, PsiReferenceList.Role.THROWS_LIST), new LightTypeParameterListBuilder(manager, language));
    }

    public LightMethodBuilder(PsiManager manager, Language language, @NotNull String name2, PsiParameterList parameterList, PsiModifierList modifierList2, PsiReferenceList throwsList, PsiTypeParameterList typeParameterList) {
        if (name2 == null) {
            LightMethodBuilder.$$$reportNull$$$0(0);
        }
        super(manager, language);
        this.myMethodKind = "LightMethodBuilder";
        this.myName = name2;
        this.myParameterList = parameterList;
        this.myModifierList = modifierList2;
        this.myThrowsList = throwsList;
        this.myTypeParameterList = typeParameterList;
    }

    @Override
    public ItemPresentation getPresentation() {
        return ItemPresentationProviders.getItemPresentation(this);
    }

    @Override
    public boolean hasTypeParameters() {
        return PsiImplUtil.hasTypeParameters(this);
    }

    @Override
    public PsiTypeParameter @NotNull [] getTypeParameters() {
        PsiTypeParameter[] psiTypeParameterArray = PsiImplUtil.getTypeParameters(this);
        if (psiTypeParameterArray == null) {
            LightMethodBuilder.$$$reportNull$$$0(1);
        }
        return psiTypeParameterArray;
    }

    @Override
    public PsiTypeParameterList getTypeParameterList() {
        return this.myTypeParameterList;
    }

    @Override
    public PsiDocComment getDocComment() {
        return null;
    }

    @Override
    public boolean isDeprecated() {
        return PsiImplUtil.isDeprecatedByDocTag(this) || PsiImplUtil.isDeprecatedByAnnotation(this);
    }

    @Override
    public PsiElement setName(@NotNull String name2) throws IncorrectOperationException {
        if (name2 == null) {
            LightMethodBuilder.$$$reportNull$$$0(2);
        }
        String className2 = this.myContainingClass == null ? "null" : this.myContainingClass.getQualifiedName();
        throw new UnsupportedOperationException("Please don't rename light methods: writable=" + this.isWritable() + "; class=" + this.getClass() + "; name=" + this.getName() + "; inClass=" + className2);
    }

    @Override
    @NotNull
    public String getName() {
        String string2 = this.myName;
        if (string2 == null) {
            LightMethodBuilder.$$$reportNull$$$0(3);
        }
        return string2;
    }

    @Override
    @NotNull
    public HierarchicalMethodSignature getHierarchicalMethodSignature() {
        HierarchicalMethodSignature hierarchicalMethodSignature = PsiSuperMethodImplUtil.getHierarchicalMethodSignature(this);
        if (hierarchicalMethodSignature == null) {
            LightMethodBuilder.$$$reportNull$$$0(4);
        }
        return hierarchicalMethodSignature;
    }

    @Override
    public boolean hasModifierProperty(@NotNull String name2) {
        if (name2 == null) {
            LightMethodBuilder.$$$reportNull$$$0(5);
        }
        return this.getModifierList().hasModifierProperty(name2);
    }

    @Override
    @NotNull
    public PsiModifierList getModifierList() {
        PsiModifierList psiModifierList = this.myModifierList;
        if (psiModifierList == null) {
            LightMethodBuilder.$$$reportNull$$$0(6);
        }
        return psiModifierList;
    }

    public LightMethodBuilder addModifiers(String ... modifiers2) {
        for (String modifier : modifiers2) {
            this.addModifier(modifier);
        }
        return this;
    }

    public LightMethodBuilder addModifier(String modifier) {
        ((LightModifierList)this.myModifierList).addModifier(modifier);
        return this;
    }

    public LightMethodBuilder setModifiers(String ... modifiers2) {
        ((LightModifierList)this.myModifierList).clearModifiers();
        this.addModifiers(modifiers2);
        return this;
    }

    @Override
    public PsiType getReturnType() {
        return this.myReturnType == null ? null : this.myReturnType.compute();
    }

    public LightMethodBuilder setMethodReturnType(Computable<? extends PsiType> returnType2) {
        this.myReturnType = returnType2;
        return this;
    }

    public LightMethodBuilder setMethodReturnType(PsiType returnType2) {
        return this.setMethodReturnType(new Computable.PredefinedValueComputable<PsiType>(returnType2));
    }

    public LightMethodBuilder setMethodReturnType(final @NotNull String returnType2) {
        if (returnType2 == null) {
            LightMethodBuilder.$$$reportNull$$$0(7);
        }
        return this.setMethodReturnType((Computable<? extends PsiType>)new Computable.NotNullCachedComputable<PsiType>(){

            @Override
            @NotNull
            protected PsiType internalCompute() {
                PsiClassType psiClassType = JavaPsiFacade.getElementFactory(LightMethodBuilder.this.getProject()).createTypeByFQClassName(returnType2, LightMethodBuilder.this.getResolveScope());
                if (psiClassType == null) {
                    1.$$$reportNull$$$0(0);
                }
                return psiClassType;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/light/LightMethodBuilder$1", "internalCompute"));
            }
        });
    }

    @Override
    public PsiTypeElement getReturnTypeElement() {
        return null;
    }

    @Override
    @NotNull
    public PsiParameterList getParameterList() {
        PsiParameterList psiParameterList = this.myParameterList;
        if (psiParameterList == null) {
            LightMethodBuilder.$$$reportNull$$$0(8);
        }
        return psiParameterList;
    }

    public LightMethodBuilder addParameter(@NotNull PsiParameter parameter) {
        if (parameter == null) {
            LightMethodBuilder.$$$reportNull$$$0(9);
        }
        ((LightParameterListBuilder)this.myParameterList).addParameter(parameter);
        return this;
    }

    public LightMethodBuilder addParameter(@NotNull String name2, @NotNull String type2) {
        if (name2 == null) {
            LightMethodBuilder.$$$reportNull$$$0(10);
        }
        if (type2 == null) {
            LightMethodBuilder.$$$reportNull$$$0(11);
        }
        return this.addParameter(name2, JavaPsiFacade.getElementFactory(this.getProject()).createTypeFromText(type2, this));
    }

    public LightMethodBuilder addParameter(@NotNull String name2, @NotNull PsiType type2) {
        if (name2 == null) {
            LightMethodBuilder.$$$reportNull$$$0(12);
        }
        if (type2 == null) {
            LightMethodBuilder.$$$reportNull$$$0(13);
        }
        return this.addParameter(new LightParameter(name2, type2, this, (Language)JavaLanguage.INSTANCE));
    }

    public LightMethodBuilder addParameter(@NotNull String name2, @NotNull PsiType type2, boolean isVarArgs) {
        if (name2 == null) {
            LightMethodBuilder.$$$reportNull$$$0(14);
        }
        if (type2 == null) {
            LightMethodBuilder.$$$reportNull$$$0(15);
        }
        if (isVarArgs && !(type2 instanceof PsiEllipsisType)) {
            type2 = new PsiEllipsisType(type2);
        }
        return this.addParameter(new LightParameter(name2, type2, (PsiElement)this, (Language)JavaLanguage.INSTANCE, isVarArgs));
    }

    public LightMethodBuilder addException(PsiClassType type2) {
        ((LightReferenceListBuilder)this.myThrowsList).addReference(type2);
        return this;
    }

    public LightMethodBuilder addException(String fqName2) {
        ((LightReferenceListBuilder)this.myThrowsList).addReference(fqName2);
        return this;
    }

    @Override
    @NotNull
    public PsiReferenceList getThrowsList() {
        PsiReferenceList psiReferenceList = this.myThrowsList;
        if (psiReferenceList == null) {
            LightMethodBuilder.$$$reportNull$$$0(16);
        }
        return psiReferenceList;
    }

    @Override
    public PsiCodeBlock getBody() {
        return null;
    }

    public LightMethodBuilder setConstructor(boolean constructor2) {
        this.myConstructor = constructor2;
        return this;
    }

    @Override
    public boolean isConstructor() {
        return this.myConstructor;
    }

    @Override
    public boolean isVarArgs() {
        return PsiImplUtil.isVarArgs(this);
    }

    @Override
    @NotNull
    public MethodSignature getSignature(@NotNull PsiSubstitutor substitutor2) {
        if (substitutor2 == null) {
            LightMethodBuilder.$$$reportNull$$$0(17);
        }
        MethodSignatureBackedByPsiMethod methodSignatureBackedByPsiMethod = MethodSignatureBackedByPsiMethod.create(this, substitutor2);
        if (methodSignatureBackedByPsiMethod == null) {
            LightMethodBuilder.$$$reportNull$$$0(18);
        }
        return methodSignatureBackedByPsiMethod;
    }

    @Override
    public PsiIdentifier getNameIdentifier() {
        return null;
    }

    @Override
    public PsiMethod @NotNull [] findSuperMethods() {
        PsiMethod[] psiMethodArray = PsiSuperMethodImplUtil.findSuperMethods(this);
        if (psiMethodArray == null) {
            LightMethodBuilder.$$$reportNull$$$0(19);
        }
        return psiMethodArray;
    }

    @Override
    public PsiMethod @NotNull [] findSuperMethods(boolean checkAccess) {
        PsiMethod[] psiMethodArray = PsiSuperMethodImplUtil.findSuperMethods((PsiMethod)this, checkAccess);
        if (psiMethodArray == null) {
            LightMethodBuilder.$$$reportNull$$$0(20);
        }
        return psiMethodArray;
    }

    @Override
    public PsiMethod @NotNull [] findSuperMethods(PsiClass parentClass) {
        PsiMethod[] psiMethodArray = PsiSuperMethodImplUtil.findSuperMethods((PsiMethod)this, parentClass);
        if (psiMethodArray == null) {
            LightMethodBuilder.$$$reportNull$$$0(21);
        }
        return psiMethodArray;
    }

    @Override
    @NotNull
    public List<MethodSignatureBackedByPsiMethod> findSuperMethodSignaturesIncludingStatic(boolean checkAccess) {
        List<MethodSignatureBackedByPsiMethod> list2 = PsiSuperMethodImplUtil.findSuperMethodSignaturesIncludingStatic(this, checkAccess);
        if (list2 == null) {
            LightMethodBuilder.$$$reportNull$$$0(22);
        }
        return list2;
    }

    @Override
    public PsiMethod findDeepestSuperMethod() {
        return PsiSuperMethodImplUtil.findDeepestSuperMethod(this);
    }

    @Override
    public PsiMethod @NotNull [] findDeepestSuperMethods() {
        PsiMethod[] psiMethodArray = PsiSuperMethodImplUtil.findDeepestSuperMethods(this);
        if (psiMethodArray == null) {
            LightMethodBuilder.$$$reportNull$$$0(23);
        }
        return psiMethodArray;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 == null) {
            LightMethodBuilder.$$$reportNull$$$0(24);
        }
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitMethod(this);
        }
    }

    @Override
    public PsiClass getContainingClass() {
        return this.myContainingClass;
    }

    public LightMethodBuilder setContainingClass(PsiClass containingClass) {
        this.myContainingClass = containingClass;
        return this;
    }

    public LightMethodBuilder setMethodKind(String debugKindName) {
        this.myMethodKind = debugKindName;
        return this;
    }

    @Override
    public String toString() {
        return this.myMethodKind + ":" + this.getName();
    }

    @Override
    public Icon getElementIcon(int flags) {
        Icon methodIcon = this.myBaseIcon != null ? this.myBaseIcon : (this.hasModifierProperty("abstract") ? PlatformIcons.ABSTRACT_METHOD_ICON : PlatformIcons.METHOD_ICON);
        RowIcon baseIcon = IconManager.getInstance().createLayeredIcon(this, methodIcon, ElementPresentationUtil.getFlags(this, false));
        return ElementPresentationUtil.addVisibilityIcon(this, flags, baseIcon);
    }

    @Override
    protected boolean isVisibilitySupported() {
        return true;
    }

    public LightMethodBuilder setBaseIcon(Icon baseIcon) {
        this.myBaseIcon = baseIcon;
        return this;
    }

    @Override
    public boolean isEquivalentTo(PsiElement another) {
        return PsiClassImplUtil.isMethodEquivalentTo(this, another);
    }

    @Override
    @NotNull
    public SearchScope getUseScope() {
        SearchScope searchScope = PsiImplUtil.getMemberUseScope(this);
        if (searchScope == null) {
            LightMethodBuilder.$$$reportNull$$$0(25);
        }
        return searchScope;
    }

    @Override
    @Nullable
    public PsiFile getContainingFile() {
        PsiClass containingClass = this.getContainingClass();
        return containingClass == null ? null : containingClass.getContainingFile();
    }

    @Override
    public PsiElement getContext() {
        PsiElement navElement = this.getNavigationElement();
        if (navElement != this) {
            return navElement;
        }
        PsiClass cls = this.getContainingClass();
        if (cls != null) {
            return cls;
        }
        return this.getContainingFile();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LightMethodBuilder that = (LightMethodBuilder)o;
        if (this.myConstructor != that.myConstructor) {
            return false;
        }
        if (!Objects.equals(this.myContainingClass, that.myContainingClass)) {
            return false;
        }
        if (!this.myMethodKind.equals(that.myMethodKind)) {
            return false;
        }
        if (!this.myName.equals(that.myName)) {
            return false;
        }
        if (!this.getParameterTypes().equals(that.getParameterTypes())) {
            return false;
        }
        return Objects.equals(this.getReturnType(), that.getReturnType());
    }

    public int hashCode() {
        return Objects.hash(this.myName, this.getReturnType(), this.myConstructor, this.myMethodKind, this.myContainingClass, this.getParameterTypes());
    }

    @NotNull
    private List<PsiType> getParameterTypes() {
        List<PsiType> list2 = ContainerUtil.map(this.getParameterList().getParameters(), PsiParameter::getType);
        if (list2 == null) {
            LightMethodBuilder.$$$reportNull$$$0(26);
        }
        return list2;
    }

    public LightMethodBuilder addTypeParameter(PsiTypeParameter parameter) {
        ((LightTypeParameterListBuilder)this.myTypeParameterList).addParameter(new LightTypeParameter(parameter));
        return this;
    }

    @Override
    @Nullable
    @NonNls
    public String getOriginInfo() {
        return this.myOriginInfo;
    }

    public void setOriginInfo(@Nullable @NonNls String originInfo) {
        this.myOriginInfo = originInfo;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/impl/light/LightMethodBuilder";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "returnType";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 11: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutor";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/impl/light/LightMethodBuilder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeParameters";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getHierarchicalMethodSignature";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getModifierList";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameterList";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getThrowsList";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getSignature";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "findSuperMethods";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "findSuperMethodSignaturesIncludingStatic";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "findDeepestSuperMethods";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getUseScope";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameterTypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "hasModifierProperty";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setMethodReturnType";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "addParameter";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getSignature";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

