/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.interpreter.state;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.interpreter.UtilsKt;
import org.jetbrains.kotlin.ir.interpreter.stack.CallStack;
import org.jetbrains.kotlin.ir.interpreter.stack.Variable;
import org.jetbrains.kotlin.ir.interpreter.state.Complex;
import org.jetbrains.kotlin.ir.interpreter.state.Primitive;
import org.jetbrains.kotlin.ir.interpreter.state.State;
import org.jetbrains.kotlin.ir.interpreter.state.StateKt;
import org.jetbrains.kotlin.ir.interpreter.state.StateWithClosure;
import org.jetbrains.kotlin.ir.interpreter.state.Wrapper;
import org.jetbrains.kotlin.ir.symbols.IrPropertySymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueSymbol;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\f\b\u0000\u0018\u0000 B2\u00020\u00012\u00020\u00022\u00020\u0003:\u0001BB\u001d\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tB%\b\u0016\u0012\u0006\u0010\n\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\u000bB5\b\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0016\u0010\f\u001a\u0012\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\rj\u0002`\u0010\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\u0011J\u000e\u00102\u001a\u0002032\u0006\u00104\u001a\u00020*J\u0006\u00105\u001a\u00020\bJ\u000e\u00106\u001a\u0002072\u0006\u00108\u001a\u00020\u0005J\b\u00109\u001a\u000203H\u0002J\u0012\u0010:\u001a\u0002032\b\u0010;\u001a\u0004\u0018\u00010\u000fH\u0002J\u0018\u0010<\u001a\u0002032\u0006\u0010=\u001a\u00020\u000e2\u0006\u0010>\u001a\u00020\u000fH\u0016J\u0012\u0010?\u001a\u0002032\b\u0010@\u001a\u0004\u0018\u00010\bH\u0002J\b\u0010A\u001a\u00020\bH\u0016R\u0016\u0010\u0012\u001a\u0004\u0018\u00010\u00008VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\bX\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\b0\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\f\u001a\u0012\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\rj\u0002`\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0016\u0010\u001e\u001a\u0004\u0018\u00010\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u000e\u0010!\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R.\u0010\"\u001a\u0016\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f\u0018\u00010#j\u0004\u0018\u0001`$X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010)\u001a\u0004\u0018\u00010*X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010,\"\u0004\b-\u0010.R \u0010/\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u0002000\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u0010\u001b\u00a8\u0006C"}, d2={"Lorg/jetbrains/kotlin/ir/interpreter/state/ExceptionState;", "Lorg/jetbrains/kotlin/ir/interpreter/state/Complex;", "Lorg/jetbrains/kotlin/ir/interpreter/state/StateWithClosure;", "", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "stackTrace", "", "", "(Lorg/jetbrains/kotlin/ir/declarations/IrClass;Ljava/util/List;)V", "exception", "(Ljava/lang/Throwable;Lorg/jetbrains/kotlin/ir/declarations/IrClass;Ljava/util/List;)V", "fields", "", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "Lorg/jetbrains/kotlin/ir/interpreter/state/State;", "Lorg/jetbrains/kotlin/ir/interpreter/stack/Fields;", "(Lorg/jetbrains/kotlin/ir/declarations/IrClass;Ljava/util/Map;Ljava/util/List;)V", "cause", "getCause", "()Lorg/jetbrains/kotlin/ir/interpreter/state/ExceptionState;", "causeProperty", "Lorg/jetbrains/kotlin/ir/declarations/IrProperty;", "exceptionFqName", "exceptionHierarchy", "", "getFields", "()Ljava/util/Map;", "getIrClass", "()Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "message", "getMessage", "()Ljava/lang/String;", "messageProperty", "outerClass", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/ir/interpreter/stack/Field;", "getOuterClass", "()Lkotlin/Pair;", "setOuterClass", "(Lkotlin/Pair;)V", "superWrapperClass", "Lorg/jetbrains/kotlin/ir/interpreter/state/Wrapper;", "getSuperWrapperClass", "()Lorg/jetbrains/kotlin/ir/interpreter/state/Wrapper;", "setSuperWrapperClass", "(Lorg/jetbrains/kotlin/ir/interpreter/state/Wrapper;)V", "upValues", "Lorg/jetbrains/kotlin/ir/interpreter/stack/Variable;", "getUpValues", "copyFieldsFrom", "", "wrapper", "getFullDescription", "isSubtypeOf", "", "ancestor", "recalculateCauseAndMessage", "setCause", "causeValue", "setField", "symbol", "state", "setMessage", "messageValue", "toString", "Companion", "ir.interpreter"})
public final class ExceptionState
extends Throwable
implements Complex,
StateWithClosure {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IrClass irClass;
    @NotNull
    private final Map<IrSymbol, State> fields;
    @NotNull
    private final Map<IrSymbol, Variable> upValues;
    @Nullable
    private Wrapper superWrapperClass;
    @Nullable
    private Pair<? extends IrSymbol, ? extends State> outerClass;
    private String exceptionFqName;
    @NotNull
    private final List<String> exceptionHierarchy;
    @NotNull
    private final IrProperty messageProperty;
    @NotNull
    private final IrProperty causeProperty;
    @NotNull
    private final List<String> stackTrace;

    private ExceptionState(IrClass irClass2, Map<IrSymbol, State> fields2, List<String> stackTrace) {
        this.irClass = irClass2;
        this.fields = fields2;
        this.upValues = new LinkedHashMap();
        this.exceptionHierarchy = new ArrayList();
        this.messageProperty = UtilsKt.getOriginalPropertyByName(this.getIrClass(), "message");
        this.causeProperty = UtilsKt.getOriginalPropertyByName(this.getIrClass(), "cause");
        this.stackTrace = CollectionsKt.reversed((Iterable)stackTrace);
        if (this.exceptionFqName == null) {
            this.exceptionFqName = this.irClassFqName();
        }
        if (!this.getFields().containsKey(this.messageProperty.getSymbol())) {
            this.setMessage(null);
        }
        if (!this.getFields().containsKey(this.causeProperty.getSymbol())) {
            this.setCause(null);
        }
    }

    @Override
    @NotNull
    public IrClass getIrClass() {
        return this.irClass;
    }

    @Override
    @NotNull
    public Map<IrSymbol, State> getFields() {
        return this.fields;
    }

    @Override
    @NotNull
    public Map<IrSymbol, Variable> getUpValues() {
        return this.upValues;
    }

    @Override
    @Nullable
    public Wrapper getSuperWrapperClass() {
        return this.superWrapperClass;
    }

    @Override
    public void setSuperWrapperClass(@Nullable Wrapper wrapper) {
        this.superWrapperClass = wrapper;
    }

    @Override
    @Nullable
    public Pair<IrSymbol, State> getOuterClass() {
        return this.outerClass;
    }

    @Override
    public void setOuterClass(@Nullable Pair<? extends IrSymbol, ? extends State> pair) {
        this.outerClass = pair;
    }

    @Override
    @Nullable
    public String getMessage() {
        State state = this.getField(this.messageProperty.getSymbol());
        return state == null ? null : StateKt.asStringOrNull(state);
    }

    @Override
    @Nullable
    public ExceptionState getCause() {
        State state = this.getField(this.causeProperty.getSymbol());
        return state instanceof ExceptionState ? (ExceptionState)state : null;
    }

    public ExceptionState(@NotNull IrClass irClass2, @NotNull List<String> stackTrace) {
        Intrinsics.checkNotNullParameter(irClass2, "irClass");
        Intrinsics.checkNotNullParameter(stackTrace, "stackTrace");
        this(irClass2, new LinkedHashMap(), stackTrace);
    }

    public ExceptionState(@NotNull Throwable exception, @NotNull IrClass irClass2, @NotNull List<String> stackTrace) {
        Intrinsics.checkNotNullParameter(exception, "exception");
        Intrinsics.checkNotNullParameter(irClass2, "irClass");
        Intrinsics.checkNotNullParameter(stackTrace, "stackTrace");
        this(irClass2, ExceptionState.Companion.evaluateFields(exception, irClass2, stackTrace), CollectionsKt.plus((Collection)stackTrace, (Iterable)ExceptionState.Companion.evaluateAdditionalStackTrace(exception)));
        this.setCause(null);
        if (!Intrinsics.areEqual(irClass2.getName().asString(), exception.getClass().getSimpleName())) {
            String string2;
            Object object = exception.getClass().getName();
            Intrinsics.checkNotNullExpressionValue(object, "exception::class.java.name");
            this.exceptionFqName = object;
            object = this;
            Collection collection = ((ExceptionState)object).exceptionHierarchy;
            Object object2 = this.exceptionFqName;
            if (object2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("exceptionFqName");
                string2 = null;
            } else {
                string2 = object2;
            }
            collection.add(string2);
            Sequence<Class<?>> $this$forEach$iv = SequencesKt.generateSequence(exception.getClass().getSuperclass(), (Function1)2.INSTANCE);
            boolean $i$f$forEach = false;
            object2 = $this$forEach$iv.iterator();
            while (object2.hasNext()) {
                Object element$iv = object2.next();
                Class it = (Class)element$iv;
                boolean bl = false;
                ExceptionState exceptionState = this;
                ((Collection)exceptionState.exceptionHierarchy).add(it.getName());
            }
            this.exceptionHierarchy.remove(CollectionsKt.getLastIndex(this.exceptionHierarchy));
        }
    }

    public final void copyFieldsFrom(@NotNull Wrapper wrapper) {
        Throwable throwable;
        Intrinsics.checkNotNullParameter(wrapper, "wrapper");
        Object object = wrapper.getValue();
        Throwable throwable2 = throwable = object instanceof Throwable ? (Throwable)object : null;
        if (throwable != null) {
            Object it = object = throwable;
            boolean bl = false;
            this.setMessage(((Throwable)it).getMessage());
            Throwable throwable3 = ((Throwable)it).getCause();
            this.setCause(throwable3 instanceof ExceptionState ? (ExceptionState)throwable3 : null);
        }
    }

    @Override
    public void setField(@NotNull IrSymbol symbol2, @NotNull State state) {
        Intrinsics.checkNotNullParameter(symbol2, "symbol");
        Intrinsics.checkNotNullParameter(state, "state");
        Complex.DefaultImpls.setField(this, symbol2, state);
        this.recalculateCauseAndMessage();
    }

    /*
     * WARNING - void declaration
     */
    private final void recalculateCauseAndMessage() {
        if (this.getMessage() == null && this.getCause() != null) {
            String string2;
            String string3;
            ExceptionState exceptionState = this.getCause();
            Intrinsics.checkNotNull(exceptionState);
            String string4 = exceptionState.exceptionFqName;
            if (string4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("exceptionFqName");
                string3 = null;
            } else {
                string3 = string4;
            }
            ExceptionState exceptionState2 = this.getCause();
            Intrinsics.checkNotNull(exceptionState2);
            string4 = exceptionState2.getMessage();
            if (string4 == null) {
                string2 = "";
            } else {
                void it;
                String string5;
                String string6 = string5 = string4;
                String string7 = string3;
                boolean bl = false;
                String string8 = Intrinsics.stringPlus(": ", it);
                string3 = string7;
                string2 = string8;
            }
            String causeMessage = Intrinsics.stringPlus(string3, string2);
            this.setMessage(causeMessage);
        }
    }

    public final boolean isSubtypeOf(@NotNull IrClass ancestor) {
        Intrinsics.checkNotNullParameter(ancestor, "ancestor");
        if (!((Collection)this.exceptionHierarchy).isEmpty()) {
            boolean bl;
            block4: {
                Iterable $this$any$iv = this.exceptionHierarchy;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        String it = (String)element$iv;
                        boolean bl2 = false;
                        CharSequence charSequence2 = it;
                        String string2 = ancestor.getName().asString();
                        Intrinsics.checkNotNullExpressionValue(string2, "ancestor.name.asString()");
                        if (!StringsKt.contains$default(charSequence2, string2, false, 2, null)) continue;
                        bl = true;
                        break block4;
                    }
                    bl = false;
                }
            }
            return bl;
        }
        return IrUtilsKt.isSubclassOf(this.getIrClass(), ancestor);
    }

    private final void setMessage(String messageValue) {
        IrSymbol irSymbol2 = this.messageProperty.getSymbol();
        IrSimpleFunction irSimpleFunction = this.messageProperty.getGetter();
        Intrinsics.checkNotNull(irSimpleFunction);
        this.setField(irSymbol2, new Primitive<String>(messageValue, irSimpleFunction.getReturnType()));
    }

    private final void setCause(State causeValue) {
        State state;
        IrSymbol irSymbol2 = this.causeProperty.getSymbol();
        State state2 = causeValue;
        if (state2 == null) {
            IrSimpleFunction irSimpleFunction = this.causeProperty.getGetter();
            Intrinsics.checkNotNull(irSimpleFunction);
            state = Primitive.Companion.nullStateOfType(irSimpleFunction.getReturnType());
        } else {
            state = state2;
        }
        this.setField(irSymbol2, state);
    }

    @NotNull
    public final String getFullDescription() {
        Object object;
        String string2;
        String string3;
        String it = string3 = this.getMessage();
        boolean bl = false;
        Object object2 = it;
        String message2 = (object2 == null ? false : ((CharSequence)object2).length() > 0) ? Intrinsics.stringPlus(": ", it) : "";
        String prefix = !((Collection)this.stackTrace).isEmpty() ? "\n\t" : "";
        String postfix = this.stackTrace.size() > 10 ? "\n\t..." : "";
        object2 = this.getCause();
        if (object2 == null) {
            string2 = "";
        } else {
            String string4 = ((ExceptionState)object2).getFullDescription();
            string2 = StringsKt.replaceFirst$default(string4, "Exception ", "\nCaused by: ", false, 4, null);
        }
        String causeMessage = string2;
        StringBuilder stringBuilder2 = new StringBuilder().append("Exception ");
        object2 = this.exceptionFqName;
        if (object2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("exceptionFqName");
            object = null;
        } else {
            object = object2;
        }
        return stringBuilder2.append((String)object).append(message2).append(CollectionsKt.joinToString$default(this.stackTrace.subList(0, Math.min(this.stackTrace.size(), 10)), "\n\t", prefix, postfix, 0, null, null, 56, null)).append(causeMessage).toString();
    }

    @Override
    @NotNull
    public String toString() {
        String string2;
        String string3 = this.getMessage();
        if (string3 == null) {
            String string4 = this.exceptionFqName;
            if (string4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("exceptionFqName");
                string2 = null;
            } else {
                string2 = string4;
            }
        } else {
            String string5;
            String string6;
            String it = string6 = string3;
            boolean bl = false;
            StringBuilder stringBuilder2 = new StringBuilder();
            String string7 = this.exceptionFqName;
            if (string7 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("exceptionFqName");
                string5 = null;
            } else {
                string5 = string7;
            }
            string2 = stringBuilder2.append(string5).append(": ").append(it).toString();
        }
        return string2;
    }

    @Override
    @Nullable
    public State getField(@NotNull IrSymbol symbol2) {
        return Complex.DefaultImpls.getField(this, symbol2);
    }

    @Override
    @Nullable
    public IrFunction getIrFunctionByIrCall(@NotNull IrCall expression2) {
        return Complex.DefaultImpls.getIrFunctionByIrCall(this, expression2);
    }

    @Override
    @NotNull
    public IrSimpleFunction getRealFunction(@NotNull IrSimpleFunction owner) {
        return Complex.DefaultImpls.getRealFunction(this, owner);
    }

    @Override
    @NotNull
    public String irClassFqName() {
        return Complex.DefaultImpls.irClassFqName(this);
    }

    @Override
    public void loadOuterClassesInto(@NotNull CallStack callStack, @Nullable IrValueSymbol receiver) {
        Complex.DefaultImpls.loadOuterClassesInto(this, callStack, receiver);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J6\u0010\b\u001a\u0012\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tj\u0002`\f2\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0002\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/ir/interpreter/state/ExceptionState$Companion;", "", "()V", "evaluateAdditionalStackTrace", "", "", "e", "", "evaluateFields", "", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "Lorg/jetbrains/kotlin/ir/interpreter/state/State;", "Lorg/jetbrains/kotlin/ir/interpreter/stack/Fields;", "exception", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "stackTrace", "ir.interpreter"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        private final Map<IrSymbol, State> evaluateFields(Throwable exception, IrClass irClass2, List<String> stackTrace) {
            Map<IrSymbol, State> map2;
            Object object;
            Pair[] it;
            Pair[] pairArray;
            Pair<IrPropertySymbol, ExceptionState> pair;
            IrProperty messageProperty = UtilsKt.getOriginalPropertyByName(irClass2, "message");
            IrProperty causeProperty = UtilsKt.getOriginalPropertyByName(irClass2, "cause");
            IrPropertySymbol irPropertySymbol = messageProperty.getSymbol();
            String string2 = exception.getMessage();
            IrSimpleFunction irSimpleFunction = messageProperty.getGetter();
            Intrinsics.checkNotNull(irSimpleFunction);
            Pair<IrPropertySymbol, Primitive<String>> messageVar = TuplesKt.to(irPropertySymbol, new Primitive<String>(string2, irSimpleFunction.getReturnType()));
            Pair[] pairArray2 = exception.getCause();
            if (pairArray2 == null) {
                pair = null;
            } else {
                Collection<String> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                it = pairArray = pairArray2;
                boolean bl = false;
                IrPropertySymbol irPropertySymbol2 = causeProperty.getSymbol();
                Collection collection2 = stackTrace;
                object = it.getStackTrace();
                Intrinsics.checkNotNullExpressionValue(object, "it.stackTrace");
                object = ArraysKt.reversed((Object[])object);
                Collection collection3 = collection2;
                IrClass irClass3 = irClass2;
                Pair[] pairArray3 = it;
                IrPropertySymbol irPropertySymbol3 = irPropertySymbol2;
                boolean $i$f$map = false;
                void var18_17 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it2;
                    StackTraceElement stackTraceElement = (StackTraceElement)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl2 = false;
                    String string3 = Intrinsics.stringPlus("at ", it2);
                    collection.add(string3);
                }
                collection = (List)destination$iv$iv;
                List<String> list2 = CollectionsKt.plus(collection3, (Iterable)collection);
                IrClass irClass4 = irClass3;
                Pair[] pairArray4 = pairArray3;
                pair = TuplesKt.to(irPropertySymbol3, new ExceptionState((Throwable)pairArray4, irClass4, list2));
            }
            Pair<IrPropertySymbol, ExceptionState> causeVar = pair;
            pairArray2 = causeVar;
            if (pairArray2 == null) {
                pairArray = new Pair[]{messageVar};
                map2 = MapsKt.mutableMapOf(pairArray);
            } else {
                it = pairArray = pairArray2;
                boolean bl = false;
                object = new Pair[]{messageVar, it};
                map2 = MapsKt.mutableMapOf(object);
            }
            return map2;
        }

        /*
         * WARNING - void declaration
         */
        private final List<String> evaluateAdditionalStackTrace(Throwable e) {
            boolean bl;
            Object[] $this$any$iv;
            List additionalStack;
            block6: {
                additionalStack = new ArrayList();
                StackTraceElement[] stackTraceElementArray = e.getStackTrace();
                Intrinsics.checkNotNullExpressionValue(stackTraceElementArray, "e.stackTrace");
                $this$any$iv = stackTraceElementArray;
                boolean $i$f$any22 = false;
                for (Object object : $this$any$iv) {
                    StackTraceElement it = (StackTraceElement)object;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual(it.getClassName(), "java.lang.invoke.MethodHandle")) continue;
                    bl = true;
                    break block6;
                }
                bl = false;
            }
            if (bl) {
                StackTraceElement[] $i$f$any22 = e.getStackTrace();
                Intrinsics.checkNotNullExpressionValue($i$f$any22, "e.stackTrace");
                $this$any$iv = $i$f$any22;
                int n = $this$any$iv.length;
                for (int $i$f$any22 = 0; $i$f$any22 < n; ++$i$f$any22) {
                    Collection<String> collection;
                    void $this$mapTo$iv$iv;
                    int index2 = $i$f$any22;
                    Object stackTraceElement = $this$any$iv[$i$f$any22];
                    if (!Intrinsics.areEqual(((StackTraceElement)stackTraceElement).getMethodName(), "invokeWithArguments")) continue;
                    StackTraceElement[] stackTraceElementArray = e.getStackTrace();
                    Intrinsics.checkNotNullExpressionValue(stackTraceElementArray, "e.stackTrace");
                    Iterable iterable = CollectionsKt.reversed((Iterable)ArraysKt.slice((Object[])stackTraceElementArray, RangesKt.until(0, index2)));
                    List list2 = additionalStack;
                    boolean $i$f$map = false;
                    Iterable bl2 = iterable;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault(iterable, 10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        StackTraceElement stackTraceElement2 = (StackTraceElement)item$iv$iv;
                        collection = destination$iv$iv;
                        boolean bl3 = false;
                        String string2 = Intrinsics.stringPlus("at ", it);
                        collection.add(string2);
                    }
                    collection = (List)destination$iv$iv;
                    list2.addAll((Collection)collection);
                    break;
                }
                Object object = e.getStackTrace();
                Intrinsics.checkNotNullExpressionValue(object, "e.stackTrace");
                object = ArraysKt.first((Object[])object);
                StackTraceElement it = (StackTraceElement)object;
                boolean bl4 = false;
                String lastNeededValue = it.getClassName() + '.' + it.getMethodName();
                block3: for (Throwable cause = e.getCause(); cause != null; cause = cause.getCause()) {
                    StackTraceElement[] stackTraceElementArray = cause.getStackTrace();
                    Intrinsics.checkNotNullExpressionValue(stackTraceElementArray, "cause.stackTrace");
                    object = stackTraceElementArray;
                    int n2 = ((StackTraceElement[])object).length;
                    for (int i = 0; i < n2; ++i) {
                        StackTraceElement[] stackTraceElementArray2;
                        int n3 = i;
                        StackTraceElement[] causeStackTraceElement = object[i];
                        StackTraceElement[] it2 = stackTraceElementArray2 = causeStackTraceElement;
                        boolean bl5 = false;
                        String currentStackTraceValue = it2.getClassName() + '.' + it2.getMethodName();
                        if (!Intrinsics.areEqual(currentStackTraceValue, lastNeededValue)) continue;
                        stackTraceElementArray2 = cause.getStackTrace();
                        Intrinsics.checkNotNullExpressionValue(stackTraceElementArray2, "cause.stackTrace");
                        cause.setStackTrace((StackTraceElement[])ArraysKt.reversedArray(ArraysKt.sliceArray((Object[])stackTraceElementArray2, RangesKt.until(0, n3))));
                        continue block3;
                    }
                }
            }
            return additionalStack;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

