/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.apache.commons.codec.binary;

import java.util.Arrays;

public abstract class BaseNCodec {
    @Deprecated
    protected final byte PAD = (byte)61;
    protected final byte pad;
    private final int unencodedBlockSize;
    private final int encodedBlockSize;
    protected final int lineLength;
    private final int chunkSeparatorLength;

    protected BaseNCodec(int unencodedBlockSize, int encodedBlockSize, int lineLength, int chunkSeparatorLength) {
        this(unencodedBlockSize, encodedBlockSize, lineLength, chunkSeparatorLength, 61);
    }

    protected BaseNCodec(int unencodedBlockSize, int encodedBlockSize, int lineLength, int chunkSeparatorLength, byte pad) {
        this.unencodedBlockSize = unencodedBlockSize;
        this.encodedBlockSize = encodedBlockSize;
        boolean useChunking = lineLength > 0 && chunkSeparatorLength > 0;
        this.lineLength = useChunking ? lineLength / encodedBlockSize * encodedBlockSize : 0;
        this.chunkSeparatorLength = chunkSeparatorLength;
        this.pad = pad;
    }

    int available(Context context2) {
        return context2.buffer != null ? context2.pos - context2.readPos : 0;
    }

    protected int getDefaultBufferSize() {
        return 8192;
    }

    private byte[] resizeBuffer(Context context2) {
        if (context2.buffer == null) {
            context2.buffer = new byte[this.getDefaultBufferSize()];
            context2.pos = 0;
            context2.readPos = 0;
        } else {
            byte[] b = new byte[context2.buffer.length * 2];
            System.arraycopy(context2.buffer, 0, b, 0, context2.buffer.length);
            context2.buffer = b;
        }
        return context2.buffer;
    }

    protected byte[] ensureBufferSize(int size, Context context2) {
        if (context2.buffer == null || context2.buffer.length < context2.pos + size) {
            return this.resizeBuffer(context2);
        }
        return context2.buffer;
    }

    int readResults(byte[] b, int bPos, int bAvail, Context context2) {
        if (context2.buffer != null) {
            int len = Math.min(this.available(context2), bAvail);
            System.arraycopy(context2.buffer, context2.readPos, b, bPos, len);
            context2.readPos += len;
            if (context2.readPos >= context2.pos) {
                context2.buffer = null;
            }
            return len;
        }
        return context2.eof ? -1 : 0;
    }

    public byte[] decode(byte[] pArray) {
        if (pArray == null || pArray.length == 0) {
            return pArray;
        }
        Context context2 = new Context();
        this.decode(pArray, 0, pArray.length, context2);
        this.decode(pArray, 0, -1, context2);
        byte[] result2 = new byte[context2.pos];
        this.readResults(result2, 0, result2.length, context2);
        return result2;
    }

    public byte[] encode(byte[] pArray) {
        if (pArray == null || pArray.length == 0) {
            return pArray;
        }
        return this.encode(pArray, 0, pArray.length);
    }

    public byte[] encode(byte[] pArray, int offset2, int length) {
        if (pArray == null || pArray.length == 0) {
            return pArray;
        }
        Context context2 = new Context();
        this.encode(pArray, offset2, length, context2);
        this.encode(pArray, offset2, -1, context2);
        byte[] buf = new byte[context2.pos - context2.readPos];
        this.readResults(buf, 0, buf.length, context2);
        return buf;
    }

    abstract void encode(byte[] var1, int var2, int var3, Context var4);

    abstract void decode(byte[] var1, int var2, int var3, Context var4);

    protected abstract boolean isInAlphabet(byte var1);

    protected boolean containsAlphabetOrPad(byte[] arrayOctet) {
        if (arrayOctet == null) {
            return false;
        }
        for (byte element : arrayOctet) {
            if (this.pad != element && !this.isInAlphabet(element)) continue;
            return true;
        }
        return false;
    }

    public long getEncodedLength(byte[] pArray) {
        long len = (long)((pArray.length + this.unencodedBlockSize - 1) / this.unencodedBlockSize) * (long)this.encodedBlockSize;
        if (this.lineLength > 0) {
            len += (len + (long)this.lineLength - 1L) / (long)this.lineLength * (long)this.chunkSeparatorLength;
        }
        return len;
    }

    static class Context {
        int ibitWorkArea;
        long lbitWorkArea;
        byte[] buffer;
        int pos;
        int readPos;
        boolean eof;
        int currentLinePos;
        int modulus;

        Context() {
        }

        public String toString() {
            return String.format("%s[buffer=%s, currentLinePos=%s, eof=%s, ibitWorkArea=%s, lbitWorkArea=%s, modulus=%s, pos=%s, readPos=%s]", this.getClass().getSimpleName(), Arrays.toString(this.buffer), this.currentLinePos, this.eof, this.ibitWorkArea, this.lbitWorkArea, this.modulus, this.pos, this.readPos);
        }
    }
}

