/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.apache.http.conn.util;

import java.net.IDN;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.kotlin.org.apache.http.conn.util.DnsUtils;
import org.jetbrains.kotlin.org.apache.http.conn.util.DomainType;
import org.jetbrains.kotlin.org.apache.http.conn.util.PublicSuffixList;
import org.jetbrains.kotlin.org.apache.http.util.Args;

public final class PublicSuffixMatcher {
    private final Map<String, DomainType> rules;
    private final Map<String, DomainType> exceptions;

    public PublicSuffixMatcher(DomainType domainType, Collection<String> rules, Collection<String> exceptions) {
        Args.notNull(domainType, "Domain type");
        Args.notNull(rules, "Domain suffix rules");
        this.rules = new ConcurrentHashMap<String, DomainType>(rules.size());
        for (String rule : rules) {
            this.rules.put(rule, domainType);
        }
        this.exceptions = new ConcurrentHashMap<String, DomainType>();
        if (exceptions != null) {
            for (String exception : exceptions) {
                this.exceptions.put(exception, domainType);
            }
        }
    }

    public PublicSuffixMatcher(Collection<PublicSuffixList> lists) {
        Args.notNull(lists, "Domain suffix lists");
        this.rules = new ConcurrentHashMap<String, DomainType>();
        this.exceptions = new ConcurrentHashMap<String, DomainType>();
        for (PublicSuffixList list2 : lists) {
            DomainType domainType = list2.getType();
            List<String> rules = list2.getRules();
            for (String rule : rules) {
                this.rules.put(rule, domainType);
            }
            List<String> exceptions = list2.getExceptions();
            if (exceptions == null) continue;
            for (String exception : exceptions) {
                this.exceptions.put(exception, domainType);
            }
        }
    }

    private static DomainType findEntry(Map<String, DomainType> map2, String rule) {
        if (map2 == null) {
            return null;
        }
        return map2.get(rule);
    }

    private static boolean match(DomainType domainType, DomainType expectedType2) {
        return domainType != null && (expectedType2 == null || domainType.equals((Object)expectedType2));
    }

    public String getDomainRoot(String domain, DomainType expectedType2) {
        String normalized;
        if (domain == null) {
            return null;
        }
        if (domain.startsWith(".")) {
            return null;
        }
        String segment = normalized = DnsUtils.normalize(domain);
        String result2 = null;
        while (segment != null) {
            DomainType wildcardDomainRule;
            String nextSegment;
            String key = IDN.toUnicode(segment);
            DomainType exceptionRule = PublicSuffixMatcher.findEntry(this.exceptions, key);
            if (PublicSuffixMatcher.match(exceptionRule, expectedType2)) {
                return segment;
            }
            DomainType domainRule = PublicSuffixMatcher.findEntry(this.rules, key);
            if (PublicSuffixMatcher.match(domainRule, expectedType2)) {
                if (domainRule == DomainType.PRIVATE) {
                    return segment;
                }
                return result2;
            }
            int nextdot = segment.indexOf(46);
            String string2 = nextSegment = nextdot != -1 ? segment.substring(nextdot + 1) : null;
            if (nextSegment != null && PublicSuffixMatcher.match(wildcardDomainRule = PublicSuffixMatcher.findEntry(this.rules, "*." + IDN.toUnicode(nextSegment)), expectedType2)) {
                if (wildcardDomainRule == DomainType.PRIVATE) {
                    return segment;
                }
                return result2;
            }
            result2 = segment;
            segment = nextSegment;
        }
        if (expectedType2 == null || expectedType2 == DomainType.UNKNOWN) {
            return result2;
        }
        return null;
    }

    public boolean matches(String domain) {
        return this.matches(domain, null);
    }

    public boolean matches(String domain, DomainType expectedType2) {
        if (domain == null) {
            return false;
        }
        String domainRoot = this.getDomainRoot(domain.startsWith(".") ? domain.substring(1) : domain, expectedType2);
        return domainRoot == null;
    }
}

