/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.apache.http.impl.client;

import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import org.jetbrains.kotlin.org.apache.commons.logging.Log;
import org.jetbrains.kotlin.org.apache.commons.logging.LogFactory;
import org.jetbrains.kotlin.org.apache.http.HttpHost;
import org.jetbrains.kotlin.org.apache.http.HttpRequest;
import org.jetbrains.kotlin.org.apache.http.client.ClientProtocolException;
import org.jetbrains.kotlin.org.apache.http.client.methods.CloseableHttpResponse;
import org.jetbrains.kotlin.org.apache.http.client.methods.HttpUriRequest;
import org.jetbrains.kotlin.org.apache.http.client.utils.URIUtils;
import org.jetbrains.kotlin.org.apache.http.protocol.HttpContext;
import org.jetbrains.kotlin.org.apache.http.util.Args;

public abstract class CloseableHttpClient
implements Closeable {
    private final Log log = LogFactory.getLog(this.getClass());

    protected abstract CloseableHttpResponse doExecute(HttpHost var1, HttpRequest var2, HttpContext var3) throws IOException, ClientProtocolException;

    public CloseableHttpResponse execute(HttpUriRequest request, HttpContext context2) throws IOException, ClientProtocolException {
        Args.notNull(request, "HTTP request");
        return this.doExecute(CloseableHttpClient.determineTarget(request), request, context2);
    }

    private static HttpHost determineTarget(HttpUriRequest request) throws ClientProtocolException {
        HttpHost target = null;
        URI requestURI = request.getURI();
        if (requestURI.isAbsolute() && (target = URIUtils.extractHost(requestURI)) == null) {
            throw new ClientProtocolException("URI does not specify a valid host name: " + requestURI);
        }
        return target;
    }
}

