/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.apache.maven.model.interpolation;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import javax.inject.Inject;
import org.jetbrains.kotlin.org.apache.maven.model.Model;
import org.jetbrains.kotlin.org.apache.maven.model.building.ModelBuildingRequest;
import org.jetbrains.kotlin.org.apache.maven.model.building.ModelProblemCollector;
import org.jetbrains.kotlin.org.apache.maven.model.interpolation.BuildTimestampValueSource;
import org.jetbrains.kotlin.org.apache.maven.model.interpolation.ModelInterpolator;
import org.jetbrains.kotlin.org.apache.maven.model.interpolation.PathTranslatingPostProcessor;
import org.jetbrains.kotlin.org.apache.maven.model.interpolation.ProblemDetectingValueSource;
import org.jetbrains.kotlin.org.apache.maven.model.interpolation.UrlNormalizingPostProcessor;
import org.jetbrains.kotlin.org.apache.maven.model.path.PathTranslator;
import org.jetbrains.kotlin.org.apache.maven.model.path.UrlNormalizer;
import org.jetbrains.kotlin.org.codehaus.plexus.interpolation.AbstractValueSource;
import org.jetbrains.kotlin.org.codehaus.plexus.interpolation.InterpolationPostProcessor;
import org.jetbrains.kotlin.org.codehaus.plexus.interpolation.MapBasedValueSource;
import org.jetbrains.kotlin.org.codehaus.plexus.interpolation.ObjectBasedValueSource;
import org.jetbrains.kotlin.org.codehaus.plexus.interpolation.PrefixAwareRecursionInterceptor;
import org.jetbrains.kotlin.org.codehaus.plexus.interpolation.PrefixedObjectValueSource;
import org.jetbrains.kotlin.org.codehaus.plexus.interpolation.PrefixedValueSourceWrapper;
import org.jetbrains.kotlin.org.codehaus.plexus.interpolation.RecursionInterceptor;
import org.jetbrains.kotlin.org.codehaus.plexus.interpolation.ValueSource;

public abstract class AbstractStringBasedModelInterpolator
implements ModelInterpolator {
    private static final List<String> PROJECT_PREFIXES = Arrays.asList("pom.", "project.");
    private static final Collection<String> TRANSLATED_PATH_EXPRESSIONS;
    @Inject
    private PathTranslator pathTranslator;
    @Inject
    private UrlNormalizer urlNormalizer;

    public AbstractStringBasedModelInterpolator setPathTranslator(PathTranslator pathTranslator) {
        this.pathTranslator = pathTranslator;
        return this;
    }

    public AbstractStringBasedModelInterpolator setUrlNormalizer(UrlNormalizer urlNormalizer) {
        this.urlNormalizer = urlNormalizer;
        return this;
    }

    protected List<ValueSource> createValueSources(Model model, final File projectDir, final ModelBuildingRequest config, ModelProblemCollector problems) {
        Properties modelProperties = model.getProperties();
        ValueSource modelValueSource1 = new PrefixedObjectValueSource(PROJECT_PREFIXES, model, false);
        if (config.getValidationLevel() >= 20) {
            modelValueSource1 = new ProblemDetectingValueSource(modelValueSource1, "pom.", "project.", problems);
        }
        ValueSource modelValueSource2 = new ObjectBasedValueSource(model);
        if (config.getValidationLevel() >= 20) {
            modelValueSource2 = new ProblemDetectingValueSource(modelValueSource2, "", "project.", problems);
        }
        ArrayList<ValueSource> valueSources = new ArrayList<ValueSource>(9);
        if (projectDir != null) {
            PrefixedValueSourceWrapper basedirValueSource = new PrefixedValueSourceWrapper(new AbstractValueSource(false){

                @Override
                public Object getValue(String expression2) {
                    if ("basedir".equals(expression2)) {
                        return projectDir.getAbsolutePath();
                    }
                    return null;
                }
            }, PROJECT_PREFIXES, true);
            valueSources.add(basedirValueSource);
            PrefixedValueSourceWrapper baseUriValueSource = new PrefixedValueSourceWrapper(new AbstractValueSource(false){

                @Override
                public Object getValue(String expression2) {
                    if ("baseUri".equals(expression2)) {
                        return projectDir.getAbsoluteFile().toPath().toUri().toASCIIString();
                    }
                    return null;
                }
            }, PROJECT_PREFIXES, false);
            valueSources.add(baseUriValueSource);
            valueSources.add(new BuildTimestampValueSource(config.getBuildStartTime(), modelProperties));
        }
        valueSources.add(modelValueSource1);
        valueSources.add(new MapBasedValueSource(config.getUserProperties()));
        if (config.getSystemProperties().containsKey("revision")) {
            modelProperties.put("revision", config.getSystemProperties().get("revision"));
        }
        if (config.getSystemProperties().containsKey("changelist")) {
            modelProperties.put("changelist", config.getSystemProperties().get("changelist"));
        }
        if (config.getSystemProperties().containsKey("sha1")) {
            modelProperties.put("sha1", config.getSystemProperties().get("sha1"));
        }
        valueSources.add(new MapBasedValueSource(modelProperties));
        valueSources.add(new MapBasedValueSource(config.getSystemProperties()));
        valueSources.add(new AbstractValueSource(false){

            @Override
            public Object getValue(String expression2) {
                return config.getSystemProperties().getProperty("env." + expression2);
            }
        });
        valueSources.add(modelValueSource2);
        return valueSources;
    }

    protected List<? extends InterpolationPostProcessor> createPostProcessors(Model model, File projectDir, ModelBuildingRequest config) {
        ArrayList<InterpolationPostProcessor> processors = new ArrayList<InterpolationPostProcessor>(2);
        if (projectDir != null) {
            processors.add(new PathTranslatingPostProcessor(PROJECT_PREFIXES, TRANSLATED_PATH_EXPRESSIONS, projectDir, this.pathTranslator));
        }
        processors.add(new UrlNormalizingPostProcessor(this.urlNormalizer));
        return processors;
    }

    protected RecursionInterceptor createRecursionInterceptor() {
        return new PrefixAwareRecursionInterceptor(PROJECT_PREFIXES);
    }

    static {
        HashSet<String> translatedPrefixes = new HashSet<String>();
        translatedPrefixes.add("build.directory");
        translatedPrefixes.add("build.outputDirectory");
        translatedPrefixes.add("build.testOutputDirectory");
        translatedPrefixes.add("build.sourceDirectory");
        translatedPrefixes.add("build.testSourceDirectory");
        translatedPrefixes.add("build.scriptSourceDirectory");
        translatedPrefixes.add("reporting.outputDirectory");
        TRANSLATED_PATH_EXPRESSIONS = translatedPrefixes;
    }
}

